/* t[Gϊ̃Cu fft.h */
#define FFT_MAX  2048       /* ől */
#define PI  3.141592653589  /* ~ */

/* ϐ */
double  data[FFT_MAX][FFT_MAX];   /* f[^̎ */
double jdata[FFT_MAX][FFT_MAX];   /* f[^̋ */
int num_of_data;          /* f[^̗vfԍ̍ől */

/* ֐̃vg^Cv */
int calc_power_of_two( int number );
void make_initial_data( double *re_part, double *im_part, 
  int num_of_data, int power );
void FFT1( double *re_part, double *im_part, int num_of_data, int flag );
void FFT2( int flag );

int calc_power_of_two( int number )
/* number Q̉ł邩ׂĕԂ */
/* j8 --> 3, 16 --> 4, 32 --> 5,... */
{
    int power = 0;

    while ( number != 1 ){
        power++;
        number = number / 2;
    }
    return power;
}

void make_initial_data( double *re_part, double *im_part, 
  int num_of_data, int power )
/* f[^ёւĎԂ̊Ԉɂ FFT ̏f[^ */
/* double *re_part, *im_part; f[^(C)̐擪AhX */
/* int num_of_data;           f[^                             */
/* int power;                 num_of_data ͂Q power             */
{
    int i, j;              /* ϐ                               */
    int ptr, offset;       /* f[^̗vfԍ߂邽߂̕ϐ   */
    int new_ptr;           /* vZ̃f[^z̗vfԍ */
    int dft;               /* DFT_ ( i ̃[vŔɂȂj */
    double re_buf[FFT_MAX], im_buf[FFT_MAX]; /* vZʗpz */

    dft = num_of_data;
    for (i=1; i<power; i++){
        /* i ͉񐔂𐧌䂷ϐivZɂ͗pĂȂj */
        new_ptr=0;  offset=0;
        while( new_ptr < num_of_data ){
            ptr=0;
            while( ptr < dft ){
                re_buf[new_ptr] = *(re_part + offset + ptr);
                im_buf[new_ptr] = *(im_part + offset + ptr);
                new_ptr ++;
                ptr = ptr + 2;
                if ( ptr == dft ) ptr=1;
            }
            offset = offset + dft;
        }
        /* vZʂ̃f[^zɃRs[ */
        for (j=0; j<num_of_data; j++){
            *(re_part + j) = re_buf[j];
            *(im_part + j) = im_buf[j];
        }
        dft = dft / 2;
    }
}

void FFT1( double *re_part, double *im_part, int num_of_data, int flag )
/* f[^ FFT (flag = 1), t FFT (flag = -1) s֐            */
/* double *re_part, *im_part; f[^(C)̐擪AhX */
/* int num_of_data, flag;     f[^CFFTEtFFT ߂tO  */
{
    int i, j, k, power;                         /* ϐCׂ */
    double unit_angle, step_angle;              /* pxp̕ϐ     */
    int dft, half, num_of_dft;   /* DFT_C̔CDFT s */
    int num_out, num_in1, num_in2;       /* DFT̓o͐M̔ԍ */
    double re_buf, im_buf, angle; /* CCpxpƕϐ */
                  /* ͌vZʂꎞIɕۑ邽߂̍Ɨpz */
    static double re_part_new[FFT_MAX], im_part_new[FFT_MAX];

    /* tFFT ( flg = -1 ) ̂Ƃef[^ num_of_data Ŋ */
    /* fƂ                                         */
    if ( flag == -1){
        for ( i = 0; i < num_of_data; i ++ ){
            *( re_part + i ) =   *( re_part + i ) / num_of_data;
            *( im_part + i ) = - *( im_part + i ) / num_of_data;
        }
    }
    /* num_of_data Q̉(power)ł邩ׂ */
    power = calc_power_of_two( num_of_data );
    /* f[^̂߂̌f[^̏Ԃ̓ւ */
    make_initial_data( re_part, im_part, num_of_data, power );
    /* 2_DFT, 4_DFT, 8_DFT, ... ̏Ɏs */
    unit_angle = 2.0 * PI / num_of_data;
    dft = 2;   /* = DFT ̓_̏lCQ{Ă䂭 */
    for ( i = 0; i < power; i ++ ){
        /* DFT _ DFT s                      */
        /* i=0 -> 2_, i=1 -> 4_, i=2 -> 8_, .... */
        num_of_dft = num_of_data / dft;   /* DFT ̎s */
        step_angle = unit_angle *  num_of_dft;
        half = dft / 2;
        for ( j = 0; j < num_of_dft; j ++ ){
            angle = 0.0;
            for ( k = 0; k < dft; k ++ ){
                /* No.num_in1  No.num_in2  No.num_out o */
                /* iWP̐̕M No.num_in1 ƂĂj  */
                num_out = j * dft + k;
                if ( k < half ){
                    num_in1 = num_out;
                    num_in2 = num_in1 + half;
                } else
                {
                    num_in2 = num_out;
                    num_in1 = num_out - half;
                }
                /* (re_)E(im_)ɕČvZ */
                re_buf = *( re_part + num_in2 );
                im_buf = *( im_part + num_in2 );
                re_part_new[num_out] = *( re_part + num_in1 ) 
                    + re_buf * cos(angle) + im_buf * sin(angle);
                im_part_new[num_out] = *( im_part + num_in1 ) 
                    + im_buf * cos(angle) - re_buf * sin(angle);
                /* pxXV */
                angle = angle + step_angle;
            }
        }
        /* vZ̃f[^̔zɖ߂ */
        for ( j = 0; j < num_of_data; j ++ ){
            *( re_part + j ) = re_part_new[j];
            *( im_part + j ) = im_part_new[j];
        }
        dft = dft * 2; /* DFT ̓_Q{ɍXV */
    }
    /* tFFT ( flg = -1 ) ̂Ƃef[^̕fƂ */
    if ( flag == -1 ){
        for ( j = 0; j < num_of_data; j ++ ){
            *( im_part + j ) = - *( im_part + j );
        }
    }
}

void FFT2( int flag )
/* f[^ data, jdata, num_of_data ɑĂg */
/* flag = 1 : Q FFT, flag = -1 : Qt FFT        */
{
    int i, j; /* [vϐ */
    static double re[FFT_MAX], im[FFT_MAX]; /* ƕϐ */

    for (i=0; i<num_of_data; i++){
        for (j=0; j<num_of_data; j++){
            re[j]=data[i][j];  im[j]=jdata[i][j];
        }
        FFT1( re, im, num_of_data, flag );
        for (j=0; j<num_of_data; j++){
             data[i][j]=re[j];  jdata[i][j]=im[j];
        }
    }
    for (i=0; i<num_of_data; i++){
        for (j=0; j<num_of_data; j++){
            re[j]=data[j][i];  im[j]=jdata[j][i];
        }
        FFT1( re, im, num_of_data, flag );
        for (j=0; j<num_of_data; j++){
             data[j][i]=re[j];  jdata[j][i]=im[j];
        }
    }
}
