/* k-means.h  ̃vO̖O */
#include<time.h>  /* for  */
#define MAXLABEL   500  /* ő̌Ǘ̈搔 */
#define MAXDIM     5  /* lxNg̍ő原 */
#define MAXCLASS    10  /* lők(NX) */
double fvector[MAXLABEL][MAXDIM];   /* xNgQ */
double rvector[MAXCLASS][MAXDIM];    /* \xNg   */
int codebook[MAXLABEL];  /* exNg̃R[hubN */

double _distance( int rn, int fn, int dim );
void k_means_clustering( int number, int dim, int classnum );

double _distance( int rn, int fn, int dim )
/* \xNgNo.rn ƁC1̓xNg(No.fn)Ƃ */
/* ̂QԂ֐Ddim < MAXLABEL OƂD */
{
    double sum=0.0;
    int i;

    for(i=0;i<dim;i++)
    sum+=(rvector[rn][i]-fvector[fn][i])*(rvector[rn][i]-fvector[fn][i]);
    return sum;
}

void k_means_clustering( int number, int dim, int classnum )
/* k-means @DnumberFxNg < MAXLABEL */
/* dimFxNg̎, classnum:NX(k-means  k) */
{
    int i,j,k,n,change,count=1,minnum;
    double min,dist,member;

    printf("number = %d\n",number);
    if (number > MAXLABEL){
        printf("̈搔zől𒴂Ă܂D\n");  exit(1);
    } else if ( dim < 1 || dim > MAXDIM ){
        printf("̎(=dim)sK؂ł\n");  exit(1);
    } else if ( classnum > MAXCLASS || classnum == 1 ){
        printf("NX(=k)sK؂ł\n");  exit(1);
    } else {
        /* \xNǧi_ɑIԁj */
        srand(time(NULL));
        for(i=0;i<number;i++) codebook[i] = -1;
        for(i=0;i<classnum;i++){
            do{  n = rand() % number;  }while(codebook[n] != -1);
            for(j=0;j<dim;j++) rvector[i][j] = fvector[n][j];
            codebook[n] = i;
        }
        /* k-ϖ@ɂNX^O */
        do{
          change = 0;
          printf("\xNg̍XVF%d\n",count);
          /* exNg̃R[hubNXV */
          for(i=0;i<number;i++){  /* ëɂĒׂ */
            min = _distance(0,i,dim); minnum = 0; /*  */
            for(j=1;j<classnum;j++){ /* 1`classnum-1܂ł𒲍 */
              dist = _distance(j,i,dim);
              if ( dist < min ){
                min = dist;  minnum = j;
              }
                } /* ̈i̓NXminnumɏƌ */
                if ( codebook[i] != minnum ){
                    change = 1; /* R[hubNXVꂽ */
                    codebook[i] = minnum;
                }
            }
            /* \xNgXV */
            if ( change ){
              for(i=0;i<classnum;i++){
                /* eNX̃o[̔c */
                member=0;
                for(j=0;j<number;j++)
                  if (codebook[j]==i) member++;
                  /* xNg̕ςɒu */
                  for(j=0;j<dim;j++) rvector[i][j]=0.0;
                  for(k=0;k<number;k++)
                    if (codebook[k]==i)
                      for(j=0;j<dim;j++)
                        rvector[i][j] += fvector[k][j] / member;
             }
             count++;
          }
        }while( change );
    }
}
