/* K摜(pgm`)pCu pgmlib.h */
#include<stdlib.h>
#include<string.h>

/* 萔錾 */
#define MAX_IMAGESIZE       1280 /* z肷cE̍őf */
#define MAX_BRIGHTNESS       255 /* z肷őKl */
#define GRAYLEVEL            256 /* z肷K(=őKl+1) */
#define MAX_FILENAME         256 /* z肷t@C̍ő咷 */
#define MAX_BUFFERSIZE       256 /* pobt@ő咷 */
#define MAX_NUM_OF_IMAGES      5 /* p摜̖ */

/* ϐ̐錾 */
/* 摜f[^ image[n][x][y] */
unsigned char image[MAX_NUM_OF_IMAGES][MAX_IMAGESIZE][MAX_IMAGESIZE];
/* image[n] ̉Ec */
int width[MAX_NUM_OF_IMAGES], height[MAX_NUM_OF_IMAGES];

/* ֐̃vg^Cv錾 */
/* K摜͂֐ */
void load_image( int n, char name[] );
  /* n:摜ԍCname[]:t@Ci""̂Ƃ̓L[{[h́j*/
/* K摜o͂֐*/
void save_image( int n, char name[] );
  /* n:摜ԍCname[]:t@Ci""̂Ƃ̓L[{[h́j*/
/* K摜Rs[֐*/
void copy_image( int n1, int n2 );
  /* 摜No.n1  摜No.n2ɃRs[ */
/* K摜֐*/
void init_image( int n, unsigned char value );
  /* 摜No.n̑Sf̊KlIvalue(0`255)ɂ */

/* K摜͂֐ */
void load_image( int n, char name[] )
/* n:摜ԍCname[]:t@Ci""̂Ƃ̓L[{[h́j*/
/* Cc͂ꂼ width[n], height[n] ɑ */
{
    char file_name[MAX_FILENAME]; /* t@Cp̕z */
    char buffer[MAX_BUFFERSIZE];  /* f[^ǂݍݗpƕϐ */
    FILE *fp; /* t@C|C^ */
    int max_gray; /* őKl */
    int x, y; /* [vϐ */

    /* ̓t@C̃I[v */
    if ( name[0] == '\0' ){
        printf("̓t@C (*.pgm) : ");
        scanf("%s",file_name);
    } else strcpy( file_name, name );
    if ( (fp = fopen( file_name, "rb" ))==NULL ){
        printf("̖Õt@C݂͑܂D\n");
        exit(1);
    }
    /* t@C^Cv(=P5)̊mF */
    fgets( buffer, MAX_BUFFERSIZE, fp );
    if ( buffer[0] != 'P' || buffer[1] != '5' ){
        printf("t@C̃tH[}bg P5 Ƃ͈قȂ܂D\n");
        exit(1);
    }
    /* width[n], height[n] ̑i#n܂Rg͓ǂݔ΂j */
    width[n] = 0;    height[n] = 0;
    while ( width[n] == 0 || height[n] == 0 ){
        fgets( buffer, MAX_BUFFERSIZE, fp );
        if ( buffer[0] != '#' )
            sscanf( buffer, "%d %d", &width[n], &height[n] );
    }
    /* max_gray ̑i#n܂Rg͓ǂݔ΂j */
    max_gray = 0;
    while ( max_gray == 0 ){
        fgets( buffer, MAX_BUFFERSIZE, fp );
        if ( buffer[0] != '#' )
            sscanf( buffer, "%d", &max_gray );
    }
    /* p[^̉ʂւ̕\ */
    printf("̉f = %d, c̉f = %d\n", width[n], height[n] );
    printf("őKl = %d\n",max_gray);
    if ( width[n] > MAX_IMAGESIZE || height[n] > MAX_IMAGESIZE ){
        printf("zl %d x %d 𒴂Ă܂D\n", 
            MAX_IMAGESIZE, MAX_IMAGESIZE);
        printf("ȉ摜gĉD\n");
        exit(1);
    }
    if ( max_gray != MAX_BRIGHTNESS ){
        printf("őKlsK؂łD\n");  exit(1);
    }
    /* 摜f[^ǂݍŉ摜pzɑ */
    for(y=0;y<height[n];y++)
        for(x=0;x<width[n];x++)
            image[n][x][y] = (unsigned char)fgetc( fp );
    fclose(fp);
    printf("摜͐ɓǂݍ܂܂D\n");
}

/* K摜o͂֐*/
void save_image( int n, char name[] )
/* n:摜ԍCname[]:t@Ci""̂Ƃ̓L[{[h́j*/
/* 摜̉Cc͂ꂼ width[n], height[n] ɑĂ̂Ƃ */
{
    char file_name[MAX_FILENAME]; /* t@Cp̕z */
    FILE *fp; /* t@C|C^ */
    int x, y; /* [vϐ */

    /* o̓t@C̃I[v */
    if ( name[0] == '\0' ){
        printf("o̓t@C (*.pgm) : ");
        scanf("%s",file_name);
    } else strcpy( file_name, name );
    if ( (fp = fopen(file_name, "wb"))==NULL ){
        printf("t@CI[vł܂D\n");
        exit(1);
    }
    /* t@Cʎq "P5" 擪ɏo͂ */
    fputs( "P5\n", fp );
    /* # Ŏn܂Rgsiȗ\j */
    fputs( "# Created by Image Processing\n", fp );
    /* 摜̉Cc̏o */
    fprintf( fp, "%d %d\n", width[n], height[n] );
    /* őKl̏o */
    fprintf( fp, "%d\n", MAX_BRIGHTNESS );
    /* 摜f[^̏o */
    for(y=0;y<height[n];y++)
        for(x=0;x<width[n];x++)
            fputc( image[n][x][y], fp );
    fclose(fp);
    printf("摜͐ɏo͂܂D\n");
}

/* K摜Rs[֐*/
void copy_image( int n1, int n2 )
/* 摜No.n1摜No.n2ɃRs[ */
{
    int x, y; /* [vϐ */

    /* Cc̑ */
    width[n2] = width[n1];    height[n2] = height[n1];
    /* Kf[^̃Rs[ */
    for(y=0;y<height[n1];y++)
        for(x=0;x<width[n1];x++)
            image[n2][x][y] = image[n1][x][y];
}

/* K摜֐*/
void init_image( int n, unsigned char value )
/* 摜No.n̑Sf̊KlIvalue(0`255)ɂ */
{
    int x, y; /* [vϐ */

    for(y=0;y<height[n];y++)
        for(x=0;x<width[n];x++)
            image[n][x][y] = value;
}
