/* J[摜(ppm`)pCu ppmlib.h */
#include<stdlib.h>
#include<string.h>

/* 萔錾 */
#define MAX_IMAGESIZE 1280 /* z肷cE̍őf */
#define MAX_BRIGHTNESS  255 /* z肷őKl */
#define GRAYLEVEL    256 /* z肷K(=őKl+1) */
#define MAX_FILENAME  256 /* z肷t@C̍ő咷 */
#define MAX_BUFFERSIZE  256 /* pobt@ő咷 */
#define MAX_NUM_OF_IMAGES  5 /* p摜̖ */

/* ϐ̐錾 */
/* 摜f[^ image[n][x][y][col] (col=0:R, =1:G, =2:B) */
unsigned char image[MAX_NUM_OF_IMAGES]
[MAX_IMAGESIZE][MAX_IMAGESIZE][3];
int width[MAX_NUM_OF_IMAGES],
 height[MAX_NUM_OF_IMAGES];

/* ֐̃vg^Cv錾 */
void load_color_image( int n, char name[] );
void save_color_image( int n, char name[] );
void copy_color_image( int n1, int n2 );
void init_color_image( int n, int red, int green, int blue );

void load_color_image( int n, char name[] )
/* J[摜No.nóDname[]""Ȃt@ĆD*/
{
    char fname[MAX_FILENAME]; /* t@Cp̕z */
    char buffer[MAX_BUFFERSIZE];  /* f[^Ǎݗpϐ */
    FILE *fp; /* t@C|C^ */
    int max_gray=0,x,y,col; /* őKlƃ[vϐ */

    /* ̓t@C̃I[v */
    if ( name[0]=='\0' ){
        printf("̓t@C (*.ppm) : ");  scanf("%s",fname);
    } else strcpy( fname, name );
    if ( (fp = fopen( fname, "rb" ))==NULL ){
        printf("t@CI[vł܂ł\n");
        exit(1);
    }
    fgets( buffer, MAX_BUFFERSIZE, fp );
    if ( buffer[0]!='P' || buffer[1]!='6' ){  /* P6̊mF */
        printf("t@C^CvP6ł͂܂\n"); exit(1);
    }
    /* width[n], height[n] ̑i#̃Rg͔΂j*/
    width[n] = 0;  height[n] = 0;
    while ( width[n] == 0 || height[n] == 0 ){
        fgets( buffer, MAX_BUFFERSIZE, fp );
        if ( buffer[0] != '#' ) 
            sscanf( buffer, "%d %d", &width[n], &height[n] );
    }
    /* max_gray ̑i#̃Rg͓ǂݔ΂j */
    while ( max_gray == 0 ){
        fgets( buffer, MAX_BUFFERSIZE, fp );
        if ( buffer[0] != '#' ) sscanf( buffer, "%d", &max_gray );
    }
    /* p[^̉ʂւ̕\ */
    printf("F%d, cF%d\n", width[n], height[n] );
    printf("őKl = %d\n",max_gray);
    if ( width[n] > MAX_IMAGESIZE || height[n] >
        MAX_IMAGESIZE ||
        max_gray != MAX_BRIGHTNESS ){
        printf("TCYőKlsK؂ł\n");  exit(1);
    }
    /* 摜f[^ǂݍŉ摜pzɑ */
    for(y=0;y<height[n];y++)
        for(x=0;x<width[n];x++)
            for(col=0;col<3;col++)
              image[n][x][y][col] = (unsigned char)fgetc( fp );
    printf("J[摜摜No.%dɓǂݍ݂܂D\n",n);
    fclose(fp);
}

void save_color_image( int n, char name[] )
/* n:摜ԍCname[]:t@Ci""̂Ƃ̓L[{[h́j*/
/* 摜̉Cc͂ꂼ width[n], height[n] ɎO  */
/* Ă̂Ƃ */
{
    char fname[MAX_FILENAME]; /* t@Cp̕z */
    FILE *fp; /* t@C|C^ */
    int x, y, col; /* [vϐ */

    if ( name[0] == '\0' ){
        printf("o̓t@C (*.ppm) : ");  scanf("%s",fname);
    } else strcpy( fname, name );
    if ( (fp = fopen(fname, "wb"))==NULL ){
        printf("t@CI[vł܂ł\n");
        exit(1);
    }
    fputs( "P6\n", fp ); /* ʎq */
    fputs( "# Created by Image Processing\n", fp ); /* Rg */
    fprintf( fp, "%d %d\n", width[n], height[n] ); /* TCY */
    fprintf( fp, "%d\n", MAX_BRIGHTNESS ); /* őKl */
    /* 摜f[^̏o */
    for(y=0;y<height[n];y++)
        for(x=0;x<width[n];x++)
            for(col=0;col<3;col++)
                fputc( image[n][x][y][col], fp );
    fclose(fp);
    printf("摜͐ɏo͂܂D\n");
}

void copy_color_image( int n1, int n2 )
/* J[摜No.n1J[摜No.n2ɃRs[ */
{
    int x, y, col; /* [vϐ */

    /* Cc̑ */
    width[n2] = width[n1];  height[n2] = height[n1];
    /* eF̊Kf[^̃Rs[ */
    for(y=0;y<height[n1];y++)
        for(x=0;x<width[n1];x++)
            for(col=0;col<3;col++)
                image[n2][x][y][col] = image[n1][x][y][col];
}

void init_color_image( int n, int red, int green, int blue )
/* J[摜No.n̑Sf̐F */
/* -1ƂF͏ΏۊOƂ     */
{
    int x, y; /* [vϐ */

    for(y=0;y<height[n];y++)
        for(x=0;x<width[n];x++){
            if (red   != -1) image[n][x][y][0] = red;
            if (green != -1) image[n][x][y][1] = green;
            if (blue  != -1) image[n][x][y][2] = blue;
        }
}
