/*  P	SASւ̓  ***************************/
/* pgm 1.1.1.1 */
data ex111;
   input id gender $ height weight;
   hyoujun = (height - 100) * 0.9;
   bmi = weight/((height / 100)**2) ;
   himando1 = (weight - hyoujun) / hyoujun * 100;
   if himando1 > 20 then himan1 = 1;
   else himan1 = 0;
   cards;
1	m	160	70
2	m	176	78
3	f	153	50
4	f	167	55
5	m	158	53
6	f	163	52
7	f	167	72
8	m	174	83
9	m	176	92
10	f	152	54
;
run;
proc print data=ex111;
run;

/* pgm 1.1.1.2 */
proc means data = ex111 n mean std var min max range maxdec=3 ;
    var height weight;
proc freq data = ex111;
    tables gender himan1;
run;

/* pgm 1.1.2.1 */
data ex112;
 length  smoking $ 10;
 input cancer $ smoking $ count;
cards;
no  smokers 32
no  nonsmokers 11
yes smokers 60
yes nonsmokers 3
;
run;
proc freq data=ex112;
 tables cancer * smoking;
 weight count;
run;

/* pgm 1.1.3.1 */
data ex113;
 do x = -3 to 3 by 0.01;
   y=sin(cos(-x**2));
   output;
 end;
 run;
proc gplot data=ex113;
 plot y*x;
 symbol i=join v=none;
run; 
quit;

/* pgm 1.1.3.2 */
data ex114;
do x = -3 to 3 by 0.1;
  do y = -3 to 3 by 0.1;
   z=sin(sqrt(x**2 + y**2));
   output;
  end;
end;
run;
proc g3d data=ex114;
 plot y*x = z /rotate=30 tilt=45;
run; 
quit;

/* pgm 1.1.3.3 */
data rnorm1;
 do i= 1 to 1000;
   z =rannor(12345);
 output;
 end;
run;
title font=times '1000 random observations from';
title2 font =times 'Standard Normal Distribution';
proc gchart data=rnorm1;
 vbar z ;
run; 
quit;

/* pgm 1.2.2.1 */
data ex121;
 input  x  y1  y2  z  $;
cards;
 1   2   3  a 
-1  -2  -3  b 
 0   1  10  c 
 5  12  29  c
;
run;
title 'Result of program 1.2.2.1'; 
proc print data=ex121;
 var  y1  z ;
run;

/* pgm 1.2.2.2 */
data;
length name $ 20;
input name & $;
cards;
abcdefgh ijklmnopqrstuvwxyz
;
title 'Result by program 1.2.2.2'; 
proc print;
run;

/* pgm 1.2.2.3 */
data; 
 input @1 v1 1. @2 v2 1. @3 v3 1.
 @4 v4 1. @6 age 2. @9 gender $1.;
cards;
1231 23 F
2143 19 F
2214 18 M
3111 20 M
2144 22 F
;
run;
title 'Result by program 1.2.2.3' ;
proc print;
run;

/* pgm 1.2.2.4 */
data;
input @1 (v1-v4) (1.)  
 @6  age   @9  gender $;
datalines;
1231 23 F
2143 19 F
2214 18 M
3111 20 M
2144 22 F
;
title 'Result by program 1.2.2.4' ;
proc print;
run;

/* pgm 1.2.2.5 */
data; 
input  (v1-v4) (1.) @4 (v4) (1.)
   @6 (age) (2.) @9 (gender) ($1.);
datalines;
1231 23 F
2143 19 F
2214 18 M
3111 20 M
2144 22 F
 ;
title 'Result by program 1.2.2.5' ;
proc print;
run;  

/* pgm 1.2.2.6 */
data; 
 input  v1 1 v2 2 v3 3 v4 4 age 6-7 gender $ 9;
cards;
1231 23 F
2143 19 F
2214 18 M
3111 20 M
2144 22 F
;
title 'Result by program 1.2.2.6' ;
proc print;
run;

/* pgm 1.2.2.7 */
data; 
input #1 (id) (3.) @5 (v1-v4) (1.) 
  #2 @6 (age) (2.) @9 (gender) ($1.);
cards;
001 1231 
001  23 F
002 2143 
002  19 F
003 2214
003  18 M
004 3111
004  20 M
005 2144 
005  22 F
 ;
title 'Result by program 1.2.2.7';
proc print;
run; 
  
/* pgm 1.2.2.8 */
data;
input @1 name $ @10 birthday yymmdd10. @22 salary comma6.;
cards;
Randy    1963/07/29  75,000
Tom      1975/03/16  65,000
;
title 'birthday and salary data' ;
proc print;
run;

/* pgm 1.2.2.9 */
data;
input x 3.1 @7 y 4.;
cards;
123   123
12.3  12.3
;
title 'Result by program 1.2.2.9' ;
proc print;run;

/* pgm 1.2.2.10 */
data;
input y $char7. z $;
cards;
a b cd   e
a b  cd   e
;
run; 
title 'Result by program 1.2.2.10' ;
proc print;run;

/* pgm 1.3.1.1 */
data ex131;
length city $ 10;
input city $ temp;
 temF=32 + temp*9/5;
cards;
Tokyo 22
NewYork 17
Sydney 3 
Honolulu 30
;
title 'temperature list by city';
proc print ;
run;

/* pgm 1.3.1.2 */
data ex132;
input gender $ height weight age;
if gender ="m" then
  cal = 66+ 13.7*weight+ 5*height - 6.8*age;
 else if gender ="f" then
  cal = 655+ 9.6*weight+ 1.7*height - 7*age;
cards;
m 160 70 25
m 170 65 30
m 155 52 16
f 155 40 21
f 160 58 35
;
title 'basal metabolism rate' ;
proc print;
run;

/* pgm 1.3.1.3 */
data;
input x y $;
if y in ('a','c') then z=10;else z=0;
cards;
1 a
2 a
3 b
4 b
5 c
;
title 'Result by program 1.3.1.3';
proc print;run;

/* pgm 1.3.1.4 */
data;
input x ;
select(x);
when(1) z=10;
when(2) z=20;
when(3) z=30;
otherwise z=0;
end;
cards;
1
2
3
4
5
;
title 'Result by program 1.3.1.4';
proc print;run;

/* pgm 1.4.1.2 */
data s1;
input a b;
cards;
1 22
3 12
7 34
3 76
4 65
2 56
;
title 's1 dataset';
proc print data=s1 ;
run;
proc sort data=s1 out=s2;
by a;
title 's2 dataset - sorted data';
proc print data=s2;run;

/* Ṕ@t^ **************************************************/
/* `DSASœ{g       *********************************/
options  validvarname = any ;
data totals;
   length   $ 5  n $ 4 ;
   input    n  l  グ ;
cards;
1      1 70430
1   @ 1 82255
1      1 55436
;
run;
title  'nʔグ';
goptions ftext= 'MS UI Gothic'  ftitle= 'MS UI Gothic'  htext=1.5 ;
proc  gchart  data=totals ;  
  format  グ yen8. ; 
  vbar3d  n / sumvar = グ  width=20 ; 
run; quit; 



/* Q́@mz **********************************/
/* QDP@U^mz  ***************************/

/* pgm 2.1.1.1 */
data b1;
p=0.2;
 do x= 0 to 1;
  pf =(p**x)*(1-p)**(1-x);
  output;
  end;
run;
goptions ftext='times' ftitle='times' htext=1.6;
title1 'Bernoulli Distribution';
title2  height=1.8  'with p=0.2';
symbol1 interpol=needle width=3 height=1.5 value=star;
axis1 label=('Probability')  order=(0 to 1 by 0.2) ;
axis2 order=(-0.5 to 1.5 by 0.5)  ;
proc gplot data=b1;
 plot pf *x / vaxis=axis1 haxis=axis2;
run;
quit;

/* pgm 2.1.1.3 */
data;
file print;
n=30;k=3;
do j=1 to k;
sum=0;
do i=1 to n;
y=ranbin(0,1,0.5);
if y=0 then coin="T";
if y=1 then coin="H";
sum=sum+y;
put coin $ @;
end;
put / @5 "total number of heads=" sum ", out of " n "trials"/;
end;
run;

/* pgm 2.1.2.1 */
data b2;
p=0.2; 
n=10;
do x = 0 to n;
  if x=0 | x=n then c=1;
   else c=gamma(n+1)/(gamma(x+1)*gamma(n-x+1));
   pf =c*(p**x)*((1-p)**(n-x));
   output;
  end;
 run;
goptions ftext='times' ftitle='times' ;
title1 'Binominal Distribution';
title2 h=1.7 'with p=0.2, n=10';
symbol1 interpol=needle width=3 height=1.5 value=star;
axis1 label=(h=1.7 'Probability')  order=(0 to 1 by 0.2) value=(h=1.6);
axis2 label=(h=1.7)  value=(h=1.6) offset=(3);
proc gplot data =b2;
 plot pf *x / vaxis =axis1 haxis=axis2;
run;
quit;

/* pgm 2.1.3.1 */
data p1;
 m=3;
 do x = 0 to 10;
  if x = 0 then pf = poisson(m, x);
   else
   pf = poisson(m,x) - poisson(m,x-1);
 output;
 end;
 run;
title1 'Poisson Distribution';
title2 h=1.6  'with m=3';
symbol1 interpol=needle width=3 height=1.2  width=1.5 value=star;
axis1 label=('Probability')  order=(0 to 1 by 0.2) ;
axis2 offset=(3) ;
proc gplot data =p1;
 plot pf*x / vaxis =axis1 haxis=axis2;
run;
quit;


/* QDQ@Amz ***********************************/
/* pgm 2.2.1.1 */
data n1;
 c= 1/sqrt(2*3.141592654);
 do x= -3 to 3 by 0.01;
   pdf= c*exp(-(x**2)/2);
   output;
  end;
run;
goptions ftext='times' ftitle='times' htext=1.7;
title 'Standard Normal Distribution';
symbol1 interpol=join value=none width=1.5 c=black;
axis1 label=( 'Density') order=(0 to 0.4 by 0.1) ;
proc gplot data =n1;
 plot pdf*x / vaxis =axis1;
run;
quit;

/* pgm 2.2.1.3 */
data n1r;
do i =1 to 1000;
  x=rannor(0);
  output;
end;
run;
goptions ftext='times' ftitle='times' htext=1.3;
title1 h=1.6  '1000 random observations from';
title2 h=1.6  'Standard Normal Distribution';
proc gchart data=n1r;
 vbar x / space=0  width=8;  
pattern c=blue v=x2;
run;
quit;

/* pgm 2.2.1.4 */
data n2;
do v=0.5,1,3;
  c = 1/sqrt(2*3.141592654*v);
   do x = -4 to 4 by 0.01;
     pdf = c*exp(-(x**2)/(2*v));
     output;
   end;
 end;
title1 h=1.6 'Normal Distribution';
title2 h=1.6 'mean=0, var=0.5, 1, 3';
symbol1 interpol=join value=none l=1  w=1.5 c=black;
symbol2 interpol=join value=none l=2  w=1.5 c=black;
symbol3 interpol=join value=none l=4  w=1.5 c=black;
axis1 label=( 'Density') order=(0 to 0.6 by 0.1);
proc gplot data=n2;
 plot pdf*x = v / vaxis=axis1;
run;
quit;

/* pgm 2.2.4.1 */
data mnormal;
 r= 0;
 c= 2*3.14159*sqrt(1-r**2);
 do x= -3 to 3 by 0.1;
   do y= -3 to 3 by 0.1;
     z= (1/c)*exp(-(x**2-2*r*x*y+y**2)/(2*(1-r**2)));
     output;
   end;
 end;
run;
goptions ftext='times' ftitle='times' htext=1.6 ;
title h=2 'Bivariate Normal Distribution';
proc g3d data=mnormal;
 plot y*x=z / rotate=60 tilt=45;
run; 
quit;	


/* Ŕ@f[^̗v ***************************************/
data ex311;
input id gender $ math eng;
label  math='w̓_'
       eng='p̓_';
cards;
 1 f 58 60
 2 f 87 79
 3 m 40 56
 4 m 95 55
 5 f 67 72
 6 f 55 62
 7 m 74 48
 8 m 42 35
 9 m 51 65
10 f 78 80
11 m 48 61
12 f 72 68
13 f 91 86
14 m 95 78
15 m 85 69
16 f 72 83
17 f 64 92 
18 m 78 62
;
proc freq data=ex311;
 table gender math eng;
run; 

/* pgm 3.1.2 */
proc format;
 value $genfmt 'f'='Female' 'm'='Male';
 value ggroup
   low-59='0-59'
    60-69='60-69'
    70-79='70-79'
    80-high='80-100';
run;
proc freq data=ex311;
 table gender math eng;
 format gender $genfmt. math ggroup. eng ggroup.;
run;

/* pgm 3.2.1 */
goptions ftext='MS UI Gothic'  ftitle='times';
title 'bar chart for mathematics and english';
pattern c=blue v=x2;
proc gchart data=ex311;
 hbar math eng /space=0;
run;
quit;

/* pgm 3.3.5 */
data ex312;
 set ex311;
 if math >=80 then mgrade ='A';
  else if 70<= math < 80 then mgrade ='B';
  else if 60<= math < 70 then mgrade ='C';
  else if math < 60 then mgrade ='D';
 if eng >=80 then egrade ='A';
  else if 70<= eng < 80 then egrade ='B';
  else if 60<= eng < 70 then egrade ='C';
  else if eng < 60 then egrade ='D';
run;
title 'math grade and english grade' ;
proc print data=ex312;
run;

/* pgm 3.3.6 */
title 'Frequency Distribution';
proc freq data=ex312;
 table gender  mgrade  egrade;
run;

/* pgm 3.4.1.1 */
data ex311a;
set ex311;
dummy=1;
goptions ftext='MS UI Gothic' ftitle='times';
title 'Box Plot';
proc boxplot data=ex311a;
plot (math eng)*dummy;
run;
quit;

/* pgm 3.4.1.2 */
proc sort data=ex311;
by gender;
run;
title 'Box Plot';
axis1 label=(h=1.5) value=(h=1.5);
axis2 label=(h=1.5 '') value=(h=1.5);
proc boxplot data=ex311;
plot (math eng)*gender
/ vaxis=axis1 haxis=axis2 
vref=60;
run;
quit;

/* pgm 3.4.3.1 */
goptions ftext='MS UI Gothic' ftitle='times';
symbol v=plus c=black;
data ex3n;
n=100;dummy=1;
do i=1 to n;
x=rannor(0);
output;
end;
title 'probability plot';
*title 'quantile-quantile plot' ; 
proc univariate data=ex3n;
var x;
probplot x/normal;
*qqplot x/normal;
run;quit;
title 'BoxPlot';
proc boxplot data=ex3n;
plot x*dummy;
run;

/* pgm 3.5.2 */
goptions ftext='MS UI Gothic' ftitle='times';
title 'math vs. english by gender';
symbol v=triangle i=none c=blue h=1.7 pointlabel=('#id')  ;
proc sort data=ex311;
 by gender ;
proc gplot data=ex311;
 plot math*eng ;
 by gender ;
run;
quit;

/* pgm 3.5.3 */
goptions ftext='MS UI Gothic' ftitle='times';
title 'math vs. english by gender';
proc gplot data=ex311;
 plot math*eng=gender ;
symbol1 v=triangle i=none c=red h=1.7 pointlabel=('#id') ;
symbol2 v=square  i=none c=green h=1.7 pointlabel=('#id') ;
run;
quit;

/* pgm 3.6.3 */
data cor1;
do x=-5 to 5 ;
y=1+2*x;
ym=1-x;
y2=x*x;
output;
end;
run;
ods html;
ods graphics on;
proc corr data=cor1 noprob nosimple plots=matrix;
var x; with y ym y2;
run;
ods graphics off;
ods html close;

/* pgm 3.6.4 */
goptions reset=all;
goptions ftext='times' ftitle='times'  htext=2 htitle=3;
symbol v=dot i=none c=black;
data ex314;
mx=0;my=0;
sx=1;sy=1;
n=200;
do r= -0.9, -0.8,-0.4,-0.2,
0, 0.2, 0.3, 0.5,0.6,0.8,0.9,1;
do i=1 to n;
z1=rannor(0);
z2=rannor(0);
x=sx*z1+mx;
y=sy*(r*z1+sqrt(1-r**2)*z2)+my;
output;
end;
end;
proc sort data=ex314;
by r;
proc gplot data=ex314 gout=gc1;
plot y*x;
by r;
run;quit;
goptions display;
proc greplay nofs igout=gc1 tc=sashelp.templt;
template=l2r2s;
treplay 1:gplot 2:gplot2 3:gplot1 4:gplot3;
treplay 1:gplot4 2:gplot6 3:gplot5 4:gplot7;
treplay 1:gplot8 2:gplot10 3:gplot9 4:gplot11;
run;quit;


/*** S W{z *********************************/
/* pgm 4.1.1.1 */
goptions reset=all;
goptions ftext='MS UI Gothic';
pattern c=blue v=x2;
symbol v=star c=black;

title1 f='Times' 'Dist. of Sample means of Random Samples';
title2 f='Times' h=1.5 'from Standard Normal Distributions';
title3 f='Times' h=1.5 'of size 4 and 10000 iterations';

data ex411;
 it=10000; size=4;
 do i=1 to it;
  sumz=0;
   do j= 1 to size; 
    z=rannor(0);
    sumz=sumz+z;
   end;
  xbar=sumz/size;
  output;
 end;
run;
proc means data=ex411 vardef=n;
  var xbar;
run;
proc univariate data=ex411 noprint;
histogram xbar/normal;
qqplot xbar;
run;

/* pgm 4.1.1.2 */
data ex411a;
 it=10000; size=4;
 do i=1 to it;
   do j= 1 to size; 
    z=rannor(0);
  output;
  end;
 end;
run;
proc means data=ex411a mean noprint;
  var z;
  by i;
  output out=outmean mean=xb;
run;
proc means data=outmean vardef=n;
var xb;
run;

/* pgm 4.1.1.3 */
goptions ftitle='Times' ftext='Times';
pattern c=blue v=x2;
title  'Dist. of Random Samples';
title2  h=1.5 'Standard Normal Distributions';
title3  h=1.5 'of size 4';
data ex411b;
 size=4;
  do i = 1 to size;
   z=rannor(0);
   output;
  end;
run;
proc means data=ex411b vardef=n;
 var z;
run;
proc gchart data=ex411b;
 hbar z /
 maxis=axis1 axis=axis1 space=0;
 axis1 label=(h=1.5)  value=(h=1.5) ; 
run;
quit;

/* pgm 4.1.5.1 */
data ex415;
it=100; size=10;
 do i = 1 to it;
 sumz=0;
  do j= 1 to size;
   z =ranbin(0,1,0.5);
   sumz=sumz+z;
   end;
  xbar=sumz/size;
  output;
 end;
run;
goptions ftitle='Times' ftext='MS UI Gothic'; 
title  'RC̕\o銄';
title2 h=1.5 '100lRCꂼ10񓊂';
proc gplot data=ex415;
plot xbar*i /
  vaxis=axis1 haxis=axis2
  vref = 0.5  cvref = red 
;
symbol i=join v=none ;
axis1 order=(0 to 1 by 0.2) value=(h=1.2);
axis2 label=(h=1.2 'RC100l') ; 
run; quit;

/* pgm 4.2.1 */
goptions reset=all;
goptions ftext='MS UI Gothic';
pattern c=blue v=x2;
symbol v=star c=black;
title  f='Times' 'Dist. of Sample variance of Random Samples';
title2 f='Times' h=1.5 'from Standard Normal Distributions';
title3 f='Times' h=1.5 'of size 4 and 10000 iterations';

data ex421;
it=10000; size=4;
 do i=1 to it;
  sumz=0 ;sumz2=0;
   do j= 1 to size; 
    z=rannor(0);
    sumz=sumz+z;
    sumz2=sumz2+z**2;
   end;
  xbar=sumz/size;
  xdev=sumz2-(sumz)**2/size;
  svar=xdev/size;
  uvar=xdev/(size-1);
  output;
 end;
run;
proc means data=ex421 vardef=n;
 var svar uvar;
run;
proc univariate data=ex421 noprint;
histogram xdev / gamma(alpha=1.5,scale=2);
qqplot xdev / gamma(alpha=1.5,scale=2);
run;

/* pgm 4.2.2 */
goptions  reset=all;
goptions  ftext='MS UI Gothic';
pattern  c=blue  v=x2;
symbol  v=star  c=black;
title   f='Times'  'Dist. of Sample variance of Random Samples';
title2  f='Times' h=1.5  'from(0,1) Uniform Distributions';
title3  f='Times' h=1.5  'of size 4 and 10000 iterations';

data ex422;
 it = 10000;  size = 4;
 do i = 1 to it;
  sumz = 0 ;  sumz2 = 0;
   do j = 1 to size; 
     z = ranuni(0);
     sumz = sumz+z;
     sumz2 = sumz2+z**2;
   end;
  xbar = sumz/size;
  xdev = sumz2-(sumz)**2/size;
  svar = xdev/size;
  uvar = xdev/(size-1);
  vdev = 12*xdev;
  output;
 end;
run;
proc  means  data=ex422  vardef=n;
 var svar uvar;
run;
proc  univariate  data=ex422  noprint;
 histogram vdev / gamma(alpha=1.5, scale=2);
 qqplot vdev / gamma(alpha=1.5, scale=2);
run;

/* pgm 4.2.3 */
goptions  reset=all;
goptions  ftext='MS UI Gothic' ;
pattern  c=blue  v=x2;
symbol  v=star  c=black;
title   f='Times' 'Dist. of Sample variance of Random Samples';
title2  f='Times' h=1.5  'from Exponential Distributions with m=1';
title3  f='Times' h=1.5  'of size 4 and 10000 iterations';

data ex423;
 it = 10000; size = 4;
 do i = 1 to it;
  sumz = 0 ; sumz2 = 0;
   do j = 1 to size; 
     z = ranexp(0);
     sumz = sumz+z;
     sumz2 = sumz2+z**2;
   end;
  xbar = sumz/size;
  xdev = sumz2-(sumz)**2/size;
  svar = xdev/size;
  uvar = xdev/(size-1);
  output;
 end;
run;
proc  means  data=ex423  vardef=n;
 var  svar uvar;
run;
proc  univariate  data=ex423  noprint;
 histogram  xdev / gamma(alpha=1.5, scale=2);
 qqplot  xdev / gamma(alpha=1.5, scale=2);
run;


/* T́@ς̐ *****************************************/
/* 5.1	Wc̕ς̐  ***********************************/
data ex511; 
input id math;
cards;
1 10
2 21
3 39
4 98
5 65
6 46
 7 85
 8 65
 9 78
10 84
11 46
12 53
13 77
14 82
15 69
16 43
17 58
18 74 
19 88
20 71
;
run;
proc means data=ex511 mean std stderr n clm t prt maxdec=4;
 var math;
run;

/* pgm 5.1.3 */
data n5ci;
mu=1;sigma=2;
do j=1 to 20;
 do i = 1 to 10;
   x= mu + sigma*rannor(0);
   output;
 end;
end;
run;
proc print data=n5ci;
run;
proc means data=n5ci clm mean std noprint;
by j;
var x;
output out=t1 lclm=l1 uclm=u1 mean=m1;
run;
proc timeplot data=t1;
plot l1 m1 u1/overlay hiloc ref=1 npp;
run;

/* pgm 5.1.4 */
data n5ci;
mu=1;sigma=2;
do j=1 to 100000;
 do i = 1 to 10;
   x= mu + sigma*rannor(0);
   output;
 end;
end;
run;
proc means data=n5ci clm mean std noprint alpha=.1;
by j;
var x;
output out=t1 lclm=l1 uclm=u1 mean=m1;
run;
data t2;
set t1 ;set n5ci(keep=mu);
if l1 > mu or u1< mu  then cover=0;
else cover=1;
proc means data=t2 n sum mean;
var cover;
run; 

/* 5.2@^CvhChȟƌo ****************************/
data n5p;
mu=0;sigma=2;
do j=1 to 100000;
 do i = 1 to 10;
   x= mu + sigma*rannor(0);
   output;
 end;
end;
run;
proc means data=n5p  noprint t prt;
by j;
var x;
output out=pf1 t=t1 prt=p1;
run;
data p2;
a=.05;
set pf1 ;
if p1>a  then sig=0;
else sig=1;
proc means data=p2 n sum mean;
var sig;
run; 

data n5p;
mu=1;sigma=2;
do j=1 to 100000;
 do i = 1 to 10;
   x= mu + sigma*rannor(0);
   output;
 end;
end;
run;
proc means data=n5p  noprint t prt;
by j;
var x;
output out=pf1 t=t1 prt=p1;
run;
data p2;
a=.05;
set pf1 ;
if p1>a  then sig=0;
else sig=1;
proc means data=p2 n sum mean;
var sig;
run; 

/* pgm 5.2.3 */
proc power; 
onesamplemeans test=t 
nullmean=0
mean = 1 2 
stddev = 2 
ntotal = 10 
alpha=.05
sides=2
power = . ; 
run;

/* pgm 5.2.5 */
data n5p;
mu=1;sigma=2;
do j=1 to 100000;
 do i = 1 to 44;
   x= mu + sigma*rannor(0);
   output;
 end;
end;
run;
proc means data=n5p  noprint t prt;
by j;
var x;
output out=pf1 t=t1 prt=p1;
run;
data p2;
a=.05;
set pf1 ;
if p1>a  then sig=0;
else sig=1;
proc means data=p2 n sum mean;
var sig;
run;

/* 5.3	  2̃O[v̕ς̔r ***********************/
proc format;
 value $gfmt 'c'='Rg[Q' 't'='Q';
run;
data ex521;
 input group $ x;
 format group $gfmt.;
cards;
c 20
c 30
c 25
c 21
c 32
t 19
t 32
t 25
t 38
t 36
t 29
;
goptions reset=all;
goptions ftext='MS UI Gothic'  ftitle='Times'  ;
title 'boxplot for each group with summary statistics';
proc boxplot data=ex521;
plot x*group;
insetgroup mean min q1 q2 q3 max stddev;
run;

/*5.4@mpgbN ***********************************/
/* pgm 5.4.2 */
data t2;
nc=10;nt=8;muc=0;sc=1;mut=2;st=1.6;it=10000;
do k=1 to it;
do group='c', 't';
if group='c' then do n=nc;mu=muc; s=sc;end;
else  do n=nt;mu=mut; s=st;end;
do j=1 to n;
x=mu+s*rannor(0);
output;
end;
end;
end;
run;

proc npar1way wilcoxon median noprint data=t2;
by k;
class group;
var x;
output out=non1 wilcoxon median;
run;
data sim;
set non1;set t2;a=0.05;
if p2_wil>a  then sigw=0;
else sigw=1;
if p2_med>a  then sigm=0;
else sigm=1;
proc means data=sim n sum mean;
var sigw sigm;
run; 


/* Ú@䗦̔r **********************************************/
/* UDP	Wc̔䗦̐ *********************************/
data ex611;
input id vote $ ;
if vote = 'y' then nvote=1;
if vote = 'n' then nvote=0;
cards;
1 y 
2 y
3 n 
4 n 
5 n
6 y
7 y 
8 y
9 n
10 y
11 y 
12 n
13 n
14 y 
15 y 
16 y 
;
proc freq data=ex611 ;
table vote/binomial(p=0.7 level="y") alpha=.01;
exact binomial;
run;

/* pgm 6.1.4 */
data b6ci;
p=0.3;n=10;
do j=1 to 20000;
 do i = 1 to n;
  x= ranbin(0,1,p);
  x=1-x;
   output;
 end;
end;
run;
proc freq data=b6ci noprint ;
by j;
tables x/binomial;
output out=t1 bin;
run;
data t2;
set t1 ;set b6ci(keep=p);
if l_bin > p or u_bin< p  then cover=0;
else cover=1;
if xl_bin > p or xu_bin< p  then xcover=0;
else xcover=1;
proc means data=t2 n sum mean;
var cover xcover;
run;

/* pgm 6.1.5 */
data b6t;
p=0.3;n=10;
do j=1 to 20000;
 do i = 1 to n;
  x=1-ranbin(0,1,p);
   output;
 end;
end;
run;
proc freq data=b6t noprint ;
by j;
tables x/binomial(p=0.3);
exact binomial;
output out=t1 bin;
run;
data t2;
a=.05;
set t1 ;
if p2_bin > a  then sig=0;
else sig=1;
if xp2_bin > a  then xsig=0;
else xsig=1;
proc means data=t2 n sum mean;
var sig xsig;
run;

/* pgm 6.1.7 */
proc power; 
      onesamplefreq test=exact 
         nullproportion = 0.3 
         proportion = 0.5 
         ntotal = 50 
         power = .; 
run;

/* UDQ Q̃O[v̔䗦̔r *****************************/
/* pgm 6.2.1 */
proc format;
 value gfmt 1='j' 2='';
run;
data ex621;
length y $ 6;
do group= 1 to 2;
 do y='' ,'Ȃ';
 input count @@;
   output;
  end;
end;
format group gfmt.;
 cards; 
20 30 10 24
;
proc freq data=ex621 order =data;
 weight count; 
 table group * y / chisq riskdiff alpha=0.05;
run;

/* pgm 6.2.2 */
data ex622;
input group $ improve $ count;
datalines;
placebo  yes  43
placebo  no   57
drug    yes  59
drug    no   41
;
proc freq data=ex622  order=freq;
tables group*improve /chisq nopercent nocol riskdiff relrisk;
weight count;
run;

/* pgm 6.2.3 */
proc format;
value $ynfmt 'y'='xK' 'n'='xK';
value $sfmt 's'='i'  'n'='i';
run;
data ex623;
input cancer $ smoking $ count;
format cancer $ynfmt. smoking $sfmt.;
cards;
n s 32
n n 11
y s 60
y n 3
;
proc freq data=ex623 order=formatted;
 tables cancer * smoking / chisq relrisk ;
 weight count;
 exact or;
run;

/* pgm 6.2.4 */
data ex624;
length group $ 7 improve $ 10;
do center=1 to 3;
 do group="drug","placebo";
  do improve="yes", "no";
   input count @;
   output;
  end;
 end;
end;
datalines;
59 41 43 57
61 39 40 60
51 49 45 55
;
run;
proc freq data=ex624 order=data;
tables center*group*improve /cmh nopercent nocol
                  riskdiff relrisk;
weight count;
exact or;
run;

/* pgm 6.2.5 */
data ex625;
if _n_ <= 4 then age= "young";
if _n_>4 then age= "old";
input drug $ survival $ count @;
datalines;
a died 40
a survived 60
b died 2
b survived 17
a died 16
a survived 3
b died 70
b survived 30
;
proc freq data=ex625;
tables  age*drug*survival / nopercent  nocol  relrisk  cmh;
weight count;
run;
proc freq data=ex625;
tables  drug*survival/ nopercent  nocol  relrisk;
weight count;
run;

/* UER Ή̂O[v̔䗦̔r **********************/
/* pgm 6.3.1 */
proc format;
value $ynfmt 'y'='ɂ' 'n'='ɂȂ';
run;
data ex631;
input id before $ after $;
format before after $ynfmt.;
label before ='^O' after='^';
cards;
01 y y 
02 n y 
03 n y 
04 y y 
05 n n 
06 y y 
07 n n 
08 n y 
09 y y 
10 n n 
11 y n 
12 n n 
13 y y 
14 y y 
15 n y
;
proc freq data=ex631;
title 'McNemar test';
tables before * after / agree ;
exact mcnem;
run;

/* pgm 6.3.2 */
proc format;
value $ynfmt 'y'='ɂ' 'n'='ɂȂ';
run;
data ex632;
input  before $ after $ count;
format before after $ynfmt.;
label before ='^O' after='^';
cards;
y y 6
y n 1
n y 4
n n 4
;
run;
proc freq data=ex632;
title 'McNemar test';
tables before * after / agree ;
weight count;
run;


/* 7́@\̉ ****************************************************/
/* 7.1@Kx *******************************************************/
title ; 
goptions reset=all;

/* pgm 7.1.2 */
data du7r;
do j=1 to 20000;
   do i =1 to 200;
     y =rantbl(0, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1,0.1,0.1)-1;
     output;
  end;
end;
run;
proc freq data=du7r noprint;
by j;
tables y /testp=(0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1) nocum;
output out=t1 chisq;
run;
data t2;
a=.05;
set t1;
if p_pchi>a then sig=0;
else sig=1;
run;
proc means data=t2 n sum mean;
var sig;
run;

/* 7.2@r~c\ **********************************************************/
proc format;
value genderfmt 1='j' 2='' ;
data ex721;
input gender  product $ count;
format gender genderfmt.;
datalines;
1 A 60
1 B 23
1 C 38
1 D 29
2 A 37
2 B 18
2 C 65
2 D 30
;
proc freq data=ex721 order=data;
tables gender*product/chisq nopercent nocol
                     expected deviation cellchi2 cmh
                     exact out=t1 outexpect ;
weight count;
run;

data res;
set t1;
residual=(count-expected)/sqrt(expected);
caseno=_n_;
proc print ;run;
goptions ftext='Times' htext=1.8;
proc gplot data=res;
plot residual*caseno;
symbol i=needle v=star;
run;
quit;

/* pgm 7.2.3 */
data ex723;
length prod $ 10;
if  _n_=1  then  prod= "new drug";
if  _n_=2  then  prod= "old drug";
do response = "good", "fair", "bad";
input count @@;
output;
end;
datalines;
68 41 21
47 46 27
;
proc freq data=ex723 order=data;
weight count;
tables  prod*response / chisq  cmh  nopercent  nocol
                    score=table  scorout;
exact  chisq;
run;

/* pgm 7.2.4 */
data ord;
it= 6000; p11=0.1; p12=0.3; p13=1-p11-p12;
p21= 0.2; p22=0.5; p23=1-p21-p22;
n1= 40; n2= 50;
do k = 1 to it;
  do group = 1 ,2;
    if group=1 then do n=n1; p1=p11; p2=p12; p3=p13; end;
    if group=2 then do n=n2; p1=p21; p2=p22; p3=p23; end;
      do i = 1 to n;
      y = rantbl(0,p1,p2,p3);
      output;
    end;
end;
end;
run;
proc freq data=ord noprint ;
by k;
tables group*y
          /chisq cmh nowarn;
output out=t1 cmh;
run:
data sim;
set t1;a=0.05;
if  p_cmhga>a  then  sigc=0;  else sigc=1;
if  p_cmhrms>a  then  sigr=0; else sigr=1;
proc means data=sim n mean;
var sigc sigr;
run;

/* pgm 7.2.5 */
data ex725;
input dose response $ count @@;
datalines;
0  yes 4  0 no 10
10 yes 6 10 no 8
20 yes 7 20 no 7
25 yes 8 25 no 6
50 yes 9 50 no 5
;
proc freq data=ex725 order=data;
tables dose*response / chisq  score=rank  scorout  cmh  trend;
weight count;
exact trend;
run;

/* pgm 7.2.6 */
proc format;
value  xfmt 1='؏'  2='wÖ@'  3='ΏÖ@';
value  yfmt 1='Ǐ󔭌'  2='f'  3='fÒ';
data ex726;
label x= ""   y= "Ö@";
input  x  y  count;
format  x  xfmt.  y  yfmt.;
datalines;
1 1 120
1 2 153
1 3 172
2 1 203
2 2 87
2 3 72
3 1 196
3 2 33
3 3 186
;
proc freq data=ex726;
tables x * y / chisq;
weight count;
run;

/* 7.3 A **************************************************************/
proc format;
value prefmt 1='ǂ'  2=''  3='';
data ex731;
input  age $ pref count;
format  pref  prefmt.;
datalines;
young 1 47
young 2 38
young 3 35
middle 1 32
middle 2 23
middle 3 22
old 1 33
old 2 44
old 3 69
;
proc freq data=ex731 order=data;
tables age*pref / chisq  cmh  measures;
weight count;
test measures;
run;

/* 7.4@v̌ ****************************************************/
data ex741; 
input p1 $ p2 $ count @@;
datalines;
A  A  31  A  B  10  A  C  0  A  D  2
B  A   1  B  B  21  B  C  6  B  D  5
C  A   8  C  B   8  C  C  15  C  D  9
D  A   5  D  B  11  D  C  5  D  D  19
;
proc freq data=ex741;
tables p1*p2 / agree  norow  nocol  nopct;
weight count;
test  kappa;
run;


/*Ẃ@PA *******************************************/
/*WDP@Uz} ***********************************************/
goptions reset=all ; 

data ex811;
input weight height gender $;
cards;
56 158 m
65 165 m 
78 158 m 
69 173 m
85 175 m
76 168 m
59 159 m 
78 175 m 
53 165 f 
48 157 f
58 169 f 
51 162 f 
63 172 f 
53 155 f
;
run;
goptions ftext='times' ftitle='times' htext=1.3;
symbol v=star ;
title 'Weight vs Height';
proc gplot data=ex811;
 plot weight * height;
run;
quit;

proc sort data=ex811;
 by gender ;
run;
proc format;
value $gfmt "f"="" "m"="j";
run;
goptions ftext='MS UI Gothic' ftitle='MS UI Gothic' htext=1.3;
symbol1 color=red  v=>   h=2;
symbol2 color=black  v=*   h=2;
title 'ʂɂ̏dƐg̃Ot';
proc gplot data=ex811;
 plot weight * height=gender ;
 format gender $gfmt.;
run;
quit;
/*8.2@PA *********************************************/
data ex812;
input age sbp;
datalines;
55 159
45 145
65 159
66 195
47 132
53 146
61 162
43 144
59 168
61 151
50 140
66 171
42 123
49 146
42 120
;
goptions ftext='times' ftitle='times' htext=1.3;
title 'sbp vs age'; 
symbol v=star c=blue h=1.2 ;
proc reg data=ex812 simple alpha=.05 ;
model sbp=age/ clb clm cli;
plot sbp*age;
plot sbp*age/conf pred;
output out=resout r=res;
run;
plot  residual.*age;
plot  r.*nqq.;
run;

/*8. 3@c ********************************************/
/* pgm 8.3.3 */
data anscomb;
 input y1 y2 y3 x1 y4 x4;
datalines; 
  8.04  9.14   7.46  10.0   6.58   8.0
  6.95  8.14   6.77   8.0   5.76   8.0
  7.58  8.74  12.74  13.0   7.71   8.0
  8.81  8.77   7.11   9.0   8.84   8.0
  8.33  9.26   7.81  11.0   8.47   8.0
  9.96  8.10   8.84  14.0   7.04   8.0
  7.24  6.13   6.08   6.0   5.25   8.0
  4.26  3.10   5.39   4.0  12.50  19.0
 10.84  9.13   8.15  12.0   5.56   8.0
  4.82  7.26   6.42   7.0   7.91   8.0
  5.68  4.74   5.73   5.0   6.89   8.0
;
run;
goptions ftext='times' ftitle='times' htext=1.3;
title 'Anscombe data';
proc reg data=anscomb;
 model y1 y2 y3 =x1;
 plot (y1 y2 y3)*x1;
 plot residual.*x1;
run;
proc reg data=anscomb;
 model y4=x4;
 plot y4*x4;
 plot residual.*x4;
run;

/* pgm 8.3.4 */
data ex814;
input year savings @@;
datalines;
1960   359.0 1961   462.1 1962   440.9 1963   646.5 1964  689.0 
1965   763.6 1966   909.9 1967   994.7 1968  1126.2 1969 1394.5 
1970  1602.7 1971  1829.1 1972  2149.8 1973  2426.0 1974 2704.2
1975  3168   1976  3768   1977  4271   1978  4511   1979  5212
1980  5794   1981  6500   1982  6972   1983  7263   1984  7697 
1985  8528   1986  9095   1987 10452   1988 11198   1989 13110
1990 13530   1991 14654   1992 15368   1993 14982   1994 15921
1995 16035   1996 16553   1997 16345   1998 16607   1999 17377
2000 17812
;
run;
title 'savings data';
proc reg data=ex814;
model savings=year/dwprob;
plot savings*year;
plot student.*year;
run;

/* pgm 8.3.5 */
goptions reset=all;
goptions ftext='times' ftitle='times' htext=1.3;
data ex815;
set ex812;
e=10*rannor(0);
y=50+2*age+e;
proc print data=ex815;var age y e;run;
proc reg data=ex815;
model y=age;
plot y*age;
run;

/* pgm 8.3.6 */
data ex816;
set ex812;
it=20000;
do i=1 to it;
e=10*rannor(0);
y=50+2*age+e;
output;
end;
proc sort ;
by i;
run;
proc reg data=ex816 noprint outest=est1;
by i;
model y=age;
run;quit;
proc means data=est1;
var intercept age;
run;
pattern c=blue v=r2;
proc univariate data=est1 noprint;
histogram intercept age/normal;
qqplot intercept age/normal;
run;


/* X́@dA ******************************************/
/* 9.1@dA *********************************************/

data ex911;
input stat math eng kokugo hgrade;
datalines;
80 86 72 65 4.3
93 87 65 78 4.5
67 76 77 56 4.1
55 78 81 46 3.5
46 67 75 52 3.9
32 61 69 55 3.6
54 62 55 67 3.9
88 73 62 85 4.2
92 82 78 91 3.8
69 73 77 59 4.1
58 71 81 67 3.9
66 67 79 59 4.0
82 79 65 79 3.8
89 77 59 80 4.0
49 66 68 61 4.2
61 71 75 71 4.1
88 80 79 80 3.8
79 69 72 70 3.9
65 60 71 69 3.5
81 91 80 89 4.6
87 88 78 83 4.3
58 69 70 65 4.0
71 79 73 81 4.1
58 70 69 65 3.9
69 81 78 70 3.8
93 95 90 91 4.7
57 69 80 81 4.2
55 79 61 71 3.5
71 62 71 68 3.8
81 65 71 81 4.1
;
goptions ftext='times';
proc reg data=ex911 corr;
model stat=math eng kokugo hgrade;
plot student.*(math eng kokugo hgrade);
run;
m1:test eng=0, hgrade=0;
run;
delete eng hgrade;
print;
run;

/* 9.2@ϐI ***********************************************/
goptions ftext='times';
proc reg data=ex911 ;
model stat=math eng kokugo hgrade/selection=adjrsq cp aic;
symbol v=+ c=green;
 plot cp.*np. 
           / chocking=red  cmallows=blue vaxis=-5 to 10 by 1; 
run;

model stat=math eng kokugo hgrade/selection=stepwise sle=0.2 sls=0.1;
run;
model stat=math eng kokugo hgrade/selection=rsquare ;
run;

model stat=math eng kokugo hgrade/selection=forward sle=0.2;run;
model stat=math eng kokugo hgrade/selection=backward sls=0.1;run;
model stat=math eng kokugo hgrade/selection=cp;run;
model stat=math eng kokugo hgrade/selection=maxr;run;
model stat=math eng kokugo hgrade/selection=minr aic;run;


data usair;
input  y x1-x6;
datalines;
10	70.3	213	582	6.0	7.05	36
13	61.0	91	132	8.2	48.52	100
12	56.7	453	716	8.7	20.66	67
17	51.9	454	515	9.0	12.95	86
56	49.1	412	158	9.0	43.37	127
36	54.0	80	80	9.0	40.25	114
29	57.3	434	757	9.3	38.89	111
14	68.4	136	529	8.8	54.47	116
10	75.5	207	335	9.0	59.80	128
24	61.5	368	497	9.1	48.34	115
110	50.6	3344	3369	10.4	34.44	122
28	52.3	361	746	9.7	38.74	121
17	49.0	104	201	11.2	30.85	103
8	56.6	125	277	12.7	30.58	82
30	55.6	291	593	8.3	43.11	123
9	68.3	204	361	8.4	56.77	113
47	55.0	625	905	9.6	41.31	111
35	49.9	1064	1513	10.1	30.96	129
29	43.5	699	744	10.6	25.94	137
14	54.5	381	507	10.0	37.00	99
56	55.9	775	622	9.5	35.89	105
14	51.5	181	347	10.9	30.18	98
11	56.8	46	244	8.9	7.77	58
46	47.6	44	116	8.8	33.36	135
11	47.1	391	463	12.4	36.11	166
23	54.0	462	453	7.1	39.04	132
65	49.7	1007	751	10.9	34.99	155
26	51.5	266	540	8.6	37.01	134
69	54.6	1692	1950	9.6	39.93	115
61	50.4	347	520	9.4	36.22	147
94	50.0	343	179	10.6	42.75	125
10	61.6	337	624	9.2	49.10	105
18	59.4	275	448	7.9	46.00	119
9	66.2	641	844	10.9	35.94	78
10	68.9	721	1233	10.8	48.19	103
28	51.0	137	176	8.7	15.17	89
31	59.3	96	308	10.6	44.68	116
26	57.8	197	299	7.6	42.59	115
29	51.1	379	531	9.4	38.79	164
31	55.2	35	71	6.5	40.75	148
16	45.7	569	717	11.8	29.07	123
;
run;
ods html;
ods graphics on;
proc corr data=usair plots=matrix;
run;
ods graphics off;
ods html close;
ods html;  
ods graphics on;
proc reg data=usair;
model y=x1-x6 /selection=stepwise;
run;quit;
ods graphics off; 
ods html close;
proc glm data=usair;
model y=x1-x6;
run;

/* 9.3@ϐɃJeSJϐ܂ޏꍇiÚj***********************/
data ex912;
input sbp age gender $;
datalines;
95 33 m
105 40 f
140 71 f
120 61 m
109 59 m
142 67 f
140 60 m
103 51 m
123 48 f
100 66 m
 90 59 m
128 72 f
102 43 m
122 43 f
 89 66 m
101 71 m
105 55 f
103 45 f
 94 38 m
128 81 f
136 49 f
117 45 m
;
proc glm data=ex912;
class gender;
model sbp= age gender /solution  p clm cli;
lsmeans  gender/tdiff at age=60 e ;
run;
lsmeans  gender/tdiff at age=40 e;
lsmeans  gender/tdiff  e;
run;

proc glm data=ex912;
class gender;
model sbp= age gender age*gender  ;
run;

ods html;
ods graphics on;
proc glm data=ex912;
class gender;
model sbp= age gender  ;
run;
proc glm data=ex912;
class gender;
model sbp= age|gender  ;
run;
ods graphics off;
ods html close;

data ex913;
set ex912;
if gender="m" then g=0;
if gender="f" then g=1;
run;
proc reg data=ex913;
model sbp=age g;
test g;
run;

/* 9.4@@vU ********************************/
data ex914;
input group test;
cards;
1 40  
 1 20  
 1 60  
 1 82 
 1 40  
 1 65 
 2 50  
 2 65  
 2 74  
 2 48  
 2 57  
 2 49
 3 94  
 3 92
 3 68  
 3 60 
 3 83 
 3 82 
 3 91 
 4 10 
 4 28  
 4 54 
 4 53 
 4 58  
 4 59 
 4 79 
;
run;

goptions reset=all;
goptions ftext='times' htext=1.5;
proc boxplot data=ex914;
plot test*group;
insetgroup n mean stddev;
run;

proc glm data=ex914;
class group;
model test=group / solution;
contrast '1 vs 2 3 4' group 3 -1 -1 -1 /e ;
estimate '1 vs 2 3 4' group 3 -1 -1 -1/divisor=3 e ;
run;

proc glm data=ex914;
class group;
model test=group/solution;
lsmeans group /tdiff e ;
means group /t clm;
means group /t ;
run;

lsmeans group /tdiff e adjust=tukey;
lsmeans group /tdiff e adj=scheffe;
means group /t tukey scheffe lines;
run;

means group/t hovtest welch;
run;

proc anova data=ex914;
class group;
model test=group;
means group /lsd tukey SCHEFFE lines;
run;

proc npar1way data=ex914 wilcoxon;
class group;
var test;
exact wilcoxon/ mc;
run;

proc freq data=ex914;
tables group*test/noprint cmh scores=rank;
run;

data sim1;
m1=0; m2=0.5; m3=1; it=8000;
do k=1 to it;
   do i=1 to 40;
     group = 1 + (i>10) + (i>20);
     if group = 1 then Y = m1+0.5*rannor(0);
     if group = 2 then Y = m2 + 0.8*rannor(0);
     if group = 3 then Y = m3 + 1.1*rannor(0);
     output;
   end;
end;
run;
proc glm data=sim1 outstat=s1 noprint;
by k;
class group;
model y=group;
run;
data sim2;
set s1;a=0.05;
if _type_="SS3";
if prob>a then sig=0; else sig=1;
run;
proc means data=sim2 n mean; var sig; run;
proc npar1way data=sim1 wilcoxon noprint;
by k;
class group;
var y;
output out=w1 wilcoxon;
run;
data simk;
set w1; a=0.05;
if p_kw>a then sigw=0; else sigw=1;
run;
proc means data=simk n mean; var sigw; run;

