/************************************************************************************/
/***** f[^͂̂߂SAS@***************************************************/
/***** o[W: QŁ@@**********************************************************/
/***** 쐬F {x, gV֎q  ***************************************************/
/***** t:  2014/02/07 ************************************************************/
/************************************************************************************/

/***** 3́@f[^̗v **********************************************************/

/**** 3.1 @xz\ **************************************************************/

goptions reset=all;
title ; 


data ex311;
 input id   gender $  math  eng;
 label  math ='w̓_' @
         eng = 'p̓_' ;
 cards;
  1 f 58 60
  2 f 87 79
  3 m 40 56
  4 m 95 55
  5 f 67 72
  6 f 55 62
  7 m 74 48
  8 m 42 35
  9 m 51 65
 10 f 78 80
 11 m 48 61
 12 f 72 68
 13 f 91 86
 14 m 95 78
 15 m 85 69
 16 f 72 83
 17 f 64 92 
 18 m 78 62
 ;
 proc freq data=ex311;
  table gender math eng;
 run; 

proc format;
 value $genfmt 'f' = 'Female' 'm' = 'Male';
 value  ggroup
   low-59 = '0-59'
    60-69 = '60-69'
    70-79 = '70-79'
    80-high = '80-100' ;
run;
proc  freq  data=ex311;
 table  gender  math  eng ;
 format  gender  $genfmt.  math  ggroup.  eng  ggroup. ;
run;

data  ex311f;
set ex311;
format  gender  $genfmt.  math  ggroup.  eng  ggroup. ;
proc  print  data=ex311f (obs=5) ;
run;

proc sgpanel data=ex311f;
title "math level by gender" ;
 panelby gender; 
 vbar  math;
run;
/****  3.2@xz̃Ot\ ******************************/
goptions reset=all;
title ;

title  'bar chart for mathematics and english';
proc  gchart  data=ex311 ;
 hbar  math  eng /space=0 ;
run;
quit;

title 'bar chart for math and english, 4 classes';
proc  gchart  data=ex311;
 hbar  math  eng / space=0  levels=4 ;
run; 
quit;

title 'bar chart for mathematics and english, midpoints';
proc  gchart  data=ex311;
 hbar  math  eng / midpoints = 50 65 80 95  space=0  nostat ;
run;
quit;

title 'bar chart for math and english, vbar, percent';
proc  gchart  data=ex311;
 vbar  math  eng / type=pct  space=0;
run;
quit;

title 'bar chart for math and english, hbar, percent';
proc  gchart  data=ex311;
 hbar  math  eng / group=gender  type=pct  space=0;
run;
quit;

title 'bar chart by gender';
proc  gchart  data=ex311;
 hbar  gender / discrete ;
run; 
quit;

title 'bar chart by gender';
proc  sgplot  data=ex311;
hbar  gender  ;
run;

title 'bar chart of mean math for gender';
proc  gchart  data=ex311;
 vbar  gender / type=mean  sumvar=math;
run;
quit;

title 'bar chart of mean math for gender';
proc  sgplot  data=ex311;
 vbar  gender / stat=mean  response=math;
run;

/**** 3.3@v񓝌v **********************************/
goptions reset=all;
title ;

title 'Simple Descriptive Statistics';
proc  means  data=ex311  n  mean  std  min  max  vardef=n ;
var  math  eng ;
run;

title 'Simple Descriptive Statistics by gender';
proc  means  data=ex311  n  mean  std  min  max  vardef=n;
 class  gender ;
 var  math  eng ;
run;

title 'Simple Descriptive Statistics';
proc  univariate  data=ex311;
 var  math  eng;
run; 

title 'Simple Descriptive Statistics by gender' ;
proc  univariate  data=ex311;
class  gender ;
 var  math  eng;
run;

data  ex312;
 set  ex311;
 if  math >=80  then  mgrade ='A';
  else  if  70 <= math < 80  then  mgrade ='B';
  else  if  60 <= math < 70  then  mgrade ='C';
  else  if  math < 60       then  mgrade ='D';
 if eng >=80  then  egrade ='A';
  else  if  70<= eng < 80   then  egrade ='B';
  else  if  60<= eng < 70   then  egrade ='C';
  else  if  eng < 60       then  egrade ='D';
run;
title 'math grade and english grade' ;
proc  print  data=ex312;
run;

title 'Frequency Distribution';
proc  freq  data=ex312;
 table  gender  mgrade  egrade;
run;

title   'Histogram';
proc  gchart  data=ex312;
 hbar  mgrade  egrade  / discrete ;
run; quit;

proc sgplot  data=ex312;
hbar  mgrade;
proc sgplot  data=ex312;
hbar  egrade;
run;

/****  3.4@TIf[^  ***********************************/
goptions reset=all;
title ;

title  'Box Plot';
proc sgplot data=ex311;
 vbox math ;
 proc sgplot data=ex311;
 vbox eng;
 run;

proc sgplot data=ex311;
vbox  math / category=gender ;
refline 60; 
proc sgplot data=ex311;
vbox  eng  / category=gender ;
refline 60; 
run; 

data ex313;
input  x  @@;
dummy = 1;
datalines;
2 2 3 4 4 7 13 5 1 6 3
;
title  'Box Plot';
proc  boxplot  data=ex313;
plot x *dummy / boxstyle=schematic;
inset  nobs  mean  std;
run;

symbol v = -;
title 'QQ plot';
proc  univariate  data=ex311  noprint;
 qqplot math /normal(mu=est sigma=est  ) square  vaxis=axis1 ;
 axis1 label=(a=90 r=0) ;
 run;

data ex3n;
n = 100;  dummy = 1 ;
do i = 1 to n;
  x = rannor(0);
  output;
end;
title  'probability plot';
*title 'quantile-quantile plot' ; 
proc  univariate  data=ex3n;
var  x;
probplot  x / normal;
*qqplot  x / normal;
run;  quit;
title  'BoxPlot';
proc  boxplot  data=ex3n;
plot  x * dummy;
run;

/**** 3.5 @U@z@} *****************************************/
goptions reset=all;
title ;

title  'math vs. english plot';
symbol  v=dot  c=blue  i=none;
proc  gplot  data=ex311;
 plot  math * eng;
run;
quit;

title  'math vs. english plot';
proc sgplot data=ex311;
  scatter  y=math  x=eng ;
run;

title  'math vs. english by gender';
proc  sgpanel  data=ex311;
 panelby  gender;
 scatter  x=eng  y=math / datalabel=id 
   datalabelattrs=(size=17)  markerattrs=(size=15 symbol=starfilled) ;
 run;

title  'math vs. english by gender';
proc  gplot  data=ex311;
 plot  math*eng = gender ;
symbol1 v=triangle c=red  h=2  i=none  pointlabel=('#id');
symbol2 v=square c=green  h=2  i=none  pointlabel=('#id');
run;
quit;

title  'math vs. english by gender';
proc  sgplot  data=ex311;
scatter  y=math  x=eng  / group=gender 
   datalabel=id  datalabelattrs=(size=12);
run;

/**** 3.6@  W   **************************************/
goptions reset=all;
title ;

proc  corr  data=ex311  cov  noprob  spearman ;
var  math  eng ;
run;

proc rank  data=ex311  out=rex311;
 var  math eng;
 ranks  mathr  engr;
run;
proc  print  data=rex311;
proc  corr  data=rex311  noprob ;
 var  mathr  engr;
run;

data cor1;
do x =  -5 to 5 ;
y = 1+2*x;
ym = 1-x;
y2 = x*x;
output;
end;
run;
proc  corr  data=cor1  noprob  nosimple  plots=matrix ;
var  x ;  with  y  ym  y2 ;
run;

data ex314;
mx = 0; my = 0;
sx = 1; sy = 1;
n = 200;
do r =  -0.9,  -0.8, -0.4, -0.2,
  0,  0.2,  0.3,  0.5,  0.6,  0.8,  0.9,  1;
  do  i = 1 to n;
      z1 = rannor(0);
      z2 = rannor(0);
      x = sx*z1 + mx;
      y = sy*(r*z1 + sqrt(1-r**2)*z2)+ my;
      output;
  end;
end;
proc  sgpanel  data=ex314 ;
panelby  r  / rows=6  columns=2 ;
scatter  x=x  y=y ;
run;

/**** 3.7@@@\  ************************************/
goptions reset=all;
title ;

title  'math grade and english grade';
proc  freq  data=ex312;
 table  mgrade * egrade;
run;

proc  gchart  data=ex312;
block  mgrade / group= egrade;
run;

proc  freq  data=ex312;
 table  gender *(mgrade egrade) / norow  nocol  nopercent ;
 format  gender $genfmt.;
run;



/***** K  *****************************************/
goptions reset=all;
title ;

data one;
input  x  y;
cards;
4  1
5  2
6  3
8  4
2  5
;
proc  standard  data=one  out=two  mean=0  std=1  vardef=n  print ;
var  x  y;
proc  print  data=two;  run;
proc  standard  out=three  mean=50  std=10  vardef=n;
proc print data=three; run;

data ex3e;
n = 100; dummy = 1 ;
do i = 1 to n;
  x = 2*rand("expo");
  output;
end;
proc  univariate  data=ex3e;
var x;
histogram  x  /normal;
qqplot  x /normal;
qqplot  x /exponential;
run;
proc  boxplot  data=ex3e;
plot x*dummy;
run;  quit;



