/************************************************************************************/
/***** f[^͂̂߂SAS@***************************************************/
/***** o[W: QŁ@@**********************************************************/
/***** 쐬F {x, gV֎q  ***************************************************/
/***** t:  2014/02/07 @**********************************************************/
/************************************************************************************/

/**** 7́@\̉ ***********************************************************/

/**** 7.1@Kx  **************************************************************/

goptions reset=all;
title ;


data ex711;
do y = 1 to 6;
input  count @@;
output;
end;
datalines;
29 41 37 35 54 44
;
proc freq  data=ex711;
weight count;
tables y /testf= (40 40 40 40 40 40) nocum;
run;

data du7r;
do j = 1 to 20000;
   do i = 1 to 200;
     y = rantbl(0, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1,0.1,0.1)-1;
     output;
  end;
end;
run;
proc freq data=du7r noprint;
by j;
tables y /testp = (0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1) nocum;
output out=t1 chisq;
run;
data t2;
a=.05;
set t1;
if  p_pchi>a  then  sig=0;
else  sig=1;
run;
proc means data=t2 n sum mean;
var sig;
run;

/**** 7.2@r ~ c \  *************************************************/
goptions reset=all;
title ;

proc format;
value genderfmt  1= 'j'  2= '' ;
data ex721;
input gender  product $ count;
format  gender genderfmt.;
datalines;
1 A 60
1 B 23
1 C 38
1 D 29
2 A 37
2 B 18
2 C 65
2 D 30
;
proc freq data=ex721 order=data;
tables  gender*product / chisq  nopercent  nocol
                     expected  deviation  cellchi2  cmh
                     exact  out=t1  outexpect ;
weight count;
run;

data res;
set t1;
residual = (count-expected) / sqrt(expected);
caseno = _n_;
proc print ; 
run;
proc gplot data=res;
plot residual*caseno;
symbol  i=needle  v=star;
run;
quit;

proc sgplot data=res;
needle  x=caseno  y=residual/ markers;
run;

data ex723;
length prod $ 10;
if  _n_=1  then  prod= "new drug";
if  _n_=2  then  prod= "old drug";
do response = "good", "fair", "bad";
input count @@;
output;
end;
datalines;
68 41 21
47 46 27
;
proc freq data=ex723 order=data;
weight count;
tables  prod*response / chisq  cmh  nopercent  nocol
                    score=table  scorout;
exact  chisq;
run;

data ord;
it= 6000; p11=0.1; p12=0.3; p13=1-p11-p12;
p21= 0.2; p22=0.5; p23=1-p21-p22;
n1= 40; n2= 50;
do k = 1 to it;
  do group = 1 ,2;
    if group=1 then do n=n1; p1=p11; p2=p12; p3=p13; end;
    if group=2 then do n=n2; p1=p21; p2=p22; p3=p23; end;
      do i = 1 to n;
      y = rantbl(0,p1,p2,p3);
      output;
    end;
end;
end;
run;
proc freq data=ord noprint ;
by k;
tables group*y
          /chisq cmh nowarn;
output out=t1 cmh;
run:
data sim;
set t1;a=0.05;
if  p_cmhga>a  then  sigc=0;  else sigc=1;
if  p_cmhrms>a  then  sigr=0; else sigr=1;
proc means data=sim n mean;
var sigc sigr;
run;

data ex725;
input dose response $ count @@;
datalines;
0  yes 4  0 no 10
10 yes 6 10 no 8
20 yes 7 20 no 7
25 yes 8 25 no 6
50 yes 9 50 no 5
;
proc freq data=ex725 order=data;
tables dose*response / chisq  score=rank  scorout  cmh  trend;
weight count;
exact trend;
run;

proc format;
value  xfmt 1='؏'  2='wÖ@'  3='ΏÖ@';
value  yfmt 1='Ǐ󔭌'  2='f'  3='fÒ';
data ex726;
label x= ""   y= "Ö@";
input  x  y  count;
format  x  xfmt.  y  yfmt.;
datalines;
1 1 120
1 2 153
1 3 172
2 1 203
2 2 87
2 3 72
3 1 196
3 2 33
3 3 186
;
proc freq data=ex726;
tables x * y / chisq;
weight count;
run;

/***** 7.3@A@  ********************************************/
goptions reset=all;
title ;

proc format;
value prefmt 1='ǂ'  2=''  3='';
data ex731;
input  age $ pref count;
format  pref  prefmt.;
datalines;
young 1 47
young 2 38
young 3 35
middle 1 32
middle 2 23
middle 3 22
old 1 33
old 2 44
old 3 69
;
proc freq data=ex731 order=data;
tables age*pref / chisq  cmh  measures;
weight count;
test measures;
run;

/*** 7.4@v̌ *******************************************/
goptions reset=all;
title ;

data ex741; 
input p1 $ p2 $ count @@;
datalines;
A  A  31  A  B  10  A  C  0  A  D  2
B  A   1  B  B  21  B  C  6  B  D  5
C  A   8  C  B   8  C  C  15  C  D  9
D  A   5  D  B  11  D  C  5  D  D  19
;
proc freq data=ex741;
tables p1*p2 / agree  norow  nocol  nopct;
weight count;
test  kappa;
run;

/*** 7́EK **********************************************/
goptions reset=all;
title ;

data alcohol;
input  dose  response $ count @@;
select(dose);
when(1) score=0;
when(2) score=0.5;
when(3) score=1.5;
when(4) score=4.0;
when(5) score=7.0;
end;
datalines;
1 yes   17066  1  no  48
2 yes  14464  2  no  38
3 yes  788  3  no  5
4 yes  126  4  no  1
5 yes  37   5  no  1
;
proc freq data=alcohol ;
tables response *score / chisq  scorout  cmh  trend;
weight count;
run;

data ex76;
n= 400; it= 5000;
do k = 1 to it;
  do i = 1 to n;
    f = rantbl(0,0.12,0.2,0.08,.06,0.1,.04,.12,.2,.08);
    select(f);
    when(1) do x=1; y=1;end;
    when(2) do x=1; y=2;end;
    when(3) do x=1; y=3;end;
    when(4) do x=2; y=1;end;
    when(5) do x=2; y=2;end;
    when(6) do x=2; y=3;end;
    when(7) do x=3; y=1;end;
    when(8) do x=3; y=2;end;
    when(9) do x=3; y=3;end;
    end;
    output;
  end;
  end;
run;
proc freq data= ex76 noprint;
  by k;
  tables x*y / chisq;
  output out=o1  chisq;
run;
data sim1;
set o1;
a=.05;
if  p_pchi>a  then sigp=0;
  else sigp=1;
run;


