/************************************************************************************/
/***** f[^͂̂߂SAS@***************************************************/
/***** o[W: QŁ@@**********************************************************/
/***** 쐬F {x, gV֎q  ***************************************************/
/***** t:  2014/02/07 @**********************************************************/
/************************************************************************************/

/**** 8́@PA *************************************************************/

/*** 8.1@U@z@}   **************************************************************/

goptions reset=all;
title;

data ex811;
input weight height gender $;
cards;
56 158 m
65 165 m 
78 158 m 
69 173 m
85 175 m
76 168 m
59 159 m 
78 175 m 
53 165 f 
48 157 f
58 169 f 
51 162 f 
63 172 f 
53 155 f
;
run;

title 'Weight vs Height';
proc gplot data=ex811;
 plot weight * height;
run;
quit;

proc sort data=ex811;
 by gender ;
run;
proc format;
value  $gfmt  "f"= ""  "m"= "j";
run;

symbol1 color=red  v=>   h=2;
symbol2 color=black  v=*   h=2;
title 'ʂɂ̏dƐg̃Ot';

proc gplot data=ex811;
 plot weight * height = gender ;
 format gender  $gfmt. ;
run;
quit;

proc sgplot data=ex811;
scatter x=height y=weight /group=gender markerchar=gender;
run;

proc sgpanel data=ex811;
panelby gender;
scatter x=height y=weight;
run;
proc sgplot data=ex811;
scatter x=height y=weight /group=gender ;
run;

/***** 8.2@PA ***************************************************************/
goptions reset=all;
title;

data ex812;
input age sbp;
datalines;
55 159
45 145
65 159
66 195
47 132
53 146
61 162
43 144
59 168
61 151
50 140
66 171
42 123
49 146
42 120
;

title 'sbp vs age'; 
symbol v=star  c=blue   ;
proc reg data=ex812  simple  alpha= .05 ;
model sbp=age /  clb  clm  cli;
plot sbp*age;
plot sbp*age / conf  pred;
output out=resout r=res;
run;

plot  residual. * age;
plot  r. * nqq.;
run;

title  'Residual plot' ; 
proc gplot data=resout;
plot res*age / vref=0;
symbol  v=-  c=black;
run; quit;

title   'sbp vs age';
symbol i=rl value=triangle cv=red ci=blue;
proc gplot data=ex812;
plot sbp * age;
run; quit;

symbol1  v=plus  i=rl  c=black;
symbol2  v=none  i=rlclm95  c=red  l=2;
symbol3  v=none  i=rlcli95  c=blue  l=20;
proc gplot data=ex812;
 plot sbp * age=1 
       sbp * age=2
       sbp * age=3 / overlay;
run; quit;

proc sgplot data=ex812 ; 
reg y=sbp  x=age / cli clm;
run;


/***** 8.3@c     *********************************************************/
goptions reset=all;
title;

data ex813;
do x = 2 to 20;
  y = 4+5*log(x)+0.5*rannor(0);
  if x = 20 then y = 10;
  output;
end;
run;
title;
proc reg data=ex813;
  model y = x / r;
  plot y*x;
  plot r.*x;
run;

plot  student. * x ; 
run;

data anscomb;
 input y1 y2 y3 x1 y4 x4;
datalines; 
  8.04  9.14   7.46  10.0   6.58   8.0
  6.95  8.14   6.77   8.0   5.76   8.0
  7.58  8.74  12.74  13.0   7.71   8.0
  8.81  8.77   7.11   9.0   8.84   8.0
  8.33  9.26   7.81  11.0   8.47   8.0
  9.96  8.10   8.84  14.0   7.04   8.0
  7.24  6.13   6.08   6.0   5.25   8.0
  4.26  3.10   5.39   4.0  12.50  19.0
 10.84  9.13   8.15  12.0   5.56   8.0
  4.82  7.26   6.42   7.0   7.91   8.0
  5.68  4.74   5.73   5.0   6.89   8.0
;
run;

title  'Anscombe data';
proc reg data=anscomb;
 model  y1 y2 y3 = x1;
 plot (y1 y2 y3)*x1;
 plot residual.*x1;
run;
proc reg data=anscomb;
 model y4 = x4;
 plot y4*x4;
 plot residual.*x4;
run;

data ex814;
input year savings @@;
datalines;
1960   359.0 1961   462.1 1962   440.9 1963   646.5 1964  689.0 
1965   763.6 1966   909.9 1967   994.7 1968  1126.2 1969 1394.5 
1970  1602.7 1971  1829.1 1972  2149.8 1973  2426.0 1974 2704.2
1975  3168   1976  3768   1977  4271   1978  4511   1979  5212
1980  5794   1981  6500   1982  6972   1983  7263   1984  7697 
1985  8528   1986  9095   1987 10452   1988 11198   1989 13110
1990 13530   1991 14654   1992 15368   1993 14982   1994 15921
1995 16035   1996 16553   1997 16345   1998 16607   1999 17377
2000 17812
;
run;
title 'savings data';
proc reg data=ex814;
model savings = year / dwprob;
plot savings*year;
plot student.*year;
run;

title ; 
data ex815;
set ex812;
e = 10*rannor(0);
y = 50+2*age+e;
proc print data=ex815;  var age y e;  run;
proc reg data=ex815;
model y = age;
plot y*age;
run;

data ex816;
set ex812;
it = 20000;
do i = 1 to it;
e = 10*rannor(0);
y = 50+2*age+e;
output;
end;
proc sort ;
by i;
run;
proc reg data=ex816  noprint  outest=est1;
by i;
model y = age;
run;quit;
proc means data=est1;
var  intercept  age;
run;

proc univariate  data=est1 noprint;
histogram  intercept  age / normal;
qqplot  intercept age / normal;
run;

/**** 8.4@    ***********************************************************/
goptions reset=all;
title;

proc corr data=ex811 cov  nosimple 
     fisher (rho0=0.3 biasadj=no);
var weight height;
run;


/**** 8́EK *************************************************************/
goptions reset=all;
title;

data ex821;
mx=0; my=0;
sx=1; sy=1;
n = 200;
do r = 0, 0.1, 0.2, 0.3;
  do i = 1 to n;
      z1 = rannor(0);
      z2 = rannor(0);
      x = sx*z1+mx;
      y = sy*(r*z1+sqrt(1-r**2)*z2) + my;
      output;
  end;
end;
proc corr data=ex821 nosimple fisher;
by r;
var x y;
run;


