import math
import matplotlib.pyplot as plt
import numpy as np

mx = 51
nx = 61
cr = 2.5 / math.pi / 6
delta_x = 4 * math.pi / (mx - 1)
delta_t = delta_x * cr
ity = 2
U = np.zeros(100)
UU = np.zeros(100)
X = np.zeros(mx)
Y = np.zeros((6, mx))

for i in range(0, mx):
    U[i] = math.sin(delta_x * i)
for i in range(0, mx):
    X[i] = delta_x * i
for n in range(0, nx):
    U[0] = U[mx - 2]
    U[mx - 1] = U[1]
    if (n % 15) == 1:
        K = n // 15 + 2
        for i in range(0, mx):
            Y[K, i] = U[i]

    if ity == 1:
        for i in range(1, mx - 1):
            if U[i] >= 0:
                UU[i] = U[i] - delta_t / delta_x * U[i] * (U[i] - U[i - 1])
            else:
                UU[i] = U[i] - delta_t / delta_x * U[i] * (U[i + 1] - U[i])
        for i in range(1, mx - 1):
            U[i] = UU[i]
    if ity == 2:
        for i in range(0, mx - 1):
            UU[i] = U[i] - 0.5 * (U[i + 1] * U[i + 1] - U[i] * U[i]) \
                         * delta_t / (2 * delta_x)
        UU[mx - 1] = UU[1]
        for i in range(0, mx - 1):
            U[i] = 0.5 * (U[i] + UU[i] - 0.5 * (UU[i] * UU[i]
            - UU[i - 1] * UU[i - 1]) * delta_t / (2 * delta_x))
        U[0] = U[mx - 2]

fig = plt.figure()
plt.plot(X, Y[0], X, Y[1], X, Y[2], X, Y[3], X, Y[4], X, Y[5])
plt.show()
