import math
import matplotlib.pyplot as plt
import numpy as np

mesh_max_x = int(input("X方向の格子点数を入力してください (<51)."\
    "(e.g. 20): ")) + 1
mesh_max_y = int(input("Y方向の格子点数を入力してください (<51)."\
    "(e.g. 20): ")) + 1
mesh_max_z = int(input("Z方向の格子点数を入力してください (<51)."\
    "(e.g. 20): ")) + 1
reynolds = int(input("レイノルズ数を入力してください. (e.g. 40): "))
delta_t = float(input("時間間隔Δtを入力してください. (e.g. 0.01): "))
attack_angle = int(input("迎角を入力してください. (e.g. 45): "))
time_max = int(input("計算打ち切りのタイムステップ数を入力してください."\
    "(e.g. 100): "))

delta_t_recip = 1 / delta_t
reynolds_recip = 1 / reynolds
id_1 = mesh_max_x - 1
jd_1 = mesh_max_y - 1
kd_1 = mesh_max_z - 1
id_2 = mesh_max_x - 2
jd_2 = mesh_max_y - 2
kd_2 = mesh_max_z - 2
delta_x = 1 / id_1
delta_y = 1 / jd_1
delta_z = 1 / kd_1
delta_x_recip = 1 / delta_x
delta_y_recip = 1 / delta_y
delta_z_recip = 1 / delta_z
dijk = 1 / (2 / (delta_x * delta_x) + 2 / (delta_y * delta_y) + 2 / (delta_z *
    delta_z))  # ポアソン方程式を反復法で解くときに現れる式の係数
it_max_poisson = 10  # ポアソン方程式の反復回数
tet = math.atan(1) * 4 * attack_angle / 180  # 壁面の動く方向を示す角度(ラジアン)
r = np.zeros((mesh_max_x, mesh_max_y))  # 流れ関数を記憶する配列
u = np.zeros((mesh_max_x, mesh_max_y, mesh_max_z))  # X方向の速度成分を
                                                    # 記憶する配列
v = np.zeros((mesh_max_x, mesh_max_y, mesh_max_z))  # Y方向の速度成分を
                                                    # 記憶する配列
w = np.zeros((mesh_max_x, mesh_max_y, mesh_max_z))  # Z方向の速度成分を
                                                    # 記憶する配列
p = np.zeros((mesh_max_x, mesh_max_y, mesh_max_z))  # 圧力を記憶する配列
q = np.zeros((mesh_max_x, mesh_max_y, mesh_max_z))  # ポアソン方程式の右辺を
                                                    # 記憶する配列

for t in range(0, time_max):
    for k in range(0, mesh_max_z):  # 境界条件(x-z面)
        for i in range(0, mesh_max_x):
            u[i, jd_1 - 1, k] = -u[i, jd_2 - 1, k]
            v[i, mesh_max_y - 1, k] = -v[i, jd_2 - 1, k]
            w[i, jd_1 - 1, k] = -w[i, jd_2 - 1, k]
            v[i, jd_1 - 1, k] = 0
            u[i, 0, k] = -u[i, 1, k]
            v[i, 0, k] = v[i, 2, k]
            w[i, 0, k] = -w[i, 1, k]
            v[i, 1, k] = 0

    for k in range(0, mesh_max_z):  # 境界条件(y-z面)
        for j in range(0, mesh_max_y):
            u[mesh_max_x - 1, j, k] = u[id_2 - 1, j, k]
            v[id_1 - 1, j, k] = -v[id_2 - 1, j, k]
            w[id_1 - 1, j, k] = -w[id_2 - 1, j, k]
            u[id_1 - 1, j, k] = 0
            u[0, j, k] = u[2, j, k]
            v[0, j, k] = -v[1, j, k]
            w[0, j, k] = -w[1, j, k]
            u[1, j, k] = 0

    for j in range(0, mesh_max_y):  # 境界条件(x-y面)
        for i in range(0, mesh_max_x):
            u[i, j, 0] = -u[i, j, 1]
            v[i, j, 0] = -v[i, j, 1]
            w[i, j, 0] = w[i, j, 2]
            w[i, j, 1] = 0
            u[i, j, kd_1 - 1] = math.cos(tet)
            u[i, j, mesh_max_z - 1] = math.cos(tet)
            v[i, j, kd_1 - 1] = math.sin(tet)
            v[i, j, mesh_max_z - 1] = math.sin(tet)
            w[i, j, mesh_max_z - 1] = w[i, j, kd_2 - 1]
            w[i, j, kd_1 - 1] = 0

    for k in range(1, kd_1):  # ポアソン方程式の右辺の計算
        for j in range(1, jd_1):
            for i in range(1, id_1):
                u1 = (u[i + 1, j, k] - u[i, j, k]) * delta_x_recip
                u2 = (u[i, j + 1, k] - u[i, j, k]) * delta_y_recip
                u3 = (u[i, j, k + 1] - u[i, j, k]) * delta_z_recip
                v1 = (v[i + 1, j, k] - v[i, j, k]) * delta_x_recip
                v2 = (v[i, j + 1, k] - v[i, j, k]) * delta_y_recip
                v3 = (v[i, j, k + 1] - v[i, j, k]) * delta_z_recip
                w1 = (w[i + 1, j, k] - w[i, j, k]) * delta_x_recip
                w2 = (w[i, j + 1, k] - w[i, j, k]) * delta_y_recip
                w3 = (w[i, j, k + 1] - w[i, j, k]) * delta_z_recip
                q[i, j, k] = -u1 * u1 - v2 * v2 - w3 * w3 - \
                             2 * (u2 * v1 + v3 * w2 + w1 * u3) + \
                             delta_t_recip * (u1 + v2 + w3)

    for it_poisson in range(0, it_max_poisson):  # 圧力のポアソン方程式を
                                                 # ガウス-ザイデル法で解く
        for k in range(0, mesh_max_z):  # 圧力の境界条件(y-z面)
            for j in range(0, mesh_max_y):
                p[0, j, k] = p[1, j, k]
                p[id_1 - 1, j, k] = p[id_2 - 1, j, k]

        for k in range(0, mesh_max_z):  # 圧力の境界条件(x-z面)
            for i in range(0, mesh_max_x):
                p[i, 0, k] = p[i, 1, k]
                p[i, jd_1 - 1, k] = p[i, jd_2 - 1, k]

        for j in range(0, mesh_max_y):  # 圧力の境界条件(x-y面)
            for i in range(0, mesh_max_x):
                p[i, j, 0] = p[i, j, 1]
                p[i, j, kd_1 - 1] = p[i, j, kd_2 - 1]
        g1 = 0  # 誤差の二乗和
        for k in range(1, kd_2):
            for j in range(1, jd_2):
                for i in range(1, id_2):
                    pcor = dijk * ((p[i + 1, j, k] + p[i - 1, j, k]) /
                                   (delta_x * delta_x) +
                                   (p[i, j + 1, k] + p[i, j - 1, k]) /
                                   (delta_y * delta_y) +
                                   (p[i, j, k + 1] + p[i, j, k - 1]) /
                                   (delta_z * delta_z) -
                                   q[i, j, k]) - p[i, j, k]
                    g1 = g1 + pcor * pcor
                    p[i, j, k] = p[i, j, k] + pcor

        if g1 <= 0.001:
            if t - t / 20 * 20 == 0:
                print(t, it_poisson, g1)
                break

    for k in range(1, kd_2):  # 速度の計算
        for j in range(1, jd_2):
            for i in range(1, id_2):
                uv = (u[i + 1, j, k] - 2 * u[i, j, k] + u[i - 1, j, k]) * \
                     delta_x_recip * delta_x_recip + \
                     (u[i, j + 1, k] - 2 * u[i, j, k] + u[i, j - 1, k]) * \
                     delta_y_recip * delta_y_recip + \
                     (u[i, j, k + 1] - 2 * u[i, j, k] + u[i, j, k - 1]) * \
                     delta_z_recip * delta_z_recip
                vv = (v[i + 1, j, k] - 2 * v[i, j, k] + v[i - 1, j, k]) * \
                     delta_x_recip * delta_x_recip + \
                     (v[i, j + 1, k] - 2 * v[i, j, k] + v[i, j - 1, k]) * \
                     delta_y_recip * delta_y_recip + \
                     (v[i, j, k + 1] - 2 * v[i, j, k] + v[i, j, k - 1]) * \
                     delta_z_recip * delta_z_recip
                wv = (w[i + 1, j, k] - 2 * w[i, j, k] + w[i - 1, j, k]) * \
                     delta_x_recip * delta_x_recip + \
                     (w[i, j + 1, k] - 2 * w[i, j, k] + w[i, j - 1, k]) * \
                     delta_y_recip * delta_y_recip + \
                     (w[i, j, k + 1] - 2 * w[i, j, k] + w[i, j, k - 1]) * \
                     delta_z_recip * delta_z_recip

                un = u[i, j, k] * (u[i + 1, j, k] - u[i - 1, j, k]) * \
                     0.5 * delta_x_recip + \
                     (v[i - 1, j, k] + v[i, j, k] +
                      v[i - 1, j + 1, k] + v[i, j + 1, k]) * \
                     0.25 * (u[i, j + 1, k] - u[i, j - 1, k]) * \
                     0.5 * delta_y_recip + \
                     (w[i - 1, j, k] + w[i, j, k] +
                      w[i - 1, j, k + 1] + w[i, j, k + 1]) * \
                     0.25 * (u[i, j, k + 1] - u[i, j, k - 1]) * \
                     0.5 * delta_z_recip
                vn = v[i, j, k] * (v[i, j + 1, k] - v[i, j - 1, k]) * \
                     0.5 * delta_y_recip + \
                     (u[i, j - 1, k] + u[i, j, k] +
                      u[i + 1, j - 1, k] + u[i + 1, j, k]) * \
                     0.25 * (v[i + 1, j, k] - v[i - 1, j, k]) * \
                     0.5 * delta_x_recip + \
                     (w[i, j - 1, k] + w[i, j, k] +
                      w[i, j - 1, k + 1] + w[i, j, k + 1]) * \
                     0.25 * (v[i, j, k + 1] - v[i, j, k - 1]) * \
                     0.5 * delta_z_recip
                wn = w[i, j, k] * (w[i, j, k + 1] - w[i, j, k - 1]) * \
                     0.5 * delta_z_recip + \
                     (v[i, j, k - 1] + v[i, j, k] +
                      v[i, j + 1, k - 1] + v[i, j + 1, k]) * \
                     0.25 * (w[i, j + 1, k] - w[i, j - 1, k]) * \
                     0.5 * delta_y_recip + \
                     (u[i, j, k - 1] + u[i, j, k] +
                      u[i + 1, j, k - 1] + u[i + 1, j, k]) * \
                      0.25 * (w[i + 1, j, k] - w[i - 1, j, k]) * \
                      0.5 * delta_x_recip

                u[i, j, k] = u[i, j, k] + delta_t * (
                        -un - (p[i, j, k] - p[i - 1, j, k]) *
                        delta_x_recip + reynolds_recip * uv)
                v[i, j, k] = v[i, j, k] + delta_t * (
                        -vn - (p[i, j, k] - p[i, j - 1, k]) *
                        delta_y_recip + reynolds_recip * vv)
                w[i, j, k] = w[i, j, k] + delta_t * (
                        -wn - (p[i, j, k] - p[i, j, k - 1]) *
                        delta_z_recip + reynolds_recip * wv)

x_pos, z_pos = np.meshgrid(np.linspace(0, id_1, mesh_max_x),
                           np.linspace(0, kd_1, mesh_max_z))
g = plt.subplot()
g.quiver(z_pos, x_pos, u[:][10][:], w[:][10][:], color='grey')
g.set_aspect('equal')
plt.show()
