import matplotlib.pyplot as plt
import numpy as np

mesh_max_x = int(input("X方向の格子数を入力してください. (e.g. 20): ")) + 1
mesh_max_y = int(input("Y方向の格子数を入力してください. (e.g. 20): ")) + 1
time_max = int(input("計算打ち切りのタイムステップ数を入力してください."\
    "(e.g. 400): "))
delta_t = float(input("時間間隔Δtを入力してください. (e.g. 0.0005): "))
delta_x = 1 / (mesh_max_x - 1)
delta_y = 1 / (mesh_max_y - 1)
rx = delta_t / (delta_x ** 2)
ry = delta_t / (delta_y ** 2)
U = np.zeros((mesh_max_x, mesh_max_y))  # 現時点での解を記憶する配列，0で初期化
UU = np.zeros((mesh_max_x, mesh_max_y))  # 1つ後の時間ステップでの解を
                                         # 記憶する配列，0で初期化

for t in range(0, time_max):  # 2次元熱伝導方程式を陽解法を用いて解く

    for i in range(0, mesh_max_x):  # 境界条件（下と上）
        U[i, 0] = 1.0
        U[i, mesh_max_y - 1] = 0.0
    for j in range(0, mesh_max_y):  # 境界条件（左と右）
        U[0, j] = 0.5
        U[mesh_max_x - 1, j] = 0.0

    for i in range(1, mesh_max_x - 1):  # 1ステップ後の解UUを求める
        for j in range(1, mesh_max_y - 1):
            UU[i, j] = U[i, j] + rx * (U[i + 1, j] - 2 * U[i, j] + U[i - 1, j]) \
                               + ry * (U[i, j + 1] - 2 * U[i, j] + U[i, j - 1])

    for i in range(1, mesh_max_x - 1):  # 時間進行のため，
                                        # 上で求めたUUはUに置き換える
        for j in range(1, mesh_max_y - 1):
            U[i, j] = UU[i, j]

g = plt.subplot()
x_pos, y_pos = np.meshgrid(np.linspace(0, mesh_max_x - 1, mesh_max_x),
                   np.linspace(0, mesh_max_y - 1, mesh_max_y))  # グラフ描画用の
                                                                # 格子点を生成
g.contourf(y_pos, x_pos, U, alpha=0.5)
g.set_aspect('equal')
plt.show()
