import matplotlib.animation as animation
import matplotlib.pyplot as plt
import numpy as np

mesh_max = int(input("格子数を入力してください. (e.g. 20): ")) + 1
time_max = int(input("計算打ち切りのタイムステップ数を入力してください."\
                     "(e.g. 250): "))
delta_t = float(input("時間間隔Δtを入力してください. (e.g. 0.001): "))
delta_x = 1 / (mesh_max - 1)
r = delta_t / (delta_x ** 2)
mid_mesh_point = mesh_max // 2
fig = plt.figure()
graphs = []  # アニメーション化する際に必要となるグラフを保存する配列
U = np.zeros(mesh_max)  # 現時点での解を記憶する配列
UU = np.zeros(mesh_max)  # 1つ前の時間ステップでの解を記憶する配列

for i in range(0, mesh_max):  # 初期化
    X = i / (mesh_max - 1)
    if i <= mid_mesh_point:
        U[i] = X
    else:
        U[i] = 1.0 - X

for t in range(0, time_max):  # 1次元熱伝導方程式をFTCS法を用いて解く
    if t % 10 == 0:  # 10ステップに1回，アニメーション化する際に
                     # 必要となるグラフを記録
        graph = plt.plot(U, color="red")
        graphs.append(graph)

    U[0] = 0.0  # 境界条件(左側)
    U[mesh_max - 1] = 0.0  # 境界条件(右側)

    for i in range(1, mesh_max - 1):  # 1ステップ後の解UUを求める
        UU[i] = r * U[i - 1] + (1.0 - 2 * r) * U[i] + r * U[i + 1]

    for i in range(1, mesh_max - 1):  # 時間進行のため，上で求めたUUは
                                      # Uに置き換える
        U[i] = UU[i]

    if abs(U[mid_mesh_point]) >= 10000.0:
        print("DIVERGE!")
        exit()

graph = plt.plot(U, color="red")
graphs.append(graph)
animated_result = animation.ArtistAnimation(fig, graphs)
plt.show()