import matplotlib.pyplot as plt
import numpy as np

mesh_max_x = int(input("X方向の格子数を入力してください. (e.g. 20): ")) + 1
mesh_max_y = int(input("Y方向の格子数を入力してください. (e.g. 20): ")) + 1
it_max = int(input("ラプラス方程式を解く時の最大反復回数を入力してください."\
    "(e.g. 1000): "))
epsilon = float(input("反復法の許容最大誤差（収束判定条件）を入力してください."\
    "(e.g. 0.00001): "))
U = np.zeros((mesh_max_x, mesh_max_y))  # 現時点での解を記憶する配列，0で初期化
UU = np.zeros((mesh_max_x, mesh_max_y))  # １反復ステップ前での解を記憶する
                                         # 配列，0で初期化

for it in range(0, it_max):  # 連立1次方程式の解法にガウス-ザイデル法を用いて
                             # ラプラス方程式を解く

    for i in range(0, mesh_max_x):  # 境界条件 (下と上)
        U[i, 0] = 1.0
        U[i, mesh_max_y - 1] = 0.0
    for j in range(0, mesh_max_y):  # 境界条件 (左と右)
        U[0, j] = 0.5
        U[mesh_max_x - 1, j] = 0.0

    for i in range(1, mesh_max_x - 1):
        for j in range(1, mesh_max_y - 1):
            UU[i, j] = U[i, j]  # Uが変化するためUUに一旦記憶，誤差の計算に使用
            U[i, j] = 0.25 * (U[i + 1, j] + U[i, j + 1] + \
                              U[i - 1, j] + U[i, j - 1])  # ガウス-ザイデル法

    err = 0
    for i in range(1, mesh_max_x - 1):
        for j in range(1, mesh_max_y - 1):
            diff = abs((UU[i, j] - U[i, j]) / U[i, j])  # 相対誤差
            if diff >= err:
                err = diff
    if err <= epsilon:  # 収束の判定
        break
    if it % 50 == 0:
        print("it =", it, "の誤差:", err)

g = plt.subplot()
x_pos, y_pos = np.meshgrid(np.linspace(0, mesh_max_x - 1, mesh_max_x),
                   np.linspace(0, mesh_max_y - 1, mesh_max_y))  # グラフ描画用の
                                                                # 格子点を生成
g.contourf(y_pos, x_pos, U, alpha=0.5)
g.set_aspect('equal')
plt.show()
