import matplotlib.pyplot as plt
import numpy as np

mesh_max_x = int(input("X方向の格子数を入力してください (<51). (e.g. 20): ")) + 1
mesh_max_y = int(input("Y方向の格子数を入力してください (<51). (e.g. 20): ")) + 1
reynolds = int(input("レイノルズ数を入力してください. (e.g. 40): "))
it_max_poisson = int(input("ポアソン方程式を反復法で解く時の最大反復回数tを"\
    "入力してください. (e.g. 50): "))
time_max = int(input("計算打ち切りのタイムステップ数を入力してください."\
    "(e.g. 300): "))
delta_t = float(input("時間間隔Δtを入力してください. (e.g. 0.01): "))
delta_x = 1 / (mesh_max_x - 3)
delta_y = 1 / (mesh_max_y - 3)
delta_x_recip = 1 / delta_x
delta_y_recip = 1 / delta_y
delta_x_recip_half = 0.5 * delta_x_recip
delta_y_recip_half = 0.5 * delta_y_recip
delta_t_recip = 1 / delta_t
reynolds_recip = 1 / reynolds
a1 = 0.5 * delta_y ** 2 / (delta_x ** 2 + delta_y ** 2)
a2 = 0.5 * delta_x ** 2 / (delta_x ** 2 + delta_y ** 2)
a3 = 0.5 * delta_y ** 2 / (1 + delta_y ** 2 / (delta_x ** 2))

U = np.zeros((mesh_max_x, mesh_max_y))  # X方向速度Uを記憶する配列，0で初期化
V = np.zeros((mesh_max_x, mesh_max_y))  # Y方向速度Vを記憶する配列，0で初期化
P = np.zeros((mesh_max_x, mesh_max_y))  # 圧力Pを記憶する配列，0で初期化
R = np.zeros((mesh_max_x, mesh_max_y))  # ポアソン方程式の右辺（ソース項）を
    # 記憶する配列，またVの一時記憶場所や計算終了後の流れ関数の記憶場所
D = np.zeros((mesh_max_x, mesh_max_y))  # div V を記憶する配列，Uの一時記憶場所

for t in range(0, time_max):
    for i in range(0, mesh_max_x):  # 境界条件
        U[i, mesh_max_y - 2] = 1
        V[i, mesh_max_y - 1] = V[i, mesh_max_y - 3]
        V[i, mesh_max_y - 2] = 0
        V[i, 0] = V[i, 2]
        V[i, 1] = 0
        U[i, 0] = -U[i, 1]
    for j in range(0, mesh_max_y):  # 境界条件
        U[mesh_max_x - 1, j] = U[mesh_max_x - 3, j]
        U[mesh_max_x - 2, j] = 0
        V[mesh_max_x - 2, j] = -V[mesh_max_x - 3, j]
        U[0, j] = U[2, j]
        U[1, j] = 0
        V[0, j] = -V[1, j]

    for j in range(1, mesh_max_y - 2):  # ポアソン方程式の右辺の計算
        for i in range(1, mesh_max_x - 2):
            u1 = (U[i + 1, j] - U[i, j]) * delta_x_recip
            v2 = (V[i, j + 1] - V[i, j]) * delta_y_recip
            D[i, j] = u1 + v2
            ua = 0.25 * (U[i, j] + U[i + 1, j] + U[i + 1, j + 1] + U[i, j + 1])
            ub = 0.25 * (U[i, j] * U[i + 1, j] + U[i + 1, j - 1] + U[i, j - 1])
            va = 0.25 * (V[i, j] + V[i, j + 1] + V[i + 1, j + 1] + V[i + 1, j])
            vb = 0.25 * (V[i, j] + V[i, j + 1] + V[i - 1, j + 1] + V[i - 1, j])
            R[i, j] = -u1 ** 2 - 2 * (ua - ub) * (va - vb) * \
                      delta_x_recip * delta_y_recip - \
                      v2 ** 2 + delta_t_recip * (u1 + v2)
    for it_poisson in range(0, it_max_poisson):  # 圧力のポアソン方程式を
                                                 # SOR法で解く
        g2 = 0
        for j in range(0, mesh_max_y):  # 圧力の境界条件
            P[0, j] = P[1, j]
            P[mesh_max_x - 2, j] = P[mesh_max_x - 3, j]
        for i in range(0, mesh_max_x):  # 圧力の境界条件
            P[i, 0] = P[i, 1]
            P[i, mesh_max_y - 2] = P[i, mesh_max_y - 3]

        for j in range(1, mesh_max_y - 2):  # SOR法
            for i in range(1, mesh_max_x - 2):
                uli = a1 * (P[i + 1, j] + P[i - 1, j]) + \
                      a2 * (P[i, j + 1] + P[i, j - 1]) - a3 * R[i, j] - P[i, j]
                g2 = g2 + uli ** 2
                P[i, j] = uli + P[i, j]

        if g2 <= 0.000001:
            if t % 2 == 0:
                print(t, it_poisson, g2)
            break

    for j in range(1, mesh_max_y - 2):
        for i in range(2, mesh_max_x - 2):
            v1 = 0.25 * (V[i, j] + V[i, j + 1] + V[i - 1, j + 1] + V[i - 1, j])
            un = U[i, j] * (U[i + 1, j] - U[i - 1, j]) * \
                 delta_x_recip_half + \
                 v1 * (U[i, j + 1] - U[i, j - 1]) * delta_y_recip_half
            uv = (U[i + 1, j] - 2 * U[i, j] + U[i - 1, j]) * \
                 delta_x_recip ** 2 + \
                 (U[i, j + 1] - 2 * U[i, j] + U[i, j - 1]) * delta_y_recip ** 2
            D[i, j] = U[i, j] + delta_t * (-un - (P[i, j] - P[i - 1, j]) *
                      delta_x_recip + reynolds_recip * uv)

    for j in range(2, mesh_max_y - 2):
        for i in range(1, mesh_max_x - 2):
            u1 = 0.25 * (U[i, j] + U[i + 1, j] + U[i + 1, j - 1] + U[i, j - 1])
            vn = u1 * (V[i + 1, j] - V[i - 1, j]) * \
                 delta_x_recip_half + \
                 V[i, j] * (V[i, j + 1] - V[i, j - 1]) * delta_y_recip_half
            vv = (V[i + 1, j] - 2 * V[i, j] + V[i - 1, j]) * \
                 delta_x_recip ** 2 + \
                 (V[i, j + 1] - 2 * V[i, j] + V[i, j - 1]) * delta_y_recip ** 2
            R[i, j] = V[i, j] + delta_t * (-vn - (P[i, j] - P[i, j - 1]) *
                      delta_y_recip + reynolds_recip * vv)

    for j in range(1, mesh_max_y - 2):
        for i in range(2, mesh_max_x - 2):
            U[i, j] = D[i, j]

    for j in range(2, mesh_max_y - 2):
        for i in range(1, mesh_max_x - 2):
            V[i, j] = R[i, j]

for i in range(0, mesh_max_x):
    R[i, 0] = 0
for j in range(1, mesh_max_y):
    for i in range(0, mesh_max_x):
        R[i, j] = R[i, j - 1] + delta_y * U[i, j]

x = np.linspace(0, 1, mesh_max_x)
y = np.linspace(0, 1, mesh_max_y)
X, Y = np.meshgrid(x, y)  # グラフ描画用の格子点を生成
g = plt.subplot()
g.quiver(Y, X, U, V, color='grey')
g.set_aspect('equal')
plt.show()
