import math
import matplotlib.pyplot as plt
import numpy as np

time_max = int(input("計算打ち切りのタイムステップ数を入力してください."\
    "(e.g. 400): "))
test_type = int(input("テスト計算のタイプを教えてください．"\
    "3つの長方形の障害物がある場合->1, 円柱がある場合->2: "))
reynolds = int(input("レイノルズ数を入力してください. (e.g. 40): "))
delta_t = float(input("時間間隔Δtを入力してください. (e.g. 0.005): "))

id = 61  # X方向の格子点数
jd = 31  # Y方向の格子点数
ul = np.zeros(id)  # 圧力の反復法での修正量
x = np.zeros(id)  # 格子点のX座標を記憶する配列
xa = np.zeros(id)  # Xの二階微係数を計算するときでてくる係数
xb = np.zeros(id)  # Xの二階微係数を計算するときでてくる係数
xc = np.zeros(id)  # ポアソン方程式の差分近似式に現れる係数
xd = np.zeros(id)  # ポアソン方程式の差分近似式に現れる係数
xg = np.zeros(id)  # Xの一階微係数を計算するときででくる係数
y = np.zeros(jd)  # 格子点のY座標を記憶する配列
ya = np.zeros(jd)  # Yの二階微係数を計算するときでてくる係数
yb = np.zeros(jd)  # Yの二階微係数を計算するときでてくる係数
yc = np.zeros(jd)  # ポアソン方程式の差分近似式に現れる係数
yd = np.zeros(jd)  # ポアソン方程式の差分近似式に現れる係数
yg = np.zeros(jd)  # Yの一階微係数を計算するときででくる係数
ifl = np.zeros((id, jd))  # 流体の有無を記憶する配列
ibd = np.zeros((id, jd))  # 境界の位置を記憶する配列
iwt = np.zeros((id, jd))  # 境界の種類を記憶する配列
u = np.zeros((id, jd))  # X方向速度Uを記憶する配列
v = np.zeros((id, jd))  # Y方向速度Vを記憶する配列
p = np.zeros((id, jd))  # 圧力Pを記憶する配列
q = np.zeros((id, jd))  # div V を記憶する配列，Uの一時記憶場所
d = np.zeros((id, jd))  # ポアソン方程式を解くとき用いる係数
s = np.zeros((id, jd))  # 境界の圧力を記憶する配列
l1 = [11, 15, 7, 16]
l2 = [25, 29, 12, 24]
l3 = [38, 43, 9, 17]

# テスト計算のためのデータを作成
if test_type == 1:  # ３つの長方形の障害物がある場合
    for i in range(0, id - 10):
        x[i] = 4 * i / (id - 1)
    for i in range(id - 10, id):
        x[i] = x[i - 1] + (x[id - 11] - x[id - 12]) * 1.2 ** (i - id + 11)
    for j in range(0, jd):
        y[j] = j / (jd - 1)

    for j in range(0, jd):
        for i in range(0, id):
            ifl[i, j] = 1

    for j in range(l1[2] - 1, l1[3]):
        for i in range(l1[0] - 1, l1[1]):
            ifl[i, j] = 0

    for j in range(l2[2] - 1, l2[3]):
        for i in range(l2[0] - 1, l2[1]):
            ifl[i, j] = 0

    for j in range(l3[2] - 1, l3[3]):
        for i in range(l3[0] - 1, l3[1]):
            ifl[i, j] = 0

else:  # 円柱がある場合
    for i in range(0, id):
        x[i] = i / (id - 1) * 4
    for j in range(0, jd):
        y[j] = j / (jd - 1)
    for j in range(0, jd):
        for i in range(0, id):
            stl = math.sqrt((x[i] - 1.3) ** 2 + (y[j] - 0.5) ** 2)
            ifl[i, j] = 1
            if stl < 0.2:
                ifl[i, j] = 0

delta_t_recip = 1 / delta_t
reynolds_recip = 1 / reynolds
id_1 = id - 1
id_2 = id - 2
jd_1 = jd - 1
jd_2 = jd - 2
it_max_poisson = 10  # 圧力に関するポアソン方程式の近似差分方程式を
                     # ガウス-ザイデル法で解くときの最大反復回数

# メトリックの計算（1次元）
for i in range(1, id_1):
    xg[i] = 2 / (x[i + 1] - x[i - 1])
    xa[i] = xg[i] * xg[i]
    xb[i] = (x[i + 1] - 2 * x[i] + x[i - 1]) * xg[i] ** 3
    xc[i] = xa[i] - xb[i] * 0.5
    xd[i] = xa[i] + xb[i] * 0.5

for j in range(1, jd_1):
    yg[j] = 2 / (y[j + 1] - y[j - 1])
    ya[j] = yg[j] * yg[j]
    yb[j] = (y[j + 1] - 2 * y[j] + y[j - 1]) * yg[j] ** 3
    yc[j] = ya[j] - yb[j] * 0.5
    yd[j] = ya[j] + yb[j] * 0.5

# 流体の有無および境界の位置の計算,
# 境界セルの場合はIBDを1，そうでない場合はIBDを0
for j in range(0, jd):
    for i in range(0, id - 1):
        if ifl[i + 1, j] - ifl[i, j] == -1:
            ibd[i, j] = 1

    for i in range(id - 1, 0, -1):
        if ifl[i, j] - ifl[i - 1, j] == 1:
            ibd[i, j] = 1

for i in range(0, id):
    for j in range(0, jd - 1):
        if ifl[i, j + 1] - ifl[i, j] == -1:
            ibd[i, j] = 1

    for j in range(jd - 1, 0, -1):
        if ifl[i, j] - ifl[i, j - 1] == 1:
            ibd[i, j] = 1

for j in range(0, jd):
    for i in range(0, id):
        ibd[i, j] = ibd[i, j] * ifl[i, j]

for j in range(1, jd - 1):
    for i in range(1, id - 1):
        iqq = ibd[i + 1, j] + ibd[i - 1, j] + ibd[i, j + 1] + ibd[i, j - 1]
        iqq = iqq * (1 - ifl[i, j])
        if iqq == 1:
            iwt[i, j] = 12
        elif iqq == 2:
            iwt[i, j] = 6
        elif iqq == 3:
            iwt[i, j] = 4
        elif iqq == 4:
            iwt[i, j] = 3

# 初期化
for j in range(0, jd):
    for i in range(0, id):
        u[i, j] = 1

for t in range(0, time_max):
    for i in range(0, id):  # 境界条件(上と下)
        u[i, jd - 1] = u[i, jd_2 - 1]
        v[i, jd - 1] = -v[i, jd_2 - 1]
        u[i, 0] = u[i, 2]
        v[i, 0] = -v[i, 2]
        u[i, jd_1 - 1] = u[i, jd_2 - 1]
        v[i, jd_1 - 1] = 0
        u[i, 1] = u[i, 2]
        v[i, 1] = 0

    for j in range(0, jd):  # 境界条件(右)
        u[id - 1, j] = u[id_2 - 1, j]
        v[id - 1, j] = v[id_2 - 1, j]
        u[id_1 - 1, j] = u[id_2 - 1, j]
        v[id_1 - 1, j] = v[id_2 - 1, j]

    for j in range(1, jd_1):  # ポアソン方程式の右辺の計算
        for i in range(1, id_1):
            u1 = (u[i + 1, j] - u[i - 1, j]) * 0.5 * xg[i]
            u2 = (u[i, j + 1] - u[i, j - 1]) * 0.5 * yg[j]
            v1 = (v[i + 1, j] - v[i - 1, j]) * 0.5 * xg[i]
            v2 = (v[i, j + 1] - v[i, j - 1]) * 0.5 * yg[j]
            q[i, j] = -u1 * u1 - v2 * v2 - 2 * u2 * v1 + \
                      delta_t_recip * (u1 + v2)

    for j in range(1, jd_1):
        for i in range(1, id_1):
            d[i, j] = 0.5 / (xa[i] + ya[j])

    for it_poisson in range(0, it_max_poisson):  # 圧力のポアソン方程式を
                                                 # ヤコビ法で解く
        g1 = 0
        for j in range(1, jd - 1):  # 障害物の境界上における圧力を計算
            for i in range(1, id - 1):
                s[i, j] = ibd[i + 1, j] * p[i + 1, j] + \
                          ibd[i - 1, j] * p[i - 1, j] + \
                          ibd[i, j + 1] * p[i, j + 1] + \
                          ibd[i, j - 1] * p[i, j - 1]
        for j in range(1, jd - 1):
            for i in range(1, id - 1):
                p[i, j] = s[i, j] * (1 - ifl[i, j]) * iwt[i, j] / 12 + \
                          p[i, j] * ifl[i, j]

        for j in range(0, jd):  # 圧力の境界条件
            p[1, j] = p[2, j]
            p[id_1 - 1, j] = p[id_2 - 1, j]

        for i in range(0, id):  # 圧力の境界条件
            p[i, 1] = p[i, 2]
            p[i, jd_1 - 1] = p[i, jd_2 - 1]

        for j in range(2, jd_2):
            for i in range(2, id_2):
                ul[i] = d[i, j] * (xc[i] * p[i + 1, j] + yc[j] * p[i, j + 1] +
                        xd[i] * p[i - 1, j] + yd[j] * p[i, j - 1] - q[i, j]) - \
                        p[i, j]

            for i in range(2, id_2):
                g1 = g1 + ul[i] ** 2 * ifl[i, j]

            for i in range(2, id_2):
                p[i, j] = ul[i] + p[i, j] * ifl[i, j]

        if g1 <= 0.0001:
            print(t, it_poisson, g1)
            break

    for j in range(2, jd_2):  # 速度の計算
        for i in range(2, id_2):
            unx = u[i, j] * (u[i + 1, j] - u[i - 1, j]) / 2 - abs(u[i, j]) * (
                    u[i + 1, j] - 2 * u[i, j] + u[i - 1, j]) / 2
            uny = v[i, j] * (u[i, j + 1] - u[i, j - 1]) / 2 - abs(v[i, j]) * (
                    u[i, j + 1] - 2 * u[i, j] + u[i, j - 1]) / 2
            vnx = u[i, j] * (v[i + 1, j] - v[i - 1, j]) / 2 - abs(u[i, j]) * (
                    v[i + 1, j] - 2 * v[i, j] + v[i - 1, j]) / 2
            vny = v[i, j] * (v[i, j + 1] - v[i, j - 1]) / 2 - abs(v[i, j]) * (
                    v[i, j + 1] - 2 * v[i, j] + v[i, j - 1]) / 2

            uv = (u[i + 1, j] - 2 * u[i, j] + u[i - 1, j]) * xa[i] + \
                 (u[i, j + 1] - 2 * u[i, j] + u[i, j - 1]) * ya[j] - \
                 (u[i + 1, j] - u[i - 1, j]) * 0.5 * xb[i] - \
                 (u[i, j + 1] - u[i, j - 1]) * 0.5 * yb[j]
            vv = (v[i + 1, j] - 2 * v[i, j] + v[i - 1, j]) * xa[i] + \
                 (v[i, j + 1] - 2 * v[i, j] + v[i, j - 1]) * ya[j] - \
                 (v[i + 1, j] - v[i - 1, j]) * 0.5 * xb[i] - \
                 (v[i, j + 1] - v[i, j - 1]) * 0.5 * yb[j]

            d[i, j] = u[i, j] + delta_t * (-(unx * xg[i] + uny * yg[j]) -
                      (p[i + 1, j] - p[i - 1, j]) * 0.5 * xg[i] +
                      reynolds_recip * uv)
            q[i, j] = v[i, j] + delta_t * (-(vnx * xg[i] + vny * yg[j]) -
                      (p[i, j + 1] - p[i, j - 1]) * 0.5 * yg[j] +
                      reynolds_recip * vv)

    for j in range(2, jd_2):
        for i in range(2, id_2):
            u[i, j] = d[i, j] * ifl[i, j]
            v[i, j] = q[i, j] * ifl[i, j]

speed = np.zeros((jd, id))
for j in range(0, jd):
    for i in range(0, id):
        speed[j, i] = math.sqrt(u[i, j] ** 2 + v[i, j] ** 2)
x_pos, y_pos = np.meshgrid(x, y)
g = plt.subplot()
g.contourf(x_pos, y_pos, speed, alpha=0.5)
g.set_aspect('equal')
plt.show()
