import math
import matplotlib.pyplot as plt
import numpy as np

mesh_max_x = int(input("X方向の格子数を入力してください (<51). (e.g. 20): ")) + 1
mesh_max_y = int(input("Y方向の格子数を入力してください (<51). (e.g. 20): ")) + 1
reynolds = int(input("レイノルズ数を入力してください. (e.g. 100): "))
it_max_poisson = int(input("ポアソン方程式を反復法で解く時の最大反復回数tを"\
    "入力してください. (e.g. 20): "))
time_max = int(input("計算打ち切りのタイムステップ数を"\
    "入力してください. (e.g. 400): "))
delta_t = float(input("時間間隔Δtを入力してください. (e.g. 0.01): "))
epsilon = float(input("反復法の許容最大誤差（収束判定条件）を"\
    "入力してください. (e.g. 0.00001): "))
bx = float(input("X方向の格子の集中度を指定するパラメータを"\
    "入力してください (<1). (e.g. 0.98): "))
by = float(input("Y方向の格子の集中度を指定するパラメータを"\
    "入力してください (<1). (e.g. 0.98): "))
y_coord_in = int(input("流入口（流入口は(1,y_coord_in)-(1,NY) の間にある）"\
    "を入力してください. (e.g. 17): "))
y_coord_out = int(input("流出口（流出口は(NX,1)-(NX,y_coord_out)の間にある）"\
    "を入力してください. (e.g. 5): "))
delta_t_recip = 1 / delta_t
reynolds_recip = 1 / reynolds

U = np.zeros((mesh_max_x, mesh_max_y))  # X方向速度Uを記憶する配列，0で初期化
V = np.zeros((mesh_max_x, mesh_max_y))  # Y方向速度Vを記憶する配列，0で初期化
P = np.zeros((mesh_max_x, mesh_max_y))  # 圧力Pを記憶する配列，0で初期化
R = np.zeros((mesh_max_x, mesh_max_y))  # ポアソン方程式の右辺（ソース項）を
    # 記憶する配列，またVの一時記憶場所や計算終了後の流れ関数の記憶場所
D = np.zeros((mesh_max_x, mesh_max_y))  # div V を記憶する配列，Uの一時記憶場所
x = np.zeros(mesh_max_x + 1)
y = np.zeros(mesh_max_y + 1)
a1 = np.zeros(mesh_max_x)
b1 = np.zeros(mesh_max_x)
c1 = np.zeros(mesh_max_x)
a2 = np.zeros(mesh_max_x)
b2 = np.zeros(mesh_max_x)
c2 = np.zeros(mesh_max_x)
a3 = np.zeros(mesh_max_y)
b3 = np.zeros(mesh_max_y)
c3 = np.zeros(mesh_max_y)
a4 = np.zeros(mesh_max_y)
b4 = np.zeros(mesh_max_y)
c4 = np.zeros(mesh_max_y)

# 格子生成
fa = (math.exp(bx) + 1) / (math.exp(bx) - 1)
fb = (math.exp(by) + 1) / (math.exp(by) - 1)
for i in range(0, mesh_max_x):
    bxa = bx * i / (mesh_max_x - 1)
    x[i] = fa * (math.exp(bxa) - 1) / (math.exp(bxa) + 1)
x00 = 2 * x[0] - x[1]
x[mesh_max_x] = 2 * x[mesh_max_x - 1] - x[mesh_max_x - 2]
for j in range(0, mesh_max_y):
    bya = by * j / (mesh_max_y - 1)
    y[j] = fb * (math.exp(bya) - 1) / (math.exp(bya) + 1)
y00 = 2 * y[0] - y[1]
y[mesh_max_y] = 2 * y[mesh_max_y - 1] - y[mesh_max_y - 2]

# メトリックの計算（1次元）
for i in range(0, mesh_max_x):
    x1 = x[i + 1] - x[i]
    if i > 0:
        x2 = x[i] - x[i - 1]
        x3 = x[i + 1] - x[i - 1]
        x4 = x[i + 1] - 2 * x[i] + x[i - 1]
    else:
        x2 = x[i] - x00
        x3 = x[i + 1] - x00
        x4 = x[i + 1] - 2 * x[i] + x00
    a1[i] = -x1 / (x2 * x3)
    b1[i] = x4 / (x1 * x2)
    c1[i] = x2 / (x1 * x3)
    a2[i] = 2 / (x2 * x3)
    b2[i] = -2 / (x1 * x2)
    c2[i] = 2 / (x1 * x3)

for j in range(0, mesh_max_y):
    y1 = y[j + 1] - y[j]
    if j > 0:
        y2 = y[j] - y[j - 1]
        y3 = y[j + 1] - y[j - 1]
        y4 = y[j + 1] - 2 * y[j] + y[j - 1]
    else:
        y2 = y[j] - y00
        y3 = y[j + 1] - y00
        y4 = y[j + 1] - 2 * y[j] + y00
    a3[j] = -y1 / (y2 * y3)
    b3[j] = y4 / (y1 * y2)
    c3[j] = y2 / (y1 * y3)
    a4[j] = 2 / (y2 * y3)
    b4[j] = -2 / (y1 * y2)
    c4[j] = 2 / (y1 * y3)

for t in range(0, time_max):
    for i in range(0, mesh_max_x):  # 境界条件
        U[i, mesh_max_y - 1] = 0
        V[i, mesh_max_y - 1] = 0
        V[i, 0] = 0
        U[i, 0] = 0
    for j in range(y_coord_out, mesh_max_y):
        U[mesh_max_x - 1, j] = 0
        V[mesh_max_x - 1, j] = 0
    for j in range(0, y_coord_in - 1):  # 境界条件
        U[0, j] = 0
        V[0, j] = 0
    for j in range(y_coord_in - 1, mesh_max_y - 1):  # 境界条件
        U[0, j] = 1
        V[0, j] = 0
    for j in range(0, y_coord_out):  # 境界条件
        U[mesh_max_x - 1, j] = 1
        V[mesh_max_x - 1, j] = 0

    for j in range(1, mesh_max_y - 1):  # ポアソン方程式の右辺の計算
        for i in range(1, mesh_max_x - 1):
            u1 = a1[i] * U[i - 1, j] + b1[i] * U[i, j] + c1[i] * U[i + 1, j]
            u2 = a3[j] * U[i, j - 1] + b3[j] * U[i, j] + c3[j] * U[i, j + 1]
            v1 = a1[i] * V[i - 1, j] + b1[i] * V[i, j] + c1[i] * V[i + 1, j]
            v2 = a3[j] * V[i, j - 1] + b3[j] * V[i, j] + c3[j] * V[i, j + 1]
            R[i, j] = -u1 ** 2 - 2 * u2 * v1 - \
                      v2 ** 2 + delta_t_recip * (u1 + v2)
    for it_poisson in range(0, it_max_poisson):  # 圧力のポアソン方程式を
                                                 # SOR法で解く
        g2 = 0
        for j in range(0, mesh_max_y):  # 圧力の境界条件
            P[0, j] = P[1, j]
            P[mesh_max_x - 1, j] = P[mesh_max_x - 2, j]
        for i in range(0, mesh_max_x):  # 圧力の境界条件
            P[i, 0] = P[i, 1]
            P[i, mesh_max_y - 1] = P[i, mesh_max_y - 2]

        for j in range(1, mesh_max_y - 1):
            for i in range(1, mesh_max_x - 1):
                uli = -(a2[i] * P[i - 1, j] + c2[i] * P[i + 1, j] +
                        a4[j] * P[i, j - 1] + c4[j] * P[i, j + 1] -
                        R[i, j]) / (b2[i] + b4[j]) - P[i, j]
                g2 = g2 + uli ** 2
                P[i, j] = uli + P[i, j]

        if g2 <= epsilon:
            break
        ppp = P[1, 1]
        for j in range(0, mesh_max_y):
            for i in range(0, mesh_max_x):
                P[i, j] = P[i, j] - ppp
        if t % 2 == 0:
            print(t, it_poisson, g2)

    for j in range(1, mesh_max_y - 1):
        for i in range(1, mesh_max_x - 1):
            UN = U[i, j] * (a1[i] * U[i - 1, j] + b1[i] * U[i, j] +
                            c1[i] * U[i + 1, j]) + \
                 V[i, j] * (a3[j] * U[i, j - 1] +
                            b3[j] * U[i, j] + c3[j] * U[i, j + 1])
            UV = a2[i] * U[i - 1, j] + b2[i] * U[i, j] + c2[i] * U[i + 1, j] + \
                 a4[j] * U[i, j - 1] + b4[j] * U[i, j] + c4[j] * U[i, j + 1]
            PX = a1[i] * P[i - 1, j] + b1[i] * P[i, j] + c1[i] * P[i + 1, j]

            D[i, j] = U[i, j] + delta_t * (-UN - PX + reynolds_recip * UV)

    for j in range(1, mesh_max_y - 1):
        for i in range(1, mesh_max_x - 1):
            VN = U[i, j] * (a1[i] * V[i - 1, j] + b1[i] * V[i, j] +
                            c1[i] * V[i + 1, j]) + \
                 V[i, j] * (a3[j] * V[i, j - 1] + b3[j] * V[i, j] +
                            c3[j] * V[i, j + 1])
            VV = a2[i] * V[i - 1, j] + b2[i] * V[i, j] + c2[i] * V[i + 1, j] + \
                 a4[j] * V[i, j - 1] + b4[j] * V[i, j] + c4[j] * V[i, j + 1]
            PY = a3[j] * P[i, j - 1] + b3[j] * P[i, j] + c3[j] * P[i, j + 1]
            R[i, j] = V[i, j] + delta_t * (-VN - PY + reynolds_recip * VV)

    for j in range(1, mesh_max_y - 1):
        for i in range(1, mesh_max_x - 1):
            U[i, j] = D[i, j]

    for j in range(1, mesh_max_y - 1):
        for i in range(1, mesh_max_x - 1):
            V[i, j] = R[i, j]

X, Y = np.meshgrid(x[0:mesh_max_x], y[0:mesh_max_y])  # グラフ描画用の
                                                      # 格子点を生成
g = plt.subplot()
g.quiver(Y, X, U, V, color='grey')
g.set_aspect('equal')
plt.show()
