import numpy as np

MX = int(input("Input number of mesh for X-direction. (e.g. 30): "))
MY = int(input("Input number of mesh for Y-direction. (e.g. 30): "))
MZ = int(input("Input number of mesh for Z-direction. (e.g. 30): "))
DX = float(input("Input DX. (e.g. 0.2): "))
DY = float(input("Input DY. (e.g. 0.1): "))
DZ = float(input("Input DZ. (e.g. 0.1): "))
I2 = int(input("Input center of sphere, I2. (e.g. 9): "))
J2 = int(input("Input center of sphere, J2. (e.g. 17): "))
K2 = int(input("Input center of sphere, K2. (e.g. 17): "))
R = float(input("Input radius of sphere. (e.g. 0.8): "))
I1 = int(input("Input corner of cubic, I1. (e.g. 18): "))
J1 = int(input("Input corner of cubic, J1. (e.g. 7): "))
K1 = int(input("Input corner of cubic, K1. (e.g. 7): "))
H = int(input("Input side length of cubic. (e.g. 1): "))
MARK = np.zeros((MX + 1, MY + 1, MZ + 1))
X = np.zeros(MX + 1)
Y = np.zeros(MY + 1)
Z = np.zeros(MZ + 1)

for i in range(0, MX + 1):
    X[i] = DX * i

for j in range(0, MY + 1):
    Y[j] = DY * j

for k in range(0, MZ + 1):
    Z[k] = DZ * k

for k in range(0, MZ + 1):
    for j in range(0, MY + 1):
        for i in range(0, MX + 1):
            MARK[i, j, k] = 1

for k in range(0, MZ + 1):
    for j in range(0, MY + 1):
        for i in range(0, MX + 1):
            RR = (X[i] - X[I2]) ** 2 + (Y[j] - Y[J2]) ** 2 + (Z[k] - Z[K2]) ** 2
            if RR <= R * R:
                MARK[i, j, k] = 0

for k in range(0, MZ + 1):
    for j in range(0, MY + 1):
        for i in range(0, MX + 1):
            if X[I1] <= X[i] <= X[I1] + H and Y[J1] <= Y[j] <= Y[J1] + H and \
               Z[K1] <= Z[k] <= Z[K1] + H:
                MARK[i, j, k] = 0

MX1 = MX + 1
MY1 = MY + 1
MZ1 = MZ + 1
with open('mark_generation_data.txt', 'w') as file:
    file.write(str(MX1) + '\t' + str(MY1) + '\t' + str(MZ1))
    file.write('\n')
    for i in range(0, MX1):
        file.write(str(X[i]))
        file.write('\t')
    file.write('\n')

    for j in range(0, MY1):
        file.write(str(Y[j]))
        file.write('\t')
    file.write('\n')

    for k in range(0, MZ1):
        file.write(str(Z[k]))
        file.write('\t')
    file.write('\n')

    for k in range(0, MZ1):
        for j in range(0, MY1):
            for i in range(0, MX1):
                file.write(str(MARK[i, j, k]))
