import math
import matplotlib.cm as cm
import matplotlib.pyplot as plt
import numpy as np

mesh_max_angular = int(input("周方向の格子数を入力してください (<51)."\
    "(e.g. 40): ")) + 1
mesh_max_radial = int(input("半径方向の格子数を入力してください (<51)."\
    "(e.g. 40): ")) + 1
delta_angular = math.pi / (mesh_max_angular - 1)
delta_radial = float(input("半径方向格子間隔Δrを入力してください."\
    "(e.g. 0.1): "))
delta_angular_recip = 1 / delta_angular
delta_radial_recip = 1 / delta_radial
delta_angular_sq = delta_angular_recip ** 2
delta_radial_sq = delta_radial_recip ** 2

time_max = int(input("計算打ち切りのタイムステップ数を入力してください."
    "(e.g. 500): "))
delta_t = float(input("時間間隔Δtを入力してください. (e.g. 0.01): "))

it_max_poisson = int(input("ポアソン方程式を反復法で解く時の最大反復回数tを"\
    "入力してください. (e.g. 40): "))
acceleration_coef_poisson = float(input("ポアソン方程式の近似差分方程式を"\
    "ＳＯＲ法で解くための加速係数を入力してください. (e.g. 1.0): "))
const_poisson = 1 / (2 * delta_angular_sq + 2 * delta_radial_sq)
epsilon = float(input("反復法の許容最大誤差（収束判定条件）を入力してください."\
    "(e.g. 0.01): "))

reynolds = int(input("レイノルズ数を入力してください. (e.g. 80): "))
reynolds_recip = 1 / reynolds

PSI = np.zeros((mesh_max_angular, mesh_max_radial), dtype=np.float32)
    # 流れ関数ψを記憶する配列、0で初期化
OMG = np.zeros((mesh_max_angular, mesh_max_radial), dtype=np.float32)
    # 渦度ωを記憶する配列、0で初期化
TMP = np.zeros((mesh_max_angular, mesh_max_radial), dtype=np.float32)
    # 温度Tを記憶する配列、0で初期化

for j in range(0, mesh_max_radial):  # 初期化
    for i in range(0, mesh_max_angular):
        PSI[i, j] = math.exp(delta_radial * j) * math.sin(delta_angular * i)
        OMG[i, j] = 0

for t in range(0, time_max):
    vorticity_boundary_correction = t / 30
    if vorticity_boundary_correction >= 1:
        vorticity_boundary_correction = 1

    for i in range(0, mesh_max_angular):  # 円柱上の境界条件
        OMG[i, 0] = -2 * PSI[i, 1] * delta_radial_sq * \
                         vorticity_boundary_correction
        PSI[i, 0] = 0

    for i in range(0, mesh_max_angular):  # 遠方境界条件
        PSI[i, mesh_max_radial - 1] = math.exp((mesh_max_radial - 1) * \
            delta_radial) * math.sin(delta_angular * i)
        OMG[i, mesh_max_radial - 1] = 0

    for j in range(0, mesh_max_radial):  # 対称線沿いの境界条件
        PSI[0, j] = 0
        OMG[0, j] = 0
        PSI[mesh_max_angular - 1, j] = 0
        OMG[mesh_max_angular - 1, j] = 0

    for it_poisson in range(0, it_max_poisson):
        err_diff = 0
        for j in range(1, mesh_max_radial - 1):
            for i in range(1, mesh_max_angular - 1):
                rhs = ((PSI[i + 1, j] + PSI[i - 1, j]) * delta_angular_sq +
                       (PSI[i, j + 1] + PSI[i, j - 1]) * delta_radial_sq +
                       OMG[i, j] * math.exp(2 * j * delta_radial)) * \
                      const_poisson
                err_diff = err_diff + (rhs - PSI[i, j]) ** 2
                PSI[i, j] = PSI[i, j] * (1 - acceleration_coef_poisson) + \
                            rhs * acceleration_coef_poisson
        if err_diff < 0.00001:
            if t % 5 == 0:
                print("ITERATION NO. =", it_poisson, "ERROR(L2) =", err_diff)
            break

    for j in range(1, mesh_max_radial - 1):
        for i in range(1, mesh_max_angular - 1):
            TMP[i, j] = OMG[i, j]
            rhs = ((OMG[i + 1, j] - 2 * OMG[i, j] + OMG[i - 1, j]) *
                   delta_angular_sq +
                   (OMG[i, j + 1] - 2 * OMG[i, j] + OMG[i, j - 1]) *
                   delta_radial_sq) * \
                   reynolds_recip + \
                   ((PSI[i + 1, j] - PSI[i - 1, j]) * (OMG[i, j + 1] -
                    OMG[i, j - 1]) - (PSI[i, j + 1] - PSI[i, j - 1]) *
                    (OMG[i + 1, j] - OMG[i - 1, j])) * \
                   delta_angular_recip * delta_radial_recip / 4
            OMG[i, j] = OMG[i, j] + \
                        delta_t * rhs * math.exp(-2 * j * delta_radial)

    vorticity_max_diff = 0
    for j in range(1, mesh_max_radial - 1):
        for i in range(1, mesh_max_angular - 1):
            vorticity_diff = abs(OMG[i, j] - TMP[i, j])
            if vorticity_diff >= vorticity_max_diff:
                vorticity_max_diff = vorticity_diff
    if t % 5 == 0:
        print("TIMESTEP NO. =", t, "ERROR(OMG) =", vorticity_max_diff)
    if t > 10:
        if vorticity_max_diff <= epsilon:
            break

x = np.zeros((mesh_max_angular, mesh_max_radial))
y = np.zeros((mesh_max_angular, mesh_max_radial))

for j in range(0, mesh_max_radial):
    for i in range(0, mesh_max_angular):
        x[i, j] = mesh_max_radial * j * math.cos(delta_angular * i)
        y[i, j] = mesh_max_radial * j * math.sin(delta_angular * i)

g = plt.subplot()
g.contourf(x, y, PSI, alpha=0.5, cmap=cm.viridis)
g.set_aspect('equal')
plt.show()
