import matplotlib.cm as cm
import matplotlib.pyplot as plt
import numpy as np

mesh_max = int(input("格子点数を入力してください (<51)(Ｘ，Ｙ方向同数)."\
                     "(e.g. 20): ")) + 1
delta_mesh = 1 / (mesh_max - 1)
mesh_recip = 1 / delta_mesh
delta_mesh_sq = delta_mesh ** 2
it_max = int(input("計算打ち切りのタイムステップ数を入力してください."\
                   "(e.g. 500): "))
acceleration_coef_psi = float(input("流れ関数に関するポアソン方程式の近似差分"\
                                    "方程式をＳＯＲ法で解くための加速係数を"\
                                    "入力してください. (e.g. 1.0): "))
acceleration_coef_omg = float(input("渦度に関するポアソン方程式の近似差分方程式を"\
                                    "ＳＯＲ法で解くための加速係数を"\
                                    "入力してください. (e.g. 1.0): "))
epsilon = float(input("反復法の許容最大誤差（収束判定条件）を入力してください."\
                      "(e.g. 0.00001): "))
reynolds = int(input("レイノルズ数を入力してください. (e.g. 40): "))

PSI = np.zeros((mesh_max, mesh_max))  # 流れ関数ψを記憶する配列，0で初期化
OMG = np.zeros((mesh_max, mesh_max))  # 渦度ωを記憶する配列，0で初期化
TMP = np.zeros((mesh_max, mesh_max))  # 流れ関数や渦度ωを一時的に記憶する配列

x = np.linspace(0, 1, mesh_max)
y = np.linspace(0, 1, mesh_max)
X, Y = np.meshgrid(x, y)  # グラフ描画用の格子点を生成

for it in range(0, it_max):
    for j in range(0, mesh_max):  # 境界条件(左側と右側)
        OMG[0, j] = -2 * PSI[1, j] * mesh_recip * mesh_recip
        OMG[mesh_max - 1, j] = -2 * PSI[mesh_max - 2, j] \
                                  * mesh_recip * mesh_recip
    for i in range(0, mesh_max):  # 境界条件(下側と上側)
        OMG[i, 0] = -2 * PSI[i, 1] * mesh_recip * mesh_recip
        OMG[i, mesh_max - 1] = -2 * (PSI[i, mesh_max - 2] + delta_mesh) \
                                  * mesh_recip * mesh_recip

    for j in range(1, mesh_max - 1):
        for i in range(1, mesh_max - 1):
            TMP[i, j] = OMG[i, j]
            rhs = (OMG[i + 1, j] + OMG[i - 1, j] +
                   OMG[i, j + 1] + OMG[i, j - 1]) / 4 + (
                    (PSI[i + 1, j] - PSI[i - 1, j]) *
                    (OMG[i, j + 1] - OMG[i, j - 1]) -
                    (PSI[i, j + 1] - PSI[i, j - 1]) *
                    (OMG[i + 1, j] - OMG[i - 1, j])) * reynolds / 16
            OMG[i, j] = OMG[i, j] * (1 - acceleration_coef_psi) + \
                        rhs * acceleration_coef_psi
    vorticity_max_diff1 = 0
    for j in range(1, mesh_max - 1):
        for i in range(1, mesh_max - 1):
            vorticity_diff = abs(PSI[i, j] - TMP[i, j])
            if vorticity_diff >= vorticity_max_diff1:
                vorticity_max_diff1 = vorticity_diff

    for j in range(1, mesh_max - 1):
        for i in range(1, mesh_max - 1):
            vorticity_diff = abs(PSI[i, j] - TMP[i, j])
            TMP[i, j] = PSI[i, j]
            rhs = (PSI[i + 1, j] + PSI[i - 1, j] + \
                   PSI[i, j + 1] + PSI[i, j - 1]) / 4 + \
                  OMG[i, j] * delta_mesh_sq / 4
            PSI[i, j] = PSI[i, j] * (1 - acceleration_coef_omg) + \
                        rhs * acceleration_coef_omg

    vorticity_max_diff2 = 0
    for j in range(1, mesh_max - 1):
        for i in range(1, mesh_max - 1):
            aa = max(1e-8, abs(TMP[i, j]))
            vorticity_diff = abs(PSI[i, j] - TMP[i, j]) / aa
            if vorticity_diff >= vorticity_max_diff2:
                vorticity_max_diff2 = vorticity_diff

    if it % 50 == 0:
        print(it, "error omega = ", vorticity_max_diff1, "error psi = ",
              vorticity_max_diff2)
    v = max(vorticity_max_diff1, vorticity_max_diff2)
    if v <= epsilon:
        break

plt.contourf(Y, X, PSI, alpha=0.5, cmap=cm.viridis)
plt.colorbar()
plt.contour(Y, X, PSI, cmap=cm.viridis)
plt.show()
