import math
import matplotlib.cm as cm
import matplotlib.pyplot as plt
import numpy as np

fig = plt.figure()
mesh_max_x = int(input("格子点数を入力してください (<51)（). (e.g. 20): ")) + 1
mesh_max_y = int(input("格子点数を入力してください (<51). (e.g. 20): ")) + 1
reynolds = int(input("レイノルズ数を入力してください. (e.g. 100): "))
delta_t = float(input("時間間隔Δtを入力してください. (e.g. 0.01): "))
time_max = int(input("計算打ち切りのタイムステップ数を"\
    "入力してください. (e.g. 400): "))
acceleration_coef_poisson = float(input("流れ関数に関するポアソン方程式の"\
    "近似差分方程式をＳＯＲ法で解くための加速係数を入力してください."\
    "(e.g. 1.0)"))
epsilon = float(input("反復法の許容最大誤差（収束判定条件）を"\
    "入力してください. (e.g. 0.00001): "))
bx = float(input("X方向の格子の集中度を指定するパラメータを"\
    "入力してください (<1). (e.g. 0.98): "))
by = float(input("Y方向の格子の集中度を指定するパラメータを"\
    "入力してください (<1). (e.g. 0.98): "))
y_coord_in = int(input("流入口（流入口は(1,y_coord_in)-(1,NY) の間にある）"\
    "を入力してください. (e.g. 17): "))
y_coord_out = int(input("流出口（流出口は(NX,1)-(NX,y_coord_out)の間にある）"\
    "を入力してください. (e.g. 5): "))

PSI = np.zeros((mesh_max_x, mesh_max_y))  # 流れ関数ψを記憶する配列，0で初期化
OMG = np.zeros((mesh_max_x, mesh_max_y))  # 渦度ωを記憶する配列，0で初期化
TMP = np.zeros((mesh_max_x, mesh_max_y))  # 流れ関数や渦度ωを
                                          # 一時的に記憶する配列
x = np.zeros(mesh_max_x + 1)
y = np.zeros(mesh_max_y + 1)
a1 = np.zeros(mesh_max_x)
b1 = np.zeros(mesh_max_x)
c1 = np.zeros(mesh_max_x)
a2 = np.zeros(mesh_max_x)
b2 = np.zeros(mesh_max_x)
c2 = np.zeros(mesh_max_x)
a3 = np.zeros(mesh_max_y)
b3 = np.zeros(mesh_max_y)
c3 = np.zeros(mesh_max_y)
a4 = np.zeros(mesh_max_y)
b4 = np.zeros(mesh_max_y)
c4 = np.zeros(mesh_max_y)

# 格子生成
fa = (math.exp(bx) + 1) / (math.exp(bx) - 1)
fb = (math.exp(by) + 1) / (math.exp(by) - 1)
for i in range(0, mesh_max_x):
    bxa = bx * i / (mesh_max_x - 1)
    x[i] = fa * (math.exp(bxa) - 1) / (math.exp(bxa) + 1)
x00 = 2 * x[0] - x[1]
x[mesh_max_x] = 2 * x[mesh_max_x - 1] - x[mesh_max_x - 2]
for j in range(0, mesh_max_y):
    bya = by * j / (mesh_max_y - 1)
    y[j] = fb * (math.exp(bya) - 1) / (math.exp(bya) + 1)
y00 = 2 * y[0] - y[1]
y[mesh_max_y] = 2 * y[mesh_max_y - 1] - y[mesh_max_y - 2]

# メトリックの計算（1次元）
for i in range(0, mesh_max_x):
    x1 = x[i + 1] - x[i]
    if i > 0:
        x2 = x[i] - x[i - 1]
        x3 = x[i + 1] - x[i - 1]
        x4 = x[i + 1] - 2 * x[i] + x[i - 1]
    else:
        x2 = x[i] - x00
        x3 = x[i + 1] - x00
        x4 = x[i + 1] - 2 * x[i] + x00
    a1[i] = -x1 / (x2 * x3)
    b1[i] = x4 / (x1 * x2)
    c1[i] = x2 / (x1 * x3)
    a2[i] = 2 / (x2 * x3)
    b2[i] = -2 / (x1 * x2)
    c2[i] = 2 / (x1 * x3)

for j in range(0, mesh_max_y):
    y1 = y[j + 1] - y[j]
    if j > 0:
        y2 = y[j] - y[j - 1]
        y3 = y[j + 1] - y[j - 1]
        y4 = y[j + 1] - 2 * y[j] + y[j - 1]
    else:
        y2 = y[j] - y00
        y3 = y[j + 1] - y00
        y4 = y[j + 1] - 2 * y[j] + y00
    a3[j] = -y1 / (y2 * y3)
    b3[j] = y4 / (y1 * y2)
    c3[j] = y2 / (y1 * y3)
    a4[j] = 2 / (y2 * y3)
    b4[j] = -2 / (y1 * y2)
    c4[j] = 2 / (y1 * y3)

ps0 = y[mesh_max_y - 1] - y[y_coord_in - 1]

# 初期化
for i in range(0, mesh_max_x):
    PSI[i, mesh_max_y - 1] = ps0
for j in range(y_coord_out - 1, mesh_max_y):
    PSI[mesh_max_x - 1, j] = ps0

for t in range(0, time_max):
    for j in range(0, mesh_max_y):  # 境界条件（左側と右側）
        OMG[0, j] = (a2[0] * c1[0] / a1[0] - c2[0]) * PSI[1, j]
        OMG[mesh_max_x - 1, j] = (c2[mesh_max_x - 1] * a1[mesh_max_x - 1] /
                                  c1[mesh_max_x - 1] - a2[mesh_max_x - 1]) * \
                                 PSI[mesh_max_x - 2, j] + \
                                 (c2[mesh_max_x - 1] * b1[mesh_max_x - 1] /
                                  c1[mesh_max_x - 1] - b2[mesh_max_x - 1]) * \
                                 ps0
    for j in range(y_coord_in, mesh_max_y):  # 境界条件（左側と右側）
        OMG[0, j] = 0
        PSI[0, j] = (y[j] - y[y_coord_in - 1]) / \
                    (y[mesh_max_y - 1] - y[y_coord_in - 1]) * ps0
    for j in range(0, y_coord_out - 1):  # 境界条件（左側と右側）
        OMG[mesh_max_x - 1, j] = OMG[mesh_max_x - 2, j]
        PSI[mesh_max_x - 1, j] = (y[j] - y[0]) / (y[y_coord_out - 1] - y[0]) * \
                                 ps0
    for i in range(0, mesh_max_x):  # 境界条件（下側と上側）
        OMG[i, 0] = (a4[0] * c3[0] / a3[0] - c4[0]) * PSI[i, 1]
        OMG[i, mesh_max_y - 1] = (c4[mesh_max_y - 1] * a3[mesh_max_y - 1] /
                                  c3[mesh_max_y - 1] - a4[mesh_max_y - 1]) * \
                                 PSI[i, mesh_max_y - 2] + \
                                 (c4[mesh_max_y - 1] * b3[mesh_max_y - 1] /
                                  c3[mesh_max_y - 1] - b4[mesh_max_y - 1]) * \
                                  ps0

    for k in range(0, 100):
        for j in range(1, mesh_max_y - 1):
            for i in range(1, mesh_max_x - 1):
                TMP[i, j] = PSI[i, j]
                rhs = -(a2[i] * PSI[i - 1, j] + c2[i] * PSI[i + 1, j] +
                        a4[j] * PSI[i, j - 1] + c4[j] * PSI[i, j + 1] +
                        OMG[i, j]) / (b2[i] + b4[j]) - PSI[i, j]
                PSI[i, j] = PSI[i, j] + acceleration_coef_poisson * rhs
        err2 = 0
        for j in range(1, mesh_max_y - 1):
            for i in range(1, mesh_max_x - 1):
                bb = abs(PSI[i, j] - TMP[i, j])
                if bb >= err2:
                    err2 = bb
        if err2 < epsilon:
            print(t, k, err2)
            break

    for j in range(1, mesh_max_y - 1):
        for i in range(1, mesh_max_x - 1):
            TMP[i, j] = OMG[i, j]
            rhs = -(a3[j] * PSI[i, j - 1] + b3[j] * PSI[i, j] +
                    c3[j] * PSI[i, j + 1]) * \
                   (a1[i] * OMG[i - 1, j] + b1[i] * OMG[i, j] +
                    c1[i] * OMG[i + 1, j]) + \
                   (a3[j] * OMG[i, j - 1] + b3[j] * OMG[i, j] +
                    c3[j] * OMG[i, j + 1]) * \
                   (a1[i] * PSI[i - 1, j] + b1[i] * PSI[i, j] +
                    c1[i] * PSI[i + 1, j]) + \
                   (a2[i] * OMG[i - 1, j] + b2[i] * OMG[i, j] +
                    c2[i] * OMG[i + 1, j] +
                    a4[j] * OMG[i, j - 1] + b4[j] * OMG[i, j] +
                    c4[j] * OMG[i, j + 1]) / reynolds
            OMG[i, j] = OMG[i, j] + delta_t * rhs

X, Y = np.meshgrid(x[0:mesh_max_x], y[0:mesh_max_y])  # グラフ描画用の
                                                      # 格子点を生成
g = plt.subplot()
g.contourf(Y, X, PSI, alpha=0.5, cmap=cm.viridis)
g.contour(Y, X, PSI, cmap=cm.viridis)
g.set_aspect('equal')
plt.show()
