import math
import matplotlib.cm as cm
import matplotlib.pyplot as plt
import numpy as np

pr = 0.71
fig = plt.figure()
na = int(input("格子点数を入力してください (<51)（). (e.g. 20): "))
nb = int(input("格子点数を入力してください (<51). (e.g. 20): "))
nx = na + 1
ny = nb + 1
re = int(input("レイノルズ数を入力してください. (e.g. 100): "))
dt = float(input("時間間隔Δtを入力してください. (e.g. 0.01): "))
ar = float(input("heat parameterを入力してください. (e.g. 5.0): "))
nmax = int(input("計算打ち切りのタイムステップ数を入力してください. (e.g. 400): "))
const = float(input("流れ関数に関するポアソン方程式の近似差分方程式を"\
    "ＳＯＲ法で解くための加速係数を入力してください. (e.g. 1.0)"))
eps = float(input("反復法の許容最大誤差（収束判定条件）を入力してください."\
    "(e.g. 0.00001): "))
bx = float(input("を入力してください. (e.g. 0.98): "))
by = float(input("を入力してください. (e.g. 0.98): "))
ja = int(input("を入力してください. (e.g. 17): "))
jb = int(input("を入力してください. (e.g. 5): "))

psi = np.zeros((nx, ny))  # 流れ関数ψを記憶する配列，0で初期化
omg = np.zeros((nx, ny))  # 渦度ωを記憶する配列，0で初期化
tmp = np.zeros((nx, ny))  # 温度Tを記憶する配列，0で初期化
t = np.zeros((nx, ny))  # 温度Tを記憶する配列，0で初期化
x = np.zeros(nx + 1)  # 格子点のX座標を記憶する配列，0で初期化
y = np.zeros(ny + 1)  # 格子点のY座標を記憶する配列，0で初期化
a1 = np.zeros(nx)
b1 = np.zeros(nx)
c1 = np.zeros(nx)
a2 = np.zeros(nx)
b2 = np.zeros(nx)
c2 = np.zeros(nx)
a3 = np.zeros(ny)
b3 = np.zeros(ny)
c3 = np.zeros(ny)
a4 = np.zeros(ny)
b4 = np.zeros(ny)
c4 = np.zeros(ny)

# 格子生成
fa = (math.exp(bx) + 1) / (math.exp(bx) - 1)
fb = (math.exp(by) + 1) / (math.exp(by) - 1)
for i in range(0, nx):
    bxa = bx * i / (nx - 1)
    x[i] = fa * (math.exp(bxa) - 1) / (math.exp(bxa) + 1)
x00 = 2 * x[0] - x[1]
x[nx] = 2 * x[nx - 1] - x[nx - 2]
for j in range(0, ny):
    bya = by * j / (ny - 1)
    y[j] = fb * (math.exp(bya) - 1) / (math.exp(bya) + 1)
y00 = 2 * y[0] - y[1]
y[ny] = 2 * y[ny - 1] - y[ny - 2]

for i in range(0, nx):  # メトリックの計算（1次元）
    x1 = x[i + 1] - x[i]
    if i > 0:
        x2 = x[i] - x[i - 1]
        x3 = x[i + 1] - x[i - 1]
        x4 = x[i + 1] - 2 * x[i] + x[i - 1]
    else:
        x2 = x[i] - x00
        x3 = x[i + 1] - x00
        x4 = x[i + 1] - 2 * x[i] + x00
    a1[i] = -x1 / (x2 * x3)
    b1[i] = x4 / (x1 * x2)
    c1[i] = x2 / (x1 * x3)
    a2[i] = 2 / (x2 * x3)
    b2[i] = -2 / (x1 * x2)
    c2[i] = 2 / (x1 * x3)

for j in range(0, ny):
    y1 = y[j + 1] - y[j]
    if j > 0:
        y2 = y[j] - y[j - 1]
        y3 = y[j + 1] - y[j - 1]
        y4 = y[j + 1] - 2 * y[j] + y[j - 1]
    else:
        y2 = y[j] - y00
        y3 = y[j + 1] - y00
        y4 = y[j + 1] - 2 * y[j] + y00
    a3[j] = -y1 / (y2 * y3)
    b3[j] = y4 / (y1 * y2)
    c3[j] = y2 / (y1 * y3)
    a4[j] = 2 / (y2 * y3)
    b4[j] = -2 / (y1 * y2)
    c4[j] = 2 / (y1 * y3)

ps0 = y[ny - 1] - y[ja - 1]

for j in range(0, ny):  # psiとomgの初期化
    for i in range(0, nx):
        psi[i, j] = 0
        omg[i, j] = 0
        t[i, j] = 0
for i in range(0, nx):
    psi[i, ny - 1] = ps0
for j in range(jb - 1, ny):
    psi[nx - 1, j] = ps0

for n in range(0, nmax):
    for j in range(0, ny):  # 境界条件（左と右）
        omg[0, j] = (a2[0] * c1[0] / a1[0] - c2[0]) * psi[1, j]
        omg[nx - 1, j] = (c2[nx - 1] * a1[nx - 1] / c1[nx - 1] - a2[nx - 1]) * \
                         psi[nx - 2, j] + \
                         (c2[nx - 1] * b1[nx - 1] / c1[nx - 1] - b2[nx - 1]) * \
                         ps0
        t[0, j] = t[1, j]
        t[nx - 1, j] = t[nx - 2, j]
    for j in range(ja, ny):
        omg[0, j] = 0
        psi[0, j] = (y[j] - y[ja - 1]) / (y[ny - 1] - y[ja - 1]) * ps0
        t[0, j] = 0.5
    for j in range(0, jb - 1):
        omg[nx - 1, j] = omg[nx - 2, j]
        psi[nx - 1, j] = (y[j] - y[0]) / (y[jb - 1] - y[0]) * ps0
    for i in range(0, nx):  # 境界条件（下と上）
        omg[i, 0] = (a4[0] * c3[0] / a3[0] - c4[0]) * psi[i, 1]
        omg[i, ny - 1] = (c4[ny - 1] * a3[ny - 1] / c3[ny - 1] - a4[ny - 1]) * \
                         psi[i, ny - 2] + \
                         (c4[ny - 1] * b3[ny - 1] / c3[ny - 1] - b4[ny - 1]) * \
                         ps0
        t[i, 1] = 1
        t[i, ny - 1] = 0
    for k in range(0, 100):  # 新しいpsiの計算
        for j in range(1, ny - 1):
            for i in range(1, nx - 1):
                tmp[i, j] = psi[i, j]
                rhs = -(a2[i] * psi[i - 1, j] + c2[i] * psi[i + 1, j] +
                        a4[j] * psi[i, j - 1] + c4[j] * psi[i, j + 1] +
                        omg[i, j]) / (b2[i] + b4[j]) - psi[i, j]
                psi[i, j] = psi[i, j] + const * rhs
        err2 = 0
        for j in range(1, ny - 1):
            for i in range(1, nx - 1):
                bb = abs(psi[i, j] - tmp[i, j])
                if bb >= err2:
                    err2 = bb
        if err2 < eps:
            print(n, k, err2)
            break

    for j in range(1, ny - 1):  # 新しいomgの計算
        for i in range(1, nx - 1):
            tmp[i, j] = omg[i, j]
            rhs = -(a3[j] * psi[i, j - 1] + b3[j] * psi[i, j] +
                    c3[j] * psi[i, j + 1]) * \
                   (a1[i] * omg[i - 1, j] + b1[i] * omg[i, j] +
                    c1[i] * omg[i + 1, j]) + \
                   (a3[j] * omg[i, j - 1] + b3[j] * omg[i, j] +
                    c3[j] * omg[i, j + 1]) * \
                   (a1[i] * psi[i - 1, j] + b1[i] * psi[i, j] +
                    c1[i] * psi[i + 1, j]) + \
                   (a2[i] * omg[i - 1, j] + b2[i] * omg[i, j] +
                    c2[i] * omg[i + 1, j] + a4[j] * omg[i, j - 1] +
                    b4[j] * omg[i, j] + c4[j] * omg[i, j + 1]) / re + \
                   ar * (a1[i] * t[i - 1, j] + b1[i] * t[i, j] +
                         c1[i] * t[i + 1, j])
            omg[i, j] = omg[i, j] + dt * rhs

    for j in range(1, ny - 1):  # 新しい温度の計算
        for i in range(1, nx - 1):
            uu = a3[j] * psi[i, j - 1] + b3[j] * psi[i, j] + \
                 c3[j] * psi[i, j + 1]
            vv = -(a1[i] * psi[i - 1, j] + b1[i] * psi[i, j] +
                   c1[i] * psi[i + 1, j])
            tx = a1[i] * t[i - 1, j] + b1[i] * t[i, j] + c1[i] * t[i + 1, j]
            ty = a3[j] * t[i, j - 1] + b3[j] * t[i, j] + c3[j] * t[i, j + 1]
            tv = (a2[i] * t[i - 1, j] + b2[i] * t[i, j] +
                  c2[i] * t[i + 1, j] + a4[j] * t[i, j - 1] +
                  b4[j] * t[i, j] + c4[j] * t[i, j + 1]) / (re * pr)
            t[i, j] = t[i, j] + dt * (-uu * tx - vv * ty + tv)

X, Y = np.meshgrid(x[0:nx], y[0:ny])  # グラフ描画用の格子点を生成
g = plt.subplot()
g.contourf(Y, X, psi, alpha=0.5, cmap=cm.viridis)
g.contour(Y, X, psi, cmap=cm.viridis)
g.set_aspect('equal')
plt.show()
