def first_order_differential_equation_right(n, m):
    return 0.5 * (1 + n) * m * m


h = float(input("格子幅（Ｘ方向の刻み幅）を入力してください. (e.g. 0.01): "))
max_x = float(input("max_xを入力してください. xがmax_xになるまで計算を続けます."\
    "(e.g. 1): "))
x = 0
y = 1
print(' ' * 5 + "x", ' ' * 7 + "approx", ' ' * 9 + "exact", ' ' * 9 + "error")
while x <= max_x:
    y_exact = 4 / (4 - 2 * x - x * x)  # 厳密解
    err_diff = (y_exact - y) / y_exact * 100  # 厳密解との誤差(％)
    print("{:7.2f}".format(x),
          "{:14.7f}".format(y), "{:14.7f}".format(y_exact),\
          "{:14.7f}".format(err_diff))

    k1 = h * first_order_differential_equation_right(x, y)
    k2 = h * first_order_differential_equation_right(x + h / 2, y + k1 / 2)
    k3 = h * first_order_differential_equation_right(x + h / 2, y + k2 / 2)
    k4 = h * first_order_differential_equation_right(x + h, y + k3)
    y = y + (k1 + 2 * k2 + 2 * k3 + k4) / 6
    x = x + h