import matplotlib.pyplot as plt
import numpy as np

delta_x = 0.01
delta_t = 0.001
E = np.zeros((100, 3))
EE = np.zeros((100, 3))
U = np.zeros((100, 3))
UU = np.zeros((100, 3))
Y = np.zeros((7, 100))
for i in range(0, 50):
    U[i, 0] = 1
    U[i, 1] = 0
    U[i, 2] = 2.5
for i in range(50, 100):
    U[i, 0] = 0.5
    U[i, 1] = 0
    U[i, 2] = 1.25

nn = 301
for n in range(0, nn):
    if n - (n // 50) * 50 == 1:
        ii = n // 50 + 1
        for i in range(0, 100):
            Y[ii, i] = U[i, 0]

    for j in range(0, 3):
        U[0, j] = U[1, j]
        U[99, j] = U[98, j]

    for i in range(0, 100):
        E[i, 0] = U[i, 1]
        P = (1.4 - 1) * (U[i, 2] - U[i, 1] ** 2 / (2 * U[i, 0]))
        E[i, 1] = U[i, 1] ** 2 / U[i, 0] + P
        E[i, 2] = U[i, 1] * (U[i, 2] + P) / U[i, 0]

    for j in range(0, 3):
        for i in range(0, 99):
            UU[i, j] = U[i, j] - delta_t / delta_x * (E[i + 1, j] - E[i, j])

    for j in range(0, 3):
        UU[0, j] = UU[1, j]
        UU[99, j] = UU[98, j]

    for i in range(0, 100):
        EE[i, 0] = UU[i, 1]
        P = (1.4 - 1) * (UU[i, 2] - UU[i, 1] ** 2 / (2 * UU[i, 0]))
        EE[i, 1] = UU[i, 1] ** 2 / UU[i, 0] + P
        EE[i, 2] = UU[i, 1] * (UU[i, 2] + P) / UU[i, 0]

    for j in range(0, 3):
        for i in range(1, 100):
            UUU = UU[i, j] - delta_t / delta_x * (EE[i, j] - EE[i - 1, j])
            U[i, j] = 0.5 * (U[i, j] + UUU)

for j in range(0, 100):
    Y[0, j] = delta_x * j

fig = plt.figure()
plt.plot(Y[0], Y[1], Y[0], Y[2], Y[0], Y[3], Y[0], Y[4], Y[0], Y[5], Y[0], Y[6])
plt.show()
