import math
import matplotlib.animation as animation
import matplotlib.pyplot as plt
import numpy as np

mesh_max = int(input("格子数を入力してください (<51). (e.g. 20): ")) + 1
time_max = int(input("計算打ち切りのタイムステップ数を入力してください."\
                    "(e.g. 1000): "))
r = 2
while r > 1:
    delta_t = float(input("時間間隔Δtを入力してください. (e.g. 0.001): "))
    delta_x = 1 / (mesh_max - 1)
    r = delta_t / (delta_x ** 2)

fig = plt.figure()
graphs = []  # アニメーション化する際に必要となるグラフを保存する配列
U = np.zeros(mesh_max)  # 現時点での解を記憶する配列
UU = np.zeros(mesh_max)  # 1つ後の時間ステップでの解を記憶する配列
V = np.zeros(mesh_max)  # 1つ前の時間ステップでの解を記憶する配列

for i in range(0, mesh_max):  # 初期化
    X = i / (mesh_max - 1)
    U[i] = 0.25 * math.sin(math.pi * X)
    V[i] = 0.25 * math.sin(math.pi * X)

for t in range(0, time_max):  # 1次元波動方程式を陽解法を用いて解く
    if t % 10 == 0:  # 10ステップに1回，アニメーション化する際に
                     # 必要となるグラフを記録
        graph = plt.plot(U, color="red")
        graphs.append(graph)

    U[0] = 0.0  # 境界条件(左側)
    U[mesh_max - 1] = 0.0  # 境界条件(右側)

    for i in range(1, mesh_max - 1):  # オイラー陽解法によって
                                      # 1つの時間ステップ進める
        UU[i] = r * r * (U[i - 1] - 2 * U[i] + U[i + 1]) + 2 * U[i] - V[i]

    for i in range(1, mesh_max - 1):
        V[i] = U[i]  # UをVにコピーして現時点のUを保持
        U[i] = UU[i]  # UUをUにコピーしてUを1つの時間ステップ進める

graph = plt.plot(U, color="red")
graphs.append(graph)
animated_result = animation.ArtistAnimation(fig, graphs)
plt.show()