% main10_1a.m
%%---------------------------------
%%   closed loop identification
%%   Example 10.1  
%%   Model of closed loop system: Figure 10.3
%%   
%%   
%%---------------------------------
close all
clear
Number=20;          %% Number of simulations
N = 2000;           %% # of data
k = 15;             %% denotes # of block rows
kk=k*2;             %% 
nc=1;               %% dim(controller)
np=2;               %% dim(plant)
n=3;                %% dim(plant)+dim(controller)
p=1;                %% dim(y), output of the plant 
m=1;                %% dim(u), input to the plant
%f=[10^(-2):pi/512:pi];
t=0:0.01:2*pi;
f = linspace(0,pi,511);
%% var(r1)=1; var(r2)=0.2
%%---------------------------------
%%    System
%%---------------------------------
nump=[0,1,0];         %% plant
denp=[1,-1.6,0.89];
numc=[1,-0.8];        %% controller 
denc=[1,0.0];
numh=[1,-1.56,1.045,-0.3338];        %% mCYtB^
denh=[1,-2.35,2.09,-0.6675];
[AP,BP,CP,DP]=tf2ss(nump,denp);
[AC,BC,CC,DC]=tf2ss(numc,denc);
[AH,BH,CH,DH]=tf2ss(numh,denh);
%%----------------------------------- 
Ac=[AP-BP*DC*CP -BP*CC;  BC*CP AC ]; %%  [v
figure(1)                     
a=plot(real(eig(Ac)),imag(eig(Ac)),'r+');
set(a,'markersize',36)
hold on 
plot(sin(t),cos(t),'-')
axis('square')
axis([-1 1 -1 1])
grid
%%-----------------------------------
[z,p] = ss2tf(AP,BP,CP,DP,1);
h = freqz(z,p,f);
figure(2)                            %% vg̃QC}
plot(f,20*log10(abs(h)),'r-');
axis([0,3.14159,-20,30]);
grid
set(gca,'FontName','times','FontSize',20);
hold on
%%-------------------------------------
[z,p] = ss2tf(AC,BC,CC,DC,1);
h = freqz(z,p,f);
figure(3)                            %% Rg[̃QC} 
plot(f,20*log10(abs(h)),'r-');
axis([0,3.14159,-20,30]);
grid
set(gca,'FontName','times','FontSize',20);
hold on
%%-------------------------------------
figure(5)                      %% vg̋
a=plot(real(eig(AP)),imag(eig(AP)),'r+');
set(a,'markersize',36)
hold on 
plot(sin(t),cos(t),'-')
axis('square')
axis([-1 1 -1 1])
grid
%%------------------------------------
figure(5)                      %% Rg[̋
a=plot(real(eig(AC)),imag(eig(AC)),'rx');
set(a,'markersize',36)
hold on 
%%
randn('state',0)   %  the same random numbers are generated
%%----------------------------------------
%%       System Identification
%%----------------------------------------
hp=zeros(1,511);
hc=zeros(1,511);
%%
for l=1:Number
iteration=l
%%----------------------------------------
%%      Data Generation
%%----------------------------------------
e=randn(1,N+kk)/3;
r2=randn(1,N+kk)*sqrt(0.2);
%%  generation of composit sinusoid
tt = linspace(1,N+kk,N+kk);   
MM = 30;
Ai = randn(1,MM)+ones(1,MM);  % average 1, variance 1
wi = pi*rand(MM,1);      
phi= pi*rand(MM,1);
r1 = Ai*sin(wi*tt+phi*ones(1,N+kk));
r1 = r1*sqrt(1)/sqrt(cov(r1));   % composite sinusoids with variance 1
r1=randn(1,N+kk)*sqrt(1);  % white noise
et=randn(1,N+kk)/10;
%%----------------------------------------
x_p=zeros(2,1);
x_c=zeros(1,1);
x_h=zeros(3,1);

for i=1:N+kk
  s(i) = CH*x_h+DH*e(i);
  y(i) = CP*x_p+s(i);
  u(i) = r2(i)+CC*x_c+DC*(r1(i)-y(i))+et(i);
  x_p  = AP*x_p+BP*u(i);
  x_c  = AC*x_c+BC*(r1(i)-y(i));
  x_h  = AH*x_h+BH*e(i);
end
e  = e(1:N+kk);
u  = u(1:N+kk);
r1 = r1(1:N+kk);
r2 = r2(1:N+kk);
y  = y(1:N+kk);
w  = [y  ;  u];
r  = [r1 ; r2];
%%--------------------------------------------
%%  ORT
%%--------------------------------------------
%% Orthogonal projection method 
%% (Picci, Katayama 2003; revised March 2004)
[Ad,Bd,Cd,Dd]=ort_pk2(w,r,n,k);  % dimension n is given

%%--------------------------------------------
%%  CCA
%%--------------------------------------------
%% Canonical correlation analysis (Katayama, Picci 1999; cov-a)
%[Ad,Bd,Cd,Dd,K]=cca(w,r,6,k);
%%-------------------------------------------
figure(1)
hold on 
plot(real(eig(Ad)), imag(eig(Ad)),'*')
%%-------------------------------------------
A_hat=Ad-Bd(:,2)*inv(Dd(2,2))*Cd(2,:);
%% plant 
Ap=A_hat; 
Bp=Bd(:,2)*inv(Dd(2,2));
Cp=Cd(1,:);
Dp=0;
%% controller
Ac=A_hat;    
Bc=Bd(:,1)-Bd(:,2)*inv(Dd(2,2))*Dd(2,1);
Cc=inv(Dd(2,2))*Cd(2,:);
Dc=inv(Dd(2,2))*Dd(2,1);
%%----------------------------------------
%%        Model reduction (balanced)
%%----------------------------------------
[Ap,Bp,Cp,Sigp]=reduction(Ap,Bp,Cp,2);
[Ac,Bc,Cc,Sigc]=reduction(Ac,Bc,Cc,1);
%%----------------------------------------
%%        Plots of results 
%%----------------------------------------
[z,p] = ss2tf(Ap,Bp,Cp,Dp,1);
hp=freqz(z,p,f);
[z,p] = ss2tf(Ac,Bc,Cc,Dc,1);
hc=freqz(z,p,f);
%%----------------------------------------
figure(2)
plot(f,20*log10(abs(hp)),'--');
hold on
figure(3)
plot(f,20*log10(abs(hc)),'--');
hold on
figure(5)
hold on
plot(real(eig(Ap)),imag(eig(Ap)),'*')
figure(5)
hold on
plot(real(eig(Ac)),imag(eig(Ac)),'*')

end



epsform(1,'Real Part','Imaginary Part',[14 14],20,16,[2 1.5 1 1],'',[])
epsform(2,'Frequency [rad/sec]','Gain [dB]',[16 12],20,16,[2 1.5 1 1],'',[])
epsform(3,'Frequency [rad/sec]','Gain [dB]',[16 12],20,16,[2 1.5 1 1],'',[])
%epsform(4,'Frequency [rad/sec]','Gain [dB]',[16 12],18,14,[2 1.5 1 1],'',[])
epsform(5,'Real Part','Imaginary Part',[14 14],20,16,[2 1.5 1 1],'',[])

