%%   main10_2.m 
%%   direct method closed loop identification
%%   computes the results shown in Figs. 10.7(a),(b)  
%%   November 9, 2003; March 25, 2004
close all
clear
Number=10;
N = 2000;           %% # of data
kk = 30;             %% data size
n=2;                %% dim(plant)
nc=1;               %% dim(controller)
m=1;                %% dim(output) 
p=1;                %% dim(inout)
t=0:0.01:2*pi;
f = linspace(0,pi,511);
%% var(r1)=1; var(r2)=0.2
%%---------------------------------
%%    System
%%---------------------------------
nump=[0,1,0];         %% plant
denp=[1,-1.6,0.89];
numc=[1,-0.8];%numc=[0.6,-0.64];
denc=[1,0.0];
numh=[1,-1.56,1.045,-0.3338];
denh=[1,-2.35,2.09,-0.6675];
[AP,BP,CP,DP]=tf2ss(nump,denp);
[AC,BC,CC,DC]=tf2ss(numc,denc);
[AH,BH,CH,DH]=tf2ss(numh,denh);


[z,p] = ss2tf(AP,BP,CP,DP,1);
h = freqz(z,p,f);
figure(2)                      %% Bode plot of plant
plot(f,20*log10(abs(h)),'r-');
axis([0,3.14159,-20,30]);
grid
set(gca,'FontName','times','FontSize',20);
hold on


figure(5)                      %% poles of plant
a=plot(real(eig(AP)),imag(eig(AP)),'r+');
set(a,'markersize',36)
hold on 
plot(sin(t),cos(t),'-')
axis('square')
axis([-1 1 -1 1])



% randn('state',0)   %  the same random numbers are generated
%%----------------------------------------
%%       System Identification
%%----------------------------------------

hp=zeros(1,511);
hc=zeros(1,511);

for l=1:Number
iteration=l

%%-----------------------------
%%      Data
%%-----------------------------
e=randn(1,N+kk)/3;
%r1=randn(1,N+kk)*sqrt(1);
r2=randn(1,N+kk)*sqrt(0.2);


tt = linspace(1,N+kk,N+kk);   
MM = 30;
Ai = randn(1,MM)+ones(1,MM);  % average 1, variance 1
wi = pi*rand(MM,1);      
phi= pi*rand(MM,1);
r1 = Ai*sin(wi*tt+phi*ones(1,N+kk));
r1 = r1*sqrt(1)/sqrt(cov(r1));  %% composite sinusoid
%r1=randn(1,N+kk)*sqrt(1);  %% white noise

x_p=zeros(2,1);
x_c=zeros(1,1);
x_h=zeros(3,1);

for i=1:N+kk,
  s(i) = CH*x_h+DH*e(i);
  y(i) = CP*x_p+s(i);
  u(i) = r2(i)+CC*x_c+DC*(r1(i)-y(i));
  x_p  = AP*x_p+BP*u(i);
  x_c  = AC*x_c+BC*(r1(i)-y(i));
  x_h  = AH*x_h+BH*e(i);
end
e  = e(1:N+kk);
u  = u(1:N+kk);
r1 = r1(1:N+kk);
r2 = r2(1:N+kk);
y  = y(1:N+kk);

% Orthogonal projection method (Picci, Katayama 2003; 2004)
%[Ad,Bd,Cd,Dd]=ort_pk2(y,u,2,15);


% Canonical correlation analysis (Katayama, Picci 1999; cov-a)
[Ad,Bd,Cd,Dd,K]=cca(y,u,2,15);

[z,p] = ss2tf(Ad,Bd,Cd,Dd,1);
hp=freqz(z,p,f);

figure(2)
plot(f,20*log10(abs(hp)),'--');
grid
hold on


figure(5)
hold on
plot(real(eig(Ad)),imag(eig(Ad)),'*')
end
grid
%%------------------------------------------------------------
epsform(2,'Frequency [rad/sec]','Gain [dB]',[16 12],20,16,[2 1.5 1 1],'',[])
epsform(5,'Real Part','Imaginary Part',[14 14],20,16,[2 1.5 1 1],'',[])

