function [A,B,C,D] = ort_pk2(y,u,n,k);
% ORT % Orthogonal Decomposition
% by Picci and Katayama
% November 9, 2003; revised March 25, 2004
%
% N.B: This program computes the deterministic part only.
%
% y= output of the plant
% u= input of the plant
% n=dim(x)
% k=number of block rows

[p,Ndat]=size(y);
[m,Ndat]=size(u);
N=Ndat-2*k;
km=k*m;
kp=k*p;
% Data Matrices
Up = []; Uf = [];
Yp = []; Yf = [];
for j = 1:k
 Up = [Up;u(:,j:N+j-1)];
 Yp = [Yp;y(:,j:N+j-1)];
end
for j = k+1:2*k,
 Uf = [Uf;u(:,j:N+j-1)];
 Yf = [Yf;y(:,j:N+j-1)];
end

H=[Uf; Up; Yp; Yf]; % (8.54)
% LQ decomposition
[Q,L]=qr(H',0);
Q=Q';
L=L';
L11 = L(1:km,1:km);
L41 = L(2*km+kp+1:2*km+2*kp,1:km);
L42 = L(2*km+kp+1:2*km+2*kp,km+1:2*km);
%L43 = L(2*km+kp+1:2*km+2*kp,2*km+1:2*km+kp);
[UU,SS,VV] = svd(L42);
%------------------------------------
% Computation of C and A
U1 = UU(:,1:n);
Ok = U1*sqrtm(SS(1:n,1:n));
C = Ok(1:p,1:n);
A = pinv(Ok(1:p*(k-1),1:n))*Ok(p+1:k*p,1:n);
%------------------------------------
% Computation of B and D
U2 = UU(:,n+1:size(UU',1));
Xi = U2'*L41/L11;
XX = [];
RR = [];
%
for j = 1:k 
 XX = [XX;Xi(:,m*(j-1)+1:m*j)];
 Okj = Ok(1:p*(k-j),:);
 Rj = [zeros(p*(j-1),p),zeros(p*(j-1),n);
       eye(p), zeros(p,n);
       zeros(p*(k-j),p),Okj];
 RR = [RR;U2'*Rj];
end;
DB = pinv(RR)*XX;
D = DB(1:p,:);
B = DB(p+1:size(DB,1),:);
%
%% end of ort_pk2.m

disp('ORT')







