% function [B,D]=BD_ls(A,C,Gamma,K,L,m,delay);
%
% Estimates matrices B,D orthonormalizing the equations of N4SID.
%
% Gamma : the estimated Obsevability matrix
% (A,C) :  the estimated (A,C) pair
%  K   : a matrix coming from the orthonormalized LS step in N4SID
%  L  : the L factor of the LQ dec.  in the orthonormalization step
%  m    : number of inputs;
%
%  delay : is an 1 x m  row vector, delay(i) is set to 1 force  delay from the
%        i-th input; Dd(:,i) = 0.
%    default : delay = zeros(1,m); 
%
%
% Written by A. Chiuso
% 2/09/2000

function [B,D]=BD_ls(A,C,Gamma,K,L,m,delay);

if ((nargin > 7)| (nargin < 6))
   disp('Wrong number of input arguments');
   return 
end;



if nargin == 6
   delay = zeros(1,m);
end;

if length(delay) ~= m 
   disp('delay must have m entries')
   return
end;

% check dimensions of input matrices.

[ra ca] = size(A);
[rc cc] = size(C);
[rg cg] = size(Gamma);


if ca ~=ra
   disp('A must be square')
   return
end;


if ((ca ~=cc)|(ca ~=cg))
   disp('A , C and Gamma must have the same number of columns')
   return
end;


[rk ck]=size(K);

n=ra;
p=rc;
k = rg/p;


U1 = Gamma;
U2 = U1(1:p*(k-1),:);
U2T=pinv(U2);
U1T=pinv(U1);
G1 = U1T(:,1:p); G2 = U1T(:,p+1:p*k);
TT = [eye(n)-A*G2*U2   -A*G1 ;  -C*G2*U2  eye(p)-C*G1];
U2T=pinv(U2);
U1T=pinv(U1);
for kk=1:k-1,
   Temp =[ U2T(:,p*kk+1:p*(k-1))*U1(1:p*(k-1-kk),:)-A*U1T(:,p*(kk+1)+1:p*k)*U1(1:p*(k-1-kk),:) U2T(:,p*(kk-1)+1:p*kk)-A*U1T(:,p*kk+1:p*(kk+1)); -C*U1T(:,p*(kk+1)+1:p*k)*U1(1:p*(k-1-kk),:)  -C*U1T(:,p*kk+1:p*(kk+1))];
   TT =[TT Temp];
end;

[rrr rr]=size(L);
KK=zeros((p+n)*rr,(p+n)*m);

 for jj = 1:p+n,
    for kk=1:k, 
       
    KK((jj-1)*rr+1:jj*rr,:)=KK((jj-1)*rr+1:jj*rr,:)+kron(L(m*(kk-1)+1:kk*m,:)',TT(jj,(p+n)*(kk-1)+1:(p+n)*kk));
   end;
 end;


 K = K';
 d=n+p;
 ZZ = K(:);
 
 I = find(delay>0); % find inputs which have to be delayed
 
 if ~isempty(I)
    KK0=[];       
    prev=0;
    for i=1:length(I),
       t=I(i);
       KK0 = [KK0 KK(:,prev*(n+p)+1:(t-1)*(n+p)+n)];
       prev = t;
    end;
    if prev < m
     KK0 = [KK0 KK(:,prev*(n+p)+1:m*(n+p))];
    end
 
   
    KK =KK0;
   
    BD = KK\ZZ;
    prev=0;
    D=zeros(p,m);
    for i=1:length(I),
       t=I(i);
       for j = prev+1:t-1,
         B(:,j)=BD((j-1)*n+(j-i)*p+1:(j-1)*n+(j-i)*p+n);
         D(:,j)=BD(j*n+(j-i)*p+1:j*n+(j-i+1)*p);
       end;
       B(:,t)=BD((t-1)*n+(t-i)*p+1:(t-1)*n+(t-i)*p+n);
       prev = t;
    end;
    if prev <m 
      for j = prev+1:m,
          B(:,j)=BD((j-1)*n+(j-i-1)*p+1:(j-1)*n+(j-i-1)*p+n);
          D(:,j)=BD(j*n+(j-i-1)*p+1:j*n+(j-i)*p);
      end;
   end;
 else
    BD = KK\ZZ;
    for t=1:m,
     B(:,t)=BD((t-1)*(n+p)+1:(t-1)*(n+p)+n);
     D(:,t)=BD((t-1)*(n+p)+n+1:t*(n+p));
    end;   
 end;
 


 
 
