% function [Bd,Dd,xO]=BD_msm_block(Ad,Cd,yd,u,T,N,delay);
%
% Estimates matrices B,D and sequence of initial states x0 using a 
% minimum simulation error method.
%
% (Ad,Cd): is the estimated (A,C) pair of the deterministic subsystem
%
%  u:  input  data organized as row vectors 
%            [u(0) u(1) .....u(Ndat-1)].
%  yd : projected output data, vectorization of the matrix Ydhat
%  [yd(1,1); yd(2,1) ;yd(3,1);....;yd(T,1) ;yd(1,2); yd(2,2);....yd(T,2);.......]
%
%  T: number of rows
%  N: number of columns used, default: N=5.
%
%  delay : is an 1 x m  row vector, delay(i) is set to 1 force  delay from the
%        i-th input; Dd(:,i) = 0.
%    default : delay = zeros(1,m); 
%
%
%
% Written by A. Chiuso
% 1/31/2000


function [Bd,Dd,x0]=BD_msm_block(Ad,Cd,yd,u,T,N,delay);



if ((nargin > 7)| (nargin < 4))
   disp('Wrong number of input arguments');
   return 
end;

[m Ndat]=size(u);
[p Ndat]=size(yd);

if ((nargin ==6) & N(1) >1)
   delay = zeros(1,m);
   elseif (nargin==6)
      delay = N;
      N = 5;      
end;

if nargin == 5 
   delay = zeros(1,m);
   N = 200;
end;

if length(delay) ~= m 
   disp('delay must have m entries')
   return
end;

% check dimensions of input matrices.

[rad cad] = size(Ad);
[rcd ccd] = size(Cd);


if cad ~=rad
   disp('Ad must be square')
   return
end;


if cad ~=ccd
   disp('Ad and Cd must have the same number of columns')
   return
end;

n = cad;


p=p/(N*T);
if (p ~=rcd)
   disp('The number of rows of Cd must be equal to the number of outputs')
   return
end;


% construct the matrix Mt

M=[];
M1 =[Cd; Cd*Ad];
ND = find(delay==0);
   
for j = 1:N,
  M2(:,:,j) = kron(u(ND,j:j+T-1)',eye(p));
  MM3(:,:,j) = kron(u(:,j),Cd);
end;


for i = 1:m,
      M3(p+1:2*p,(i-1)*n+1:i*n,:) = MM3((i-1)*p+1:i*p,:,:);
end;   

for t = 2:T-1,
   M1=[Cd;M1*Ad];
   for j =1:N,
     MM3(:,:,j) = squeeze(MM3(:,:,j))*Ad + kron(u(:,t+j-1),Cd);   
   end;  
   for i = 1:m,
      M3(t*p+1:(t+1)*p,(i-1)*n+1:i*n,:) = MM3((i-1)*p+1:i*p,:,:);
   end;   
end;
if delay
   for j = 1:N,
     M = [M ; zeros(T*p,(j-1)*n) M1 zeros(T*p,(N-j)*n)   squeeze(M3(:,:,j))];
   end;
else
   for j = 1:N,
     M = [M ; zeros(T*p,(j-1)*n) M1 zeros(T*p,(N-j)*n)  squeeze(M2(:,:,j)) squeeze(M3(:,:,j))];
   end;
end;

theta=M\yd;
nn=n*N;

x0=theta(1:nn);

I = find(delay);
if ~isempty(I)  % there are input delayed inputs
   non_del = length(ND);
   for t=1:m,
    Bd(:,t)=theta(non_del*p+nn+(t-1)*n+1:non_del*p+nn+t*n); 
   end;   
   Dd = zeros(p,m);
   for t=1:non_del,
      Dd(:,ND(t))=theta(nn+(t-1)*p+1:nn+t*p);
   end;
else
   for t=1:m,
      Dd(:,t)=theta(nn+(t-1)*p+1:nn+t*p);
      Bd(:,t)=theta(nn+m*p+(t-1)*n+1:nn+m*p+t*n);
   end;   
end;











