% function [B,D]=BD_proj(Gamma,Phi,k,delay);
%
% Estimates matrices B,D  using the projection approach.
%
% Gamma  is the estimated observability matrix
%
% k : number of block rows
%
%  delay : is an 1 x m  row vector, delay(i) is set to 1 force  delay from the
%        i-th input; Dd(:,i) = 0.
%    default : delay = zeros(1,m); 
%
%
%
% Written by A. Chiuso
% 1/31/2000


function [B,D]=BD_proj(Gamma,Phi,k,delay);



if ((nargin > 4)| (nargin < 3))
   disp('Wrong number of input arguments');
   return 
end;


% check dimensions of input matrices.

[rg cg] = size(Gamma);
[rph cph] = size(Phi);


if rg ~=rph
   disp('Gamma and Phi must have the same number of rows')
   return
end;


p = rg/k;   % numer of outputs
m = cph/k;  % number of inputs
n = cg;     % state dimension

if nargin == 3 
   delay = zeros(1,m);
end;
if length(delay) ~= m 
   disp('delay must have m entries')
   return
end;

[U S V] = svd(Gamma);
Gperp = U(:,n+1:rg)'; % columns are orthogonal to column span of Gamma
Hbar = Gperp*Phi;   

pp=rg-n; % number of rows of Gperp


% construct the matrix K

for i=0:k-2,
   K(i*pp+1:(i+1)*pp,:) = [Gperp(:,i*p+1:(i+1)*p) Gperp(:,(i+1)*p+1:k*p)*Gamma(1:(k-1-i)*p,:)];
   HH(i*pp+1:(i+1)*pp,:) = Hbar(:,i*1+1:(i+1)*m);   
end;
K((k-1)*pp+1:k*pp,:) = [Gperp(:,(k-1)*p+1:k*p) zeros(pp,n)];
HH((k-1)*pp+1:k*pp,:) = Hbar(:,(k-1)*m+1:k*m);

ND = find(delay==0);

if ~isempty(find(delay))
   K(ND,1:p)=zeros(length(ND),p); 
   theta = K\HH;
   D=theta(1:p,:);
   B=theta(p+1:p+n,:);
   D(:,ND)=zeros(p,length(ND));
else
   theta = K\HH;
   D=theta(1:p,:);
   B=theta(p+1:p+n,:);
end;






