% function [B,D]=BD_proj_ls(Gamma,Phi,L,k,delay);
%
% Estimates matrices B,D  using the projection approach.
% with orthonormalization
% Gamma  is the estimated observability matrix
%
% k : number of block rows
%
%  L  : the L factor of the LQ dec.  in the orthonormalization step
%
%  delay : is an 1 x m  row vector, delay(i) is set to 1 force  delay from the
%        i-th input; Dd(:,i) = 0.
%    default : delay = zeros(1,m); 
%
%
%
% Written by A. Chiuso
% 2/09/2000



function [B,D]=BD_proj_ls(Gamma,Phi,L,k,delay);



if ((nargin > 5)| (nargin < 4))
   disp('Wrong number of input arguments');
   return 
end;


if nargin == 4 
   delay = zeros(1,m);
end;


% check dimensions of input matrices.

[rg cg] = size(Gamma);
[rph cph] = size(Phi);

[ru rr] = size(L);





if rg ~=rph
   disp('Gamma and Phi must have the same number of rows')
   return
end;


p = round(rg/k);   % numer of outputs
m = round(cph/k);  % number of inputs
n = cg;     % state dimension

if length(delay) ~= m 
   disp('delay must have m entries')
   return
end;

[U S V] = svd(Gamma);
Gperp = U(:,n+1:rg)'; % rows are orthogonal to column span of Gamma
Hbar = Gperp*Phi;   

pp=rg-n; % number of rows of Gperp
ppp = n+p;

% construct the matrix K
K=[];
for i=0:k-2,
   K = [K Gperp(:,(i+1)*p+1:k*p)*Gamma(1:(k-1-i)*p,:) Gperp(:,i*p+1:(i+1)*p)];
end;

K= [K zeros(pp,n) Gperp(:,(k-1)*p+1:k*p)];

[rk ck] = size(K);

KK=zeros(rk*rr,(p+n)*m);

 for jj = 1:rk,
   
   for kk=1:k,
    KK((jj-1)*rr+1:jj*rr,:)=KK((jj-1)*rr+1:jj*rr,:)+kron(L(m*(kk-1)+1:kk*m,:)',K(jj,(p+n)*(kk-1)+1:(p+n)*kk));
   end;
 end;
 
 
 Hbar =Hbar';
 ZZ = Hbar(:);
 
 
 I = find(delay); % find inputs which have to be delayed
 
 if ~isempty(I)
    KK0=[];       
    prev=0;
    for i=1:length(I),
       t=I(i);
       KK0 = [KK0 KK(:,prev*(n+p)+1:(t-1)*(n+p)+n)];
       prev = t;
    end;
    if prev < m
     KK0 = [KK0 KK(:,prev*(n+p)+1:m*(n+p))];
    end
 
   
    KK =KK0;
   
    BD = KK\ZZ;
    prev=0;
    D=zeros(p,m);
    for i=1:length(I),
       t=I(i);
       for j = prev+1:t-1,
         B(:,j)=BD((j-1)*n+(j-i)*p+1:(j-1)*n+(j-i)*p+n);
         D(:,j)=BD(j*n+(j-i)*p+1:j*n+(j-i+1)*p);
       end;
       B(:,t)=BD((t-1)*n+(t-i)*p+1:(t-1)*n+(t-i)*p+n);
       prev = t;
    end;
    if prev <m 
      for j = prev+1:m,
           B(:,j)=BD((j-1)*n+(j-i-1)*p+1:(j-1)*n+(j-i-1)*p+n);
           D(:,j)=BD(j*n+(j-i-1)*p+1:j*n+(j-i)*p); 
      end;
   end;
   

 else
    BD = KK\ZZ;
    for t=1:m,
     B(:,t)=BD((t-1)*(n+p)+1:(t-1)*(n+p)+n);
     D(:,t)=BD((t-1)*(n+p)+n+1:t*(n+p));
    end;   
 end;
 


 
 
 
 
 
 












