% function H=Hankel(y,k,N);
% 
% construct Block Hankel matrix from data y
% y is a p x Ndat matrix 
% k = number of block rows of Hankel matrix
% N = number of columns of Hankel matrix
%
% 1/31/2000
% Written by A. Chiuso
 
function H=Hankel(y,k,N);

% check dimensions

[p Ndat] = size(y);

if Ndat < k+N-1
  disp('Too few data points')
  return
end;

for i=1:k,
 H((i-1)*p+1:i*p,:)=y(:,i:i+N-1);
end;
H=H/sqrt(N);
