function [Ar,Br,Cr]=anti_red(A,B,C,n);

[K,S,E]=dlqr(A,B,C'*C,1);
A_bar=A-B*K;
b=(1+B'*S*B)^(-1/2);
B_bar=B*b;
Pc=dlyap(A_bar,B_bar*B_bar');
Q=dlyap(A_bar',[C ; K]'*[C ; K]);
[V1,D,U1]=svd(Q);
Q1=sqrt(D)*V1';
P=Q1*Pc*Q1';
[V2,Sig,U2]=svd(P);
T=(inv(sqrt(sqrt(Sig))))*U2'*Q1;
A_bar=T*A_bar*inv(T);
B_bar=T*B_bar;
C_bar=C*inv(T);
K_bar = K*inv(T);
%P = dlyap(A_bar,B_bar*B_bar');
%Q = dlyap(A_bar',[C_bar; K_bar]'*[C_bar ; K_bar]);

A_bar= A_bar(1:n,1:n);
Br= B_bar(1:n)/b;
Cr= C_bar(1:n);
K = K_bar(1:n);

Ar=A_bar+Br*K;