function [Ar,Br,Cr,Sig]=btared(A,B,C,n);

p=max(abs(eig(A)))

if  p >= 1;
A=A/1.2;
C=C/1.2;
end

P=dlyap(A,B*B');
Q=dlyap(A',C'*C);
S=chol(P);
R=chol(Q);
[U,Sig,V]=svd(S*R');
L=Sig(1:n,1:n)^(-1/2)*V(:,1:n)'*R;
T=S'*U(:,1:n)*Sig(1:n,1:n)^(-1/2);
Ar=L*A*T;
Br=L*B;
Cr=C*T;

if p>=1;
Ar=Ar*1.2;
Cr=Cr*1.2;
end
