% cca_s.m
% function [A,C,K,Lambda]=cca_s(y,n,k)
%
% --< References >--
%   [1] T.Katayama and G.Picci,
%        "Realization of stochastic systems with exogenous inputs
%                 and subspace identification methods"
%   [2] H.Kawauchi, A.Chiuso, T.Katayama and G.Picci,
%        "Comparison of two subspace identification methods for 
%             combined deterministic-stochastic systems"
% -----------------
%
% (A,C,K,Lambda) is a state space realization of the innovation model
%  time-series model 
%
% y : output data as $p\times Ndat$ matrix  y=[y(1),y(2),...,y(Ndat)]
% n : order of innovation model
% k : truncation index
% K : Kalman gain
% Lambda : variance of innovation process
%
% Written by H. Kawauchi
%     2/14/2000
% modified by T. Katayama   
%     January 2003
%

function [A,C,K,Lambda]=cca_s(y,n,k)

if (nargin < 4 | isempty(k))
   k = 15;
end;

[p,Ndat]=size(y);

N=Ndat-2*k;


ii=0;
for i=1:p:2*k*p-p+1,
 ii=ii+1;
 Y(i:i+p-1,:)=y(:,ii:ii+N-1);
end;

%%  Conditional Covariances

Yf=Y(p*k+1:p*2*k,:);
Yp=Y(1:p*k,:);
H=[Yp; Yf];
[Q,L]=qr(H',0);
Q=Q';
L=L';

L11=L(1:k*p,1:k*p);
L21=L(k*p+1:2*k*p,1:k*p);
L22=L(k*p+1:2*k*p,k*p+1:2*k*p);
Sigff=L21*L21'+L22*L22';
Sigfp=L21*L11';
Sigpp=L11*L11';

[Uf,Sf,Vf]=svd(Sigff);
[Up,Sp,Vp]=svd(Sigpp);
Sf=sqrtm(Sf);
Sfi=inv(Sf);
Sp=sqrtm(Sp);
Spi=inv(Sp);
Lff=Vf*Sfi*Uf';
Lpp=Vp*Spi*Up';

Y=Yf(1:p,1:N-1);

%% State Estimation

OC=Lff*Sigfp*Lpp;
[Pv,Sv,Vv]=svd(OC);

%if (nargin == 4 | isempty(n))
%    sing=svd(OC);
%    a=plot(sing,'s-');
%    set(a,'markersize',10)
%    xlabel('Order')
%    ylabel('Singular values')
%    title('Singular values vs. model order')
%    grid
%    n=input('Select model order: ');
%end;

Sv1=Sv(1:n,1:n);
Pv1=Pv(:,1:n);
Vv1=Vv(:,1:n);
X=sqrtm(Sv1)*Vv1'*Lpp*Yp;
XX=X(:,2:N);
X=X(:,1:N-1);

%%  Computation of the system matrices

ABCD=[XX;Y]/[X];
A=ABCD(1:n,1:n);
C=ABCD(n+1:n+p,1:n);

W=XX-A*X;
E=Y-C*X;
SigWE=[W;E]*[W;E]'/(N-1);
Sigww=SigWE(1:n,1:n);
Sigee=SigWE(n+1:n+p,n+1:n+p);
Sigwe=SigWE(1:n,n+1:n+p);
[K,PP,PF,E]=dlqe(A,eye(size(A)),C,Sigww,Sigee,Sigwe);
Lambda=C*PP*C'+Sigee;




















