function z=filter_initial(Ys,Ad,Cd)

%function z=filter_initial(Ys,Ad,Cd)
%
% filter out initial condition ;
% Ys : [pk x N] Hankel data matrix with projected stochastic component;
% Ad : estimated  A matrix of the deterministic subsystem;
% Cd : estimated C matrix of deterministic subsystem;
% z :  filtered stochastic component z = [z(1) z(2)..... z(N)].
%
%
%
% Written by A. Chiuso
% 1/31/2000

if nargin ~=3 
 disp('wrong number of arguments')
 return
end;
[ra ca] = size(Ad);
if ra~=ca
 disp('Ad must be square')
 return;
end; 
[rc cc] = size(Cd);
if ca~=cc
 disp('Ad and Cd must have the same number of columns')
 return;
end; 

p = rc; % number of outputs;

[kp N] = size(Ys);

k= kp/p;

if k~=floor(k)
 disp('Ys must have k*p rows')
 return
end;

if kp < ra
 disp('The number of rows must be greater than the order of the estimated system')
 return
end;

% construct deterministic Observability matrix
Od = Cd;
for i= 2:k,
 Od =[Cd ; Od*Ad];
end;

% solve LS problem
Z = (eye(kp) - Od*pinv(Od))*Ys;

% extract last block row

z=Z((k-1)*p+1:kp,:);
