function z=filter_initial_gamma(Ys,Gamma,p)

%function z=filter_initial_gamma(Ys,Gamma,p)
%
% filter out initial condition ;
% Ys : [pk x N] Hankel data matrix with projected stochastic component;
% Gamma : estimated  Deterministic Observability matrix
% z :  filtered stochastic component z = [z(1) z(2)..... z(N)].
% p = number of outputs
%
%
%
% Written by A. Chiuso
% 1/31/2000

if nargin ~=3 
 disp('wrong number of arguments')
 return
end;
[rg cg] = size(Gamma);
[ry cy] = size(Ys);
if rg~=ry
 disp('Gamma and Ys must have the same number of rows')
 return;
end; 


[kp N] = size(Ys);

k= kp/p;

if k~=floor(k)
 disp('Ys must have k*p rows')
 return
end;

if kp < cg
 disp('The number of rows must be greater than the order of the estimated system')
 return
end;

% solve LS problem
Z = (eye(kp) - Gamma*pinv(Gamma))*Ys;

% extract last block row

z=Z((k-1)*p+1:kp,:);
