% main10_2.m
% Figs. 10.9 -- 10.12, pp. 260-262
% 
%%---------------------------------
%%  2003.11.25 by H. Kawauchi
%%---------------------------------
clear all

Number=10;
N = 4000;           %% f[^
k = 40;             %% f[^s̃TCY
trans = 100;
n=5;                %% vg̎
nc=4;               %% Rg[̎
m=1;                %% ͎
p=1;                %% o͎
f=[10^(-2):pi/512:pi];
t=0:0.01:2*pi;
%%---------------------------------
%%    VXe
%%---------------------------------
zd=[-11.6519 ;         %% vg
     -1.3950 ;
     -0.2140 ;
      0.0059];
pd=[0.7319+0.6005i ;
    0.7319-0.6005i ;
    1.0000         ;
    0.9674+0.1493i ;
    0.9674-0.1493i];
kd=0.00098;
[AP,BP,CP,DP]=zp2ss(zd,pd,kd);

AC = [2.65  -3.11  1.75  -0.39;   %% Rg[
       1      0     0      0 ;
       0      1     0      0 ;
       0      0     1      0 ];
BC = [1;
      0;
      0;
      0];
CC = [-0.4135 0.8629 -0.7625 0.2521];
DC = 0.63;

Ac=[AP-BP*DC*CP -BP*CC;  BC*CP AC ];

figure(1)                        %% [vn̋
a=plot(real(eig(Ac)),imag(eig(Ac)),'r+');
set(a,'markersize',36)
hold on 
plot(sin(t),cos(t),'-')
axis('square')
axis([0.1 1.5 -0.8 0.8])
grid

[z,p] = ss2tf(AP,BP,CP,DP,1);
h = freqz(z,p,f);
figure(2)                      %% vg̃{[h}
semilogx(f,20*log10(abs(h)),'r--');
axis([10^(-2) pi+0.3 ...
       min(20*log10(abs(h)))-5 max(20*log10(abs(h)))+5])
hold on
grid

[z,p] = ss2tf(AC,BC,CC,DC,1);
h = freqz(z,p,f);
figure(3)                      %% Rg[̃{[h}
semilogx(f,20*log10(abs(h)),'r--');
axis([10^(-2) pi+0.3 ...
       min(20*log10(abs(h)))-5  max(20*log10(abs(h)))+5])
hold on
grid

figure(4)                      %% vg̋
a=plot(real(eig(AP)),imag(eig(AP)),'r+');
set(a,'markersize',36)
hold on 
plot(sin(t),cos(t),'-')
axis('square')
axis([0.1 1.5 -0.8 0.8])
grid

figure(5)                      %% Rg[̋
a=plot(real(eig(AC)),imag(eig(AC)),'rx');
set(a,'markersize',36)
hold on 
plot(sin(t),cos(t),'-')
axis('square')
axis([0.1 1.5 -0.8 0.8])
grid

figure(6)                    %% vgɁ{Rg[  
a=plot(real(eig(AP)),imag(eig(AP)),'r+');
set(a,'markersize',36)
hold on 
a=plot(real(eig(AC)),imag(eig(AC)),'rx');
set(a,'markersize',36)
plot(sin(t),cos(t),'-')
axis('square')
axis([0.1 1.5 -0.8 0.8])
grid

randn('state',0)   %  the same random numbers are generated
%%----------------------------------------
%%       
%%----------------------------------------

hp=zeros(1,511);
hc=zeros(1,511);


for l=1:Number
iteration=l

%%-----------------------------
%%      f[^
%%-----------------------------
e=randn(1,N+k+trans)/3;
r1=randn(1,N+k+trans)*sqrt(2);
r2=randn(1,N+k+trans)*sqrt(.5);


x_p=zeros(5,1);   %% vg̎
x_c=zeros(4,1);   %% Rg[̎

for i=1:N+k+trans,
  y(i) = CP*x_p+e(i);
  u(i) = r2(i)+CC*x_c+DC*(r1(i)-y(i));
  x_p  = AP*x_p+BP*u(i);
  x_c  = AC*x_c+BC*(r1(i)-y(i));
end
e  = e(trans+2:N+k+trans);
u  = u(trans+2:N+k+trans);
r1 = r1(trans+2:N+k+trans);
r2 = r2(trans+2:N+k+trans);
y  = y(trans+2:N+k+trans);

w  = [y  ;  u];
r  = [r1 ; r2];

[Ad,Bd,Cd,Dd]=...
   ort_dec(w,r,9,9,15,15,'proj_ls',[],[0 0],'ort','TLS');
% ort_dec.m Q

figure(1)
hold on 
plot(real(eig(Ad)), imag(eig(Ad)),'*')

n=9;
A_hat=Ad-Bd(1:n,2:2)*inv(Dd(2,2))*Cd(2:2,1:n);
figure(6)
hold on 
plot(real(eig(A_hat)),imag(eig(A_hat)),'*')

Ap=A_hat;                             %%  vg̎
Bp=Bd(1:n,2:2)*inv(Dd(2,2));
Cp=Cd(1:1,1:n);
Dp=0;
Ac=A_hat;                             %% Rg[̎
Bc=Bd(1:n,1:1)-Bd(1:n,2:2)*inv(Dd(2,2))*Dd(2,1);
Cc=inv(Dd(2,2))*Cd(2:2,1:n);
Dc=inv(Dd(2,2))*Dd(2,1);

%%----------------------------------------
%%        f᎟
%%----------------------------------------
% vg
[Ap,Bp,Cp,Sigp]=reduction(Ap,Bp,Cp,5);  %% 9->5ɒ᎟

% Rg[
%[Ac,Bc,Cc,Sigc]=reduction(Ac,Bc,Cc,4);  %% 9->4ɒ᎟
[Ac,Bc,Cc,Sigc]=reduction(Ac,Bc,Cc,5); %% 9->5ɒ᎟

[z,p] = ss2tf(Ap,Bp,Cp,Dp,1);
hp=hp+freqz(z,p,f);
%hp=freqz(z,p,f);
[z,p] = ss2tf(Ac,Bc,Cc,Dc,1);
hc=hc+freqz(z,p,f);
%hc=freqz(z,p,f);

figure(4)    %% plant
hold on
plot(real(eig(Ap)),imag(eig(Ap)),'*')
grid
figure(5)    %% controller
hold on
plot(real(eig(Ac)),imag(eig(Ac)),'*')
grid
end

hp=hp/Number;
hc=hc/Number;

figure(2)
semilogx(f,20*log10(abs(hp)),'-')
hold on
figure(3)
semilogx(f,20*log10(abs(hc)),'-')
hold on



epsform(1,'Real Part','Imaginary Part',[15 14],20,16,[],'',[])
epsform(2,'Frequency [rad/sec]','Gain [dB]',[16 12],20,16,[],'',[])
epsform(3,'Frequency [rad/sec]','Gain [dB]',[16 12],20,16,[],'',[])
epsform(4,'Real Part','Imaginary Part',[15 14],20,16,[],'',[])
epsform(5,'Real Part','Imaginary Part',[15 14],20,16,[],'',[])
epsform(6,'Real Part','Imaginary Part',[15 14],20,16,[],'',[])














