function [Ar,Br,Cr,Sig]=reduction(A,B,C,n);

p=max(abs(eig(A)));
order=n

if p>=1;
  [K,S,E]=dlqr(A,B,C'*C,1);
   A=A-B*K;
   C=[C ; K];
   alpha=(1+B'*S*B)^(-1/2);
   B=B*alpha;
end

P=dlyap(A,B*B');
Q=dlyap(A',C'*C);
S=chol(P);
R=chol(Q);
[U,Sig,V]=svd(S*R');
L=Sig(1:n,1:n)^(-1/2)*V(:,1:n)'*R;
T=S'*U(:,1:n)*Sig(1:n,1:n)^(-1/2);
Ar=L*A*T;
Br=L*B;
Cr=C*T;

if p>=1;
  Ar=Ar+Br*alpha^(-1)*Cr(2,1:n);
  Cr=Cr(1,1:n); 
  Br=Br/alpha;
end

