% Example 10.2
% Comparison of Performance
% CCA and ORT
clear
clear
%%---------------------------------
res_av_st = zeros(1,16);
fail_st = zeros(1,16);
for Ns = 1:16,
%%---------------------------------
%%   closed loop identification
%%---------------------------------
%Number=50;
Number=30;
switch Ns
%------------------------
 case 1,  N = 500;   method = 1;  r1noise = 1;
 case 2,  N = 1000;  method = 1;  r1noise = 1;
 case 3,  N = 2000;  method = 1;  r1noise = 1;
 case 4,  N = 5000;  method = 1;  r1noise = 1;
%------------------------
 case 5,  N = 500;   method = 2;  r1noise = 1;
 case 6,  N = 1000;  method = 2;  r1noise = 1;
 case 7,  N = 2000;  method = 2;  r1noise = 1;
 case 8,  N = 5000;  method = 2;  r1noise = 1;
%------------------------
 case 9,  N = 500;   method = 1;  r1noise = 2;
 case 10, N = 1000;  method = 1;  r1noise = 2;
 case 11, N = 2000;  method = 1;  r1noise = 2;
 case 12, N = 5000;  method = 1;  r1noise = 2;
%------------------------
 case 13, N = 500;   method = 2;  r1noise = 2;
 case 14, N = 1000;  method = 2;  r1noise = 2;
 case 15, N = 2000;  method = 2;  r1noise = 2;
 case 16, N = 5000;  method = 2;  r1noise = 2;
%------------------------
end;
k = 40;             %% data size
trans = 100;       %% # of data skipped
n=5;                %% dim(plant)
nc=4;               %% dim(controller)
m=1;                %% dim(output) 
p=1;                %% dim(inout)
f=[10^(-2):pi/512:pi];
t=0:0.01:2*pi;

%%---------------------------------
%%    Display
%%---------------------------------
if(Ns==1),
  fprintf('\n')
  fprintf('============================\n')
  fprintf('r1 is white noise input \n')
  fprintf('============================\n')
  fprintf('-------------------------------------------------------------\n')
  fprintf(' Orthogonal projection method (Chiuso 2000)\n')
  fprintf('-------------------------------------------------------------\n')
elseif(Ns==5),
  fprintf('-------------------------------------------------------------\n')
  fprintf(' Canonical correlation analysis (Katayama, Picci 1999; cov-a)\n')
  fprintf('-------------------------------------------------------------\n')
elseif(Ns==9),
  fprintf('\n')
  fprintf('============================\n')
  fprintf('r1 is sinusoidal input\n')
  fprintf('============================\n')
  fprintf('-------------------------------------------------------------\n')
  fprintf(' Orthogonal projection method (Chiuso 2000)\n')
  fprintf('-------------------------------------------------------------\n')
elseif(Ns==13),
  fprintf('-------------------------------------------------------------\n')
  fprintf(' Canonical correlation analysis (Katayama, Picci 1999; cov-a)\n')
  fprintf('-------------------------------------------------------------\n')
end;
fprintf(' N=%d\n',N); %% # of data

%%---------------------------------
%%    System
%%---------------------------------
nump=[0,1,0];         %% plant
denp=[1,-1.6,0.89];
numc=[1,-0.8];
%numc=[0.6,-0.64];
denc=[1,0.0];
numh=[1,-1.56,1.045,-0.3338];
denh=[1,-2.35,2.09,-0.6675];
[AP,BP,CP,DP]=tf2ss(nump,denp);
[AC,BC,CC,DC]=tf2ss(numc,denc);
[AH,BH,CH,DH]=tf2ss(numh,denh);

%Ac=[AP-BP*DC*CP -BP*CC;  BC*CP AC ];
%

[NUMP_,DENP_] = ss2tf(AP,BP,CP,DP,1);
h = freqz(NUMP_,DENP_,f);
%figure(2)                      %% Bode plot of plant
%semilogx(f,20*log10(abs(h)),'--');
%axis([10^(-2) pi+0.3 ...
%       min(20*log10(abs(h)))-5 max(20*log10(abs(h)))+5])
%hold on


[z,p] = ss2tf(AC,BC,CC,DC,1);
h = freqz(z,p,f);
%figure(3)                      %% Bode plot of controller 
%semilogx(f,20*log10(abs(h)),'--');
%axis([10^(-2) pi+0.3 ...
%       min(20*log10(abs(h)))-5  max(20*log10(abs(h)))+5])
%hold on


%figure(5)                      %% poles of plant
%a=plot(real(eig(AP)),imag(eig(AP)),'r+');
%set(a,'markersize',36)
%hold on 
%plot(sin(t),cos(t),':')
%axis('square')
%axis([0.1 1.5 -0.8 0.8])


%figure(6)                      %% poles of controller
%a=plot(real(eig(AC)),imag(eig(AC)),'r+');
%set(a,'markersize',36)
%hold on 
%plot(sin(t),cos(t),':')
%axis('square')
%axis([0.1 1.5 -0.8 0.8])



%%----------------------------------------
%%       System Identification
%%----------------------------------------

hp=zeros(1,511);
hc=zeros(1,511);
res_av = 0;
fail = 0;

for l=1:Number
%l
if(l == 1),
 fprintf('     l=%d,',l);
elseif(l < Number),
 fprintf('%d,',l);
else, 
 fprintf('%d\n',l);
end;

randn('state',0)   %  the same random numbers are generated
%%-----------------------------
%%      Data
%%-----------------------------
e=randn(1,N+k+trans)/3;
r2=randn(1,N+k+trans)*sqrt(.2);
et=randn(1,N+k+trans)/10;
if (r1noise==1), 
  r1=randn(1,N+k+trans)*sqrt(1);
elseif(r1noise==2),
  tt = linspace(1,N+k+trans,N+k+trans); 
  MM = 30;
  Ai = randn(1,MM)+ones(1,MM);  % average 1, variance 1
  wi = pi*rand(MM,1);      
  phi= pi*rand(MM,1);
  r1 = Ai*sin(wi*tt+phi*ones(1,N+k+trans));
  r1 = r1/sqrt(cov(r1));
end;

x_p=zeros(2,1);
x_c=zeros(1,1);
x_h=zeros(3,1);

for i=1:N+k+trans,
  s(i) = CH*x_h+DH*e(i);
  y(i) = CP*x_p+s(i);
  u(i) = r2(i)+CC*x_c+DC*(r1(i)-y(i))+et(i);
  x_p  = AP*x_p+BP*u(i);
  x_c  = AC*x_c+BC*(r1(i)-y(i));
  x_h  = AH*x_h+BH*e(i);
end
e  = e(trans+2:N+k+trans);
u  = u(trans+2:N+k+trans);
r1 = r1(trans+2:N+k+trans);
r2 = r2(trans+2:N+k+trans);
y  = y(trans+2:N+k+trans);

w  = [y  ;  u];
r  = [r1 ; r2];


if(method==1),
% Orthogonal projection method (Chiuso 2000)
% [Ad,Bd,Cd,Dd]=ort_dec(w,r,3,3,15,15,'proj_ls',[],[0 0],'ort','TLS');
%% Orthogonal projection method (Picci, Katayama 2003; revised March 2004)
[Ad,Bd,Cd,Dd]=ort_pk2(w,r,n,15);  % dimension n is given

elseif(method==2),
% Canonical correlation analysis (Katayama, Picci 1999; cov-a)
  [Ad,Bd,Cd,Dd,K,Lam]=cca(w,r,6,15);
end;

if (max(abs(eig(Ad)))<=1),

 Ap=Ad-Bd(:,2)*inv(Dd(2,2))*Cd(2,:);   %%  plant
 Bp=Bd(:,2)*inv(Dd(2,2));
 Cp=Cd(1,:);
 Dp=0;

 Ac=Ad-Bd(:,2)*inv(Dd(2,2))*Cd(2,:);   %%  controller
 Bc=Bd(:,1)-Bd(:,2)*inv(Dd(2,2))*Dd(2,1);
 Cc=inv(Dd(2,2))*Cd(2,:);
 Dc=inv(Dd(2,2))*Dd(2,1);

%%----------------------------------------
%%        Model reduction (balanced)
%%----------------------------------------

 if (max(abs(eig(Ap)))<=1),
  if (max(abs(eig(Ac)))<=1),

   [Ap,Bp,Cp,Sigp]=reduction(Ap,Bp,Cp,2);
% [Ap,Bp,Cp,Sigp]=reduction2(Ap,Bp,Cp,2);
   [Ac,Bc,Cc,Sigc]=reduction(Ac,Bc,Cc,1);
   %[Ap,Bp,Cp,Sigp]=btared(Ap,Bp,Cp,5);
   %[Ac,Bc,Cc,Sigc]=btared(Ac,Bc,Cc,4);

   [nump_,denp_] = ss2tf(Ap,Bp,Cp,Dp,1);
   %hp=hp+freqz(nump_,denp_,f);
   hp=freqz(nump_,denp_,f);

   [z,p] = ss2tf(Ac,Bc,Cc,Dc,1);
   %hp=hp+freqz(z,p,f);
   hp=freqz(z,p,f);

   THETA_ = [NUMP_,DENP_];
   theta_ = [nump_,denp_];
   res_av = res_av + (THETA_-theta_)*(THETA_-theta_)';

  else,
    fail = fail+1;
  end; %of if (max(abs(eig(Ac)))<=1),

 else,
   fail = fail+1;
 end; %of if (max(abs(eig(Ap)))<=1),

else, 
  fail = fail+1;
end; %of if (max(abs(eig(Ad)))<=1),

end; %of l
hp=hp/(Number-fail);
hc=hc/(Number-fail);
res_av = res_av/(Number-fail);

%epsform(1,'Real Part','Imaginary Part',[14 14],18,14,[],'',[])
%epsform(2,'Frequency [rad/sec]','[dB]',[16 12],18,14,[],'',[])
%epsform(4,'Real Part','Imaginary Part',[14 14],18,14,[],'',[])
%epsform(3,'Frequency [rad/sec]','[dB]',[16 12],18,14,[],'',[])
%epsform(5,'Real Part','Imaginary Part',[14 14],18,14,[],'',[])
%epsform(6,'Real Part','Imaginary Part',[14 14],18,14,[],'',[])
%epsform(7,'Real Part','Imaginary Part',[14 14],18,14,[],'',[])

res_av_st(1,Ns) = res_av;
fail_st(1,Ns) = fail;
%%---------------------------------
end; % of Ns

disp('Saving variables to perf2.mat ');
save perf2;
fail_st


format short e
res_av_st
%
%


