% Example 5.6
%-----------
% MOESP Basic
clear;
n=2;
k_ = 4;
nu = 100;

M = nu + 2*k_ -1;
t = linspace(1,M,M);
%---------
% Plant and inputs
AP=[0.6  0.4 
-0.4 0.6];
BP=[0
1];
CP=[1  0.5];
DP=0;
[nump, denp]=  ss2tf(AP,BP,CP,DP,1);

p=1;
q=1;
kkk=100;
num0=zeros(kkk,3);
den0=zeros(kkk,3);
sing0=zeros(kkk,2*k_);

for j_ = 1:kkk
%
u =1* randn(1,M);
% disturbance
v = 0.1*randn(1,M);
nums = 1; 
dens = 1;
% Generation of input-output data  
x_h=zeros(n,1);  % Initial state
for i=1:M
  s(i) = CP*x_h+DP*u(i);
  y(i) = s(i)+v(i);
  x_h  = AP*x_h+BP*u(i);
end
%----------------------------------
% Subspace Identifiction by MOESP
%----------------------------------
k=2*k_;
Up = []; Uf = [];
Yp = []; Yf = [];
for j = 1:k_,
 Up = [Up;u(:,j:nu+j-1)];
 Yp = [Yp;y(:,j:nu+j-1)];
end;
for j = k_+1:2*k_,
 Uf = [Uf;u(:,j:nu+j-1)];
 Yf = [Yf;y(:,j:nu+j-1)];
end;
%---------------
Ua = [Up;Uf];
Ya = [Yp;Yf];

L = triu(qr([Ua;Ya]'))';
L11 = L(1:k,1:k);
L21 = L(k+1:2*k,1:k);
L22 = L(k+1:2*k,k+1:2*k);
[U_,S,V_] = svd(L22);
%------------------------------------
s1= diag(S)';
U1 = U_(:,1:n);
O_ = U1*sqrtm(S(1:n,1:n));
Ca = O_(1:p,1:n);
Aa = pinv(O_(1:p*(k-1),1:n))*O_(p+1:k*p,1:n);
%------------------------------------
% Calculation of B and D
U2 = U_(:,n+1:size(U_)*[0;1]);
Xi = U2'*L21/L11;
Xi_ = [];
R_ = [];
for j = 1:k, 
 Xi_ = [Xi_;Xi(:,q*(j-1)+1:q*j)];
 O_k_j = O_(1:p*(k-j),:);
 R_j = [zeros(p*(j-1),p),zeros(p*(j-1),n);
       eye(p), zeros(p,n);
       zeros(p*(k-j),p),O_k_j];
 R_ = [R_;U2'*R_j];
end;
DB = pinv(R_)*Xi_;
Da = DB(1:p,:);
Ba = DB(p+1:size(DB)*[1;0],:);

[numa,dena] = ss2tf(Aa,Ba,Ca,Da,1);
num0(j_,:)=numa;
den0(j_,:)=dena;
sing0(j_,:)=s1;
end; % of j_

%----------------------------------------------------
ss1=sing0(:,1);
ss2=sing0(:,2);
ss3=sing0(:,3);
ss4=sing0(:,4);
ss5=sing0(:,5);

disp('Five largest singular values and standard deviations') 
disp('Table 5.1')
sg1=mean(ss1)
stdsg1=std(ss1)

sg2=mean(ss2)
stdsg2=std(ss2)

sg3=mean(ss3)
stdsg3=std(ss3)

sg4=mean(ss4)
stdsg4=std(ss4)

sg5=mean(ss5)
stdsg5=std(ss5)
%-----------------------------------------------------
disp('Estimates of parameters and standard deviations')
disp('Table 5.2')
b_0=num0(:,1);
b_1=num0(:,2);
b_2=num0(:,3);
a_1=den0(:,2);
a_2=den0(:,3);

a1=mean(a_1)
stda1=std(a_1)
a2=mean(a_2)
 stda2=std(a_2)

 b0=mean(b_0)
stdb0=std(b_0)

b1=mean(b_1)
stdb1=std(b_1)
b2=mean(b_2)
stdb2=std(b_2)



