% Program Exammple 5.7 
clear
% x(t)=10sin(0.24\pi t + phi1) + 5sin(0.26\pi t + phi2)
% y(t)=x(t) + e(t)
% e(t):= white noise
%
n=1024;
k=16;
k2=k*2;
nk=n+k2;
sxx=zeros(1,30);
syy=zeros(1,30);
% data
d=sqrt(10);
ph1=pi*(rand-0.5);
ph2=pi*(rand-0.5);
w1=0.24*pi;
w2=0.34*pi;
A1=10;
A2=5;
e=randn(1,nk);
tt = linspace(1,nk,nk); 
x1 = A1*sin(w1*tt+ph1*ones(1,nk));
x2 = A2*sin(w2*tt+ph2*ones(1,nk));
x = x1+x2;
y = x+d*e;


X = [];
Y = [];

for j = 1:k
X = [X;x(j:n+j-1)];
Y = [Y;y(j:n+j-1)];
end;
X=X/sqrt(n);
Y=Y/sqrt(n);

[ux,sx,vx]=svd(X);
for j=1:k
sxx(j)=sx(j,j);
end;

[uy, sy, vy]=svd(Y);
for j=1:k
syy(j)=sy(j,j);
end;
syy


z=[sxx; syy];

figure(1);
clf;
plot(z','LineWidth',1.5)

axis([0,20,0,25]);
%set(gca,'FontName','times','FontSize',18);
grid
%----------------------------------------------------
epsform(1,'Index i','Singular Values',[16 12],18,16,[],'',[])


