% example7_1.m
% Example 7.8.1, p. 179
% Algorithm A of Table B.4; see p. 286
% Riccati equation is not used
%
clear
randn('state',0)
N=10000;  % # of data
% N=5000; 
k=10;    % # of rows
NN=N+3*k;
kk=6;    % number of singular values
n=2;     % dimension of state vector
p=1;     % dimension of outout vector
% Simulation model
numh=[1 -0.5 0.3];
denh=[1 -1.5 0.7];

[AH,BH,CH,DH]=tf2ss(numh,denh);
%% Generation of time-series  y 
v=randn(1,NN);   % Gaussian white noise
x_h=zeros(n,1);  % Initial state
for i=1:NN
  s(i) = CH*x_h+DH*v(i);
  y(i) = s(i);
  x_h  = AH*x_h+BH*v(i);
end
%% Data matrix (1)
ii=0;
for i=1:p:2*k*p-p+1,
 ii=ii+1;
 Y(i:i+p-1,:)=y(:,ii:ii+N-1);
end;
%% Data Matrix (2); 
Ypp=Y(1:p*k,:);
for i=1:k
    j=(k-i)*p+1;
 Yp(j:j+p-1,:)=Ypp((i-1)*p+1:i*p,:);  % \check{Y}_{0|k-1}
end
Yf=Y(p*k+1:p*2*k,:);
%% LQ decomposition
H=[Yp; Yf];
[Q,L]=qr(H',0);
Q=Q';
L=L';
L11=L(1:k*p,1:k*p);
L21=L(k*p+1:2*k*p,1:k*p);
L22=L(k*p+1:2*k*p,k*p+1:2*k*p);
%% Covariance Matrices
Rff=(L21*L21'+L22*L22')/N;
Rfp=L21*L11'/N;
Rpp=L11*L11'/N;
%% Square Roots 
[Uf,Sf,Vf]=svd(Rff);
[Up,Sp,Vp]=svd(Rpp);
Sf=sqrtm(Sf);
Sp=sqrtm(Sp);
Lf=Uf*Sf*Vf';
Lp=Up*Sp*Vp';
%% Inverses
Sfi=inv(Sf);
Spi=inv(Sp);
Lfinv=Vf*Sfi*Uf';
Lpinv=Vp*Spi*Up';
%% Normalized SVD
OC=Lfinv*Rfp*Lpinv';
[U2,S2,V2]=svd(OC);
%% Small Size n =dim of x
SS=S2(1:n,1:n);
UU=U2(:,1:n);
VV=V2(:,1:n);
%% For information of simulation
for i=1:min(k,6)
sig(i)=S2(i,i);  % canonnical correlation coefficients  
end
%% Covariance of output
Lambda=Rpp(1:p,1:p);
%% Extended observability and reachability matrices
Ok=Lf*UU*sqrtm(SS);
Ck=sqrtm(SS)*VV'*Lp';
%% System matrices
C=Ok(1:p,:);
A=Ok(1:k*p-p,:)\Ok(p+1:k*p,:);
Cb=Ck(:,1:p)'; 
R=Lambda-C*SS*C'; 
K=(Cb'-A*SS*C')/R;
%% Tranfer function
[num,den]=ss2tf(A,K,C,1)
disp('>> Table 7.1, p. 179')
N
sig


