% example7_2.m
% Example 7.8.2, p. 180
% Algorithm A of Table B.4; see p. 286
%
clear
randn('state',0)   %  the same random numbers are generated
N=10000;  % # of data
k=10;    % # of rows
NN=N+3*k;
kk=6;    % # of canonical correlation coefficients
n=3;     % dimension of state vector
p=1;     % dimension of outout vector
% simulation model
AA=[0.6 0.6 0
    -0.6 0.6 0
    0 0 0.4];
BB=[0.17 -0.15 0.28]';
CC=[0.78 0.53 1];
DD=1;
[nump,denp]=ss2tf(AA,BB,CC,DD);
nump
denp
%% generation of time-series y 
v=randn(1,NN);  % Gaussian white noise
x=zeros(n,1);  % initial state
for i=1:NN
  y(i) = CC*x+DD*v(i);
    x  = AA*x+BB*v(i);
end
%% data matrix (1)
ii=0;
for i=1:p:2*k*p-p+1,
 ii=ii+1;
 Y(i:i+p-1,:)=y(:,ii:ii+N-1);
end;
%% data matrix (2)
Ypp=Y(1:p*k,:);
for i=1:k
    j=(k-i)*p+1;
 Yp(j:j+p-1,:)=Ypp((i-1)*p+1:i*p,:); % \check{Y}_{0|k-1}  
end
Yf=Y(p*k+1:p*2*k,:);
%% LQ decomposition
H=[Yp; Yf];
[Q,L]=qr(H',0);
Q=Q';
L=L';
%% covariance matrices
L11=L(1:k*p,1:k*p);
L21=L(k*p+1:2*k*p,1:k*p);
L22=L(k*p+1:2*k*p,k*p+1:2*k*p);
Rff=(L21*L21'+L22*L22')/N;
Rfp=L21*L11'/N;
Rpp=L11*L11'/N;
%% square roots 
[Uf,Sf,Vf]=svd(Rff);
[Up,Sp,Vp]=svd(Rpp);
Sf=sqrtm(Sf);
Sp=sqrtm(Sp);
Lf=Uf*Sf*Vf';   % Cholesky factor
Lp=Up*Sp*Vp';   % Cholesky factor
%%
Sfi=inv(Sf);
Spi=inv(Sp);
Lfinv=Vf*Sfi*Uf';  % inverse of Cholesky factor
Lpinv=Vp*Spi*Up';  % inverse of Cholesky factor
% normalized SVD
OC=Lfinv*Rfp*Lpinv';
[U2,S2,V2]=svd(OC);
% n =dim of x
SS=S2(1:n,1:n);
UU=U2(:,1:n);
VV=V2(:,1:n);
%% 
for i=1:min(k,6)
   sigma(i)=S2(i,i);  %% canonical correlation coefficients 
end
%% covariance of output y
Lambda=Rpp(1:p,1:p);
%% extended observability and reachability matrices
Ok=Lf*UU*sqrtm(SS);
Ck=sqrtm(SS)*VV'*Lp';
%% system matrices
C=Ok(1:p,:);
A=Ok(1:k*p-p,:)\Ok(p+1:k*p,:);
Cb=Ck(:,1:p)'; 
R=Lambda-C*SS*C';
K=(Cb'-A*SS*C')/R;
%% tranfer function
[num,den]=ss2tf(A,K,C,1);
disp('>> Table 7.3, p. 180')
N
sigma
disp('>> Table 7.4, p. 181')
num
den
