clear
% Chapter 7, Example 7.1
% Algorithm A 
% Riccati equation is not used
%
randn('state',0)
N=10000;  % # of data
k=10;    % # of rows
NN=N+3*k;
kk=6;    % number of singular values
n=2;     % dimension of state vector
p=1;     % dimension of outout vector
% Simulation model
numh=[1 -0.5 0.3];
denh=[1 -1.5 0.7];
[AH,BH,CH,DH]=tf2ss(numh,denh);
%% Generation of time-series  y 
v=randn(1,NN);   % Gaussian white noise
x_h=zeros(n,1);  % Initial state
for i=1:NN
  s(i) = CH*x_h+DH*v(i);
  y(i) = s(i);
  x_h  = AH*x_h+BH*v(i);
end
%% Data matrix (1)
ii=0;
for i=1:p:2*k*p-p+1,
 ii=ii+1;
 Y(i:i+p-1,:)=y(:,ii:ii+N-1);
end;
%% Data Matrix (2)
%% Ypp=Y(1:p*k,:);
%% for i=1:k
%%    ii=k-i+1;
%% Yp(ii,:)=Ypp(i,:);  % \check{Y}_{0|k-1}
%% end
Yf=Y(p*k+1:p*2*k,:);
Yp=Y(1:k*p,:);
%% LQ decomposition
H=[Yp; Yf];
[Q,L]=qr(H',0);
L=L';
L11=L(1:k*p,1:k*p);
L21=L(k*p+1:2*k*p,1:k*p);
L22=L(k*p+1:2*k*p,k*p+1:2*k*p);
%% Covariance Matrices
Rff=(L21*L21'+L22*L22')/N;
Rfp=L21*L11'/N;
Rpp=L11*L11'/N;
%% Square Roots 
[Uff,Sff,Vff]=svd(Rff);
[Upp,Spp,Vpp]=svd(Rpp);
Sf=sqrtm(Sff);
Sp=sqrtm(Spp);
L=Uff*Sf*Vff';
M=Upp*Sp*Vpp';
%% Inverses
Sfi=inv(Sf);
Spi=inv(Sp);
Linv=Vff*Sfi*Uff';
Minv=Vpp*Spi*Upp';
%% Normalized SVD
OC=Linv*Rfp*Minv;
[UU,SS,VV]=svd(OC);
%% Small Size n =dim of x
S=SS(1:n,1:n);
Un=UU(:,1:n);
Vn=VV(:,1:n);
%% For information of simulation
for i=1:min(k,6)
sig(i)=SS(i,i);  % canonnical correlation coefficients  
end
%% Covariance of output
Lambda=Rpp(1:p,1:p);
%% Extended observability and reachability matrices
Ok=L*UU(:,1:n)*sqrtm(S);
Ck=sqrtm(S)*VV(:,1:n)'*M';
%% System matrices
C=Ok(1:p,:);
A=Ok(1:k*p-p,:)\Ok(p+1:k*p,:);
%Cb=Ck(:,1:p)';
Cb=Ck(:,k*p-p+1:k*p)';
R=Lambda-C*S*C';
K=(Cb'-A*S*C')/R;
%% Tranfer function
numh
denh
[num,den]=ss2tf(A,K,C,1)
sig
N
