% main8_1.m
% ort_pk.m    line 77
% po-moesp.m  line 78
% ort_pk.m    -- Orthogonal Decomposition by Picci and Katayama
% po-moesp.m  -- PO-MOESP by Verhaegen
% u: white noise; see line 50
%-----------
clear
m=1;
p=1;
n=5;
a=0.9;
k = 15;
N = 1000; % Number of data

M = N + 2*k -1;
t = linspace(1,M,M);
maga_st = [];
SN=zeros(20,1);
randn('state',0)   %  the same random numbers are generated
w = linspace(0,pi,1000);
nump = [0  0  0  0  0.0275  0.0551];
denp = [1 -2.3443 3.081 -2.5274 1.2415 -0.3686];
[AP,BP,CP,DP]=tf2ss(nump,denp);
%
nums = [1,-0.20,-0.48];
dens = [1,0.4,0.8];
[Ah,Bh,Ch,Dh]=tf2ss(nums,dens);
%
for jj = 1:30,
fprintf('jj = %d\n',jj);
%----------------------------------------------------
% disturbance  v
%---------
vv = 0.1*randn(1,M);  % white noise
x_h=zeros(2,1);       % initial state
for i=1:M
  v(i) = Ch*x_h+Dh*vv(i);
  x_h  = Ah*x_h+Bh*vv(i);
end
% v: colored noise
% input signal
uu = randn(1,M);      % white noise
u2=0;
for i=1:M
u(i)=a*u2+sqrt(1-a^2)*uu(i);
u2=u(i);
end
% u: colored input signal
u=uu;  % white noise input
gain=sqrt(var(vv)/var(v));
v=gain*v;   % v: variance of v = 0.01
% v=vv;  % white noise
Varv(jj)=var(v);
%---------
x_p=zeros(n,1);  % initial state
for i=1:M
  s(i) = CP*x_p+DP*u(i);
  y(i) = s(i)+v(i);
  x_p  = AP*x_p+BP*u(i);
end
Vars(jj)=var(s);
%----------------------------------------------------
% system identification
Up = []; Uf = [];
Yp = []; Yf = [];
for j = 1:k
 Up = [Up;u(:,j:N+j-1)];
 Yp = [Yp;y(:,j:N+j-1)];
end
for j = k+1:2*k,
 Uf = [Uf;u(:,j:N+j-1)];
 Yf = [Yf;y(:,j:N+j-1)];
end
Ua = [Uf;Up];
Ya = [Yp;Yf];
% Choose either ORT or PO-MOESP
%[Aa,Ba,Ca,Da] = ort_pk(Ua,Ya,m,p,n,k);  % ORT method
[Aa,Ba,Ca,Da] = po_moesp(Ua,Ya,m,p,n,k); % PO-MOESP method
[numa,dena] = ss2tf(Aa,Ba,Ca,Da,1);      % transfer function
% results
%--------
maga = dbode(Aa,Ba,Ca,Da,1,1,w);     % discrete-time Bode plot
maga_st = [maga_st,maga];            % identification results
%
mag_nm = dbode(nump,denp,1,w);       % discrete-time Bode plot
                                     % plant
figure(1);
clf;
plot(w,20*log10(mag_nm),'-',w,20*log10(maga_st),':');
axis([0,3.14159,-60,10]);
%set(gca,'FontName','times','FontSize',20);
end; % of j_
grid
disp('main8_1.m')
varv=mean(Varv)
vars=mean(Vars)
ratio=mean(Vars)/mean(Varv)
%----------------------------------------------------
epsform(1,'Frequency [rad/sec]','Gain [dB]',[16 12],20,16,[],'',[])

%
%
