% main8_3moesp.m
% MOESP Basic 
% Example for Chapter 8
% Numerical results using this program are not
% included in Section 8.8.
%-----------
close all;
clear;

k_ = 15;
nu = 1000;
p=1;
m=1;
n=5;
a=0.9;
M = nu + 2*k_ -1;
t = linspace(1,M,M);
maga_st = [];
randn('state',0)   %  the same random numbers are generated

for j_ = 1:30,
fprintf('j_ = %d\n',j_);

%----------------------------------------------------
% Simulation
%---------
% Input and plant
%---------
nump = [0.0275,0.0551];
denp = [1,-2.3443,3.081,-2.5274,1.2415,-0.3686];
%nump = [0.0275,0.0551];
%denp = [1,-2.7940,4.5645,-4.5518,2.7797,-0.9866];
[AP,BP,CP,DP]=tf2ss(nump,denp);
%---------
% Disturbance
%---------
vv = 0.01*randn(1,M);
nums = [1,-0.20,-0.48];
dens = [1,0.4,0.8]; 
%nums = 1; 
%dens = 1;
[Ah,Bh,Ch,Dh]=tf2ss(nums,dens);
x_h=zeros(2,1);  % Initial state
for i=1:M
  v(i) = Ch*x_h+Dh*vv(i);
  x_h  = Ah*x_h+Bh*vv(i);
end
% v: a colored noise
% input signal
uu = randn(1,M);
u2=0;
for i=1:M
u(i)=a*u2+sqrt(1-a^2)*uu(i);
u2=u(i);
end
% u: a colored noise
%u=uu;  % white input signal 
%v=vv;  % white observation noise
% Simulation
%---------
x_p=zeros(n,1);  % Initial state
for i=1:M
  s(i) = CP*x_p+DP*u(i);
  y(i) = s(i)+v(i);
  x_p  = AP*x_p+BP*u(i);
end
% y: the observed output
% u: the observed input
% v: a colored noise
%----------------------------------------------------
% System identification

Up = []; Uf = [];
Yp = []; Yf = [];

for j = 1:k_,
 Up = [Up;u(:,j:nu+j-1)];
 Yp = [Yp;y(:,j:nu+j-1)];
end;
for j = k_+1:2*k_,
 Uf = [Uf;u(:,j:nu+j-1)];
 Yf = [Yf;y(:,j:nu+j-1)];
end;

%---------------
% U and Y
%---------------
Ua = [Up;Uf];
Ya = [Yp;Yf];
k=2*k_;
[Aa,Ba,Ca,Da] = moesp(Ua,Ya,m,p,n,k); % subroutine moesp
[numa,dena] = ss2tf(Aa,Ba,Ca,Da,1);
%--------
% Results
%--------
w = linspace(0,pi,500);
maga = dbode(Aa,Ba,Ca,Da,1,1,w);
maga_st = [maga_st,maga];

mag_nm = dbode(nump,denp,1,w);

figure(1);
clf;
plot(w,20*log10(mag_nm),'-',w,20*log10(maga_st),':');
axis([0,3.14159,-60,10]);
%axis([0,3.14159,-60,20]);
%set(gca,'FontName','times','FontSize',18);

end; % of j_
grid
%----------------------------------------------------
epsform(1,'Frequency [rad/sec]','Gain [dB]',[16 12],20,16,[],'',[])
%
%
