% Table B.2, p. 284
% 
% function moesp(U,Y,m,p,n,k);
function [A,B,C,D] = moesp(U,Y,m,p,n,k);
% m=dim(u), p=dim(y), n=dim(x)
% k=number of block rows
% U=km x N matrix
% Y=kp x N matrix
km=size(U,1); % km=k*m
kp=size(Y,1); % kp=k*p
% LQ decomposition
L = triu(qr([U;Y]'))';
L11 = L(1:km,1:km);
L21 = L(km+1:km+kp,1:km);
L22 = L(km+1:km+kp,km+1:km+kp);
[UU,SS,VV] = svd(L22);
U1 = UU(:,1:n);
Ok = U1*sqrtm(SS(1:n,1:n));
% Matrices A an C
C = Ok(1:p,1:n);
A = pinv(Ok(1:p*(k-1),1:n))*Ok(p+1:k*p,1:n);
%------------------------------------
% Matrices B and D
U2 = UU(:,n+1:size(UU',1));
Xi = U2'*L21/L11;
XX = []; RR = [];
for j = 1:k, 
 XX = [XX;Xi(:,m*(j-1)+1:m*j)];
   Ok_j = Ok(1:p*(k-j),:);
   R_j = [zeros(p*(j-1),p),zeros(p*(j-1),n);
       eye(p), zeros(p,n);
       zeros(p*(k-j),p),Ok_j];
 RR = [RR;U2'*R_j];
end;
DB = RR\XX;
D = DB(1:p,:);
B = DB(p+1:size(DB,1),:);
% end of moesp.m
disp('Basic MOESP')
