% function [A,B,C,D,K]=cca_u(y,u,n,k)
%
% 
% (A,B,C,D,K) is a state space realization of the innovation model
% 
% y : output data as $p\times Ndat$ matrix  y=[y(1),y(2),...,y(Ndat)]
% u : input data as $m\times Ndat$ matrix  u=[u(1),u(2),...,u(Ndat)]
% n : order of innovation model
% k : truncation index
%
%
% Written by H. Kawauchi    2/14/2000
% modified by T. Katayama   1/21/2003

function [A,B,C,D,K]=cca(y,u,n,k)

if (nargin < 4 | isempty(k))
   k = 15;
end;

[p,Ndat]=size(y);

[m,Ndat]=size(u);

N=Ndat-2*k;

%% data matrix
ii=0;
for i=1:m:2*k*m-m+1,
 ii=ii+1;
 U(i:i+m-1,:)=u(:,ii:ii+N-1);
end;

ii=0;
for i=1:p:2*k*p-p+1,
 ii=ii+1;
 Y(i:i+p-1,:)=y(:,ii:ii+N-1);
end;

%%  Conditional Covariances

Uf=U(m*k+1:m*2*k,:);
Yf=Y(p*k+1:p*2*k,:);
Up=U(1:m*k,:);
Yp=Y(1:p*k,:);
Wp=[Up; Yp];
H=[Uf; Up; Yp; Yf];
[Q,L]=qr(H',0);
Q=Q';
L=L';

L22=L(k*m+1:k*(2*m+p),k*m+1:k*(2*m+p));
L32=L(k*(2*m+p)+1:2*k*(m+p),k*m+1:k*(2*m+p));
L33=L(k*(2*m+p)+1:2*k*(m+p),k*(2*m+p)+1:2*k*(m+p));
Rff=L32*L32'+L33*L33';
Rpp=L22*L22';
Rfp=L32*L22';
[Uff,Sff,Vff]=svd(Rff);
[Upp,Spp,Vpp]=svd(Rpp);
Sf=sqrtm(Sff);
Sfi=inv(Sf);
Sp=sqrtm(Spp);
Spi=inv(Sp);
Lfi=Uff*Sfi*Vff';
Lpi=Upp*Spi*Vpp';

U=Uf(1:m,1:N-1);
Y=Yf(1:p,1:N-1);

%% State Estimation

OC=Lfi*Rfp*Lpi';
[PP,SS,VV]=svd(OC);

S1=SS(1:n,1:n);
P1=PP(:,1:n);
V1=VV(:,1:n);
X=sqrtm(S1)*V1'*Lpi*Wp;
XX=X(:,2:N);
X=X(:,1:N-1);

%%  Computation of the system matrices

ABCD=[XX;Y]/[X;U];
A=ABCD(1:n,1:n);
B=ABCD(1:n,n+1:n+m);
C=ABCD(n+1:n+p,1:n);
D=ABCD(n+1:n+p,n+1:n+m);

W=XX-A*X-B*U;
E=Y-C*X-D*U;
SigWE=[W;E]*[W;E]'/(N-1);
QQ=SigWE(1:n,1:n);
RR=SigWE(n+1:n+p,n+1:n+p);
SS=SigWE(1:n,n+1:n+p);
%% Solution of algbraic Riccati equation
[P,L,G,Rept]=dare(A',C',QQ,RR,SS);
K=G'; % Kalman gain % L: poles of inverse filter

disp('CCA method')
















