function epsform(h,xtxt,ytxt,size,pt1,pt2,m,font,pos)
% function epsform(h,xtxt,ytxt,size,pt1,pt2,m,font,pos)
%
%   EPS file ̑傫 & tHgݒ  '96.2  by S.Tamaki
%   Matlab XV                             '97.9  by H.Tanaka
% --------+-- default ----+---------------------------------------
% 1.  h   :  current      : figure handle            
% 2. xtxt :  none         : xlabel                 
% 3. ytxt :  none         : ylabel                 
% 4. size : [14 10]       : [,] ʃTCY (cm)
% 5. pt1  :  14           : x,ylabel  TCY (pt)
% 6. pt2  :  12           :   grid    TCY (pt)
% 7.  m   : [1.5 1.5 1 1] : [,,E,] ]
% 8. font : 'Times'       : 'Times','Symbol','Helvetica','' etc.        
% 9. pos  : [1 1]         : [,] vgAEgʒu (cm)   
% -------- memo --------------------------------------------------
% matlab> epsform(1,'time','error',[],20,12,[]) : ϐȗ
% matlab> print -deps [filename]                : EPS file 쐬
%  kterm> ghostview                             : Check
% --- # /usr/local/matlab/toolbox/new/epsform.m ------------------
% cf. lineform.m refline.m

%
%     vgAEg鎞 EPS file ɕۑ鎞ɃO
%   t̑傫╶tHgȂǂ𐮂֐łD
%
%     xlabel,ylabel,axis ̕tHgC傫͌ʂ
%   ς邱Ƃł܂Cɂ͑ΉĂ܂D
%   ̃t@C̒̓KȕQlɂĂD
%
%     ̊֐gāCOt EPS file ɕۑ
%   ( print -deps [filename] )Ă ghostview ŊmF
%   ĂDʏłω܂CEPS file ł
%   tH[}bgƂ͑قȂ܂D
%
%      lm               rm
%    +----+------------+--+--------
%    |                    | tm   A
%    |[y] +------------+  +      |
%    |[t] |            |  |      |
%    |[x] | G R A P H  |  |    height  
%    |[t] |            |  |    [cm]
%    |    +------------+  +      |
%    |     [xtxt]label    | bm   v
%    +--------------------+--------
%    |                    |
%    |<--- width [cm] --->|     

     %----   default value  ----------------------------------------
      hdf = gcf;
      xdf =[];
      ydf =[];
      sdf =[14 10];
     p1df =14;
     p2df =12;
      mdf =[1.5 1.5 1 1];
      fdf ='Times';
      psf =[1 1];
    %---------------------------------------------------------------
    if nargin<1, h  = hdf;end; if isempty(h),    h  = hdf;end;
    if nargin<2,xtxt= xdf;end; if isempty(xtxt),xtxt= xdf;end;
    if nargin<3,ytxt= ydf;end; if isempty(ytxt),ytxt= ydf;end;
    if nargin<4,size= sdf;end; if isempty(size),size= sdf;end;
    if nargin<5,pt1 =p1df;end; if isempty(pt1), pt1 =p1df;end;
    if nargin<6,pt2 =p2df;end; if isempty(pt2), pt2 =p2df;end;
    if nargin<7, m  = mdf;end; if isempty(m),    m  = mdf;end;
    if nargin<8,font= fdf;end; if isempty(font),font= fdf;end;
    if nargin<9,pos = psf;end; if isempty(pos), pos = psf;end;

    %---------------------------------------------------------------

    figure(h)

    %---  pɂOẗʒu 傫 --------------------
    set(h,'PaperUnits','centimeters','PaperPosition',[pos size])

    %---  ʏɂOẗʒu 傫 ------------------------
    set(h,'Units','centimeters')
    figpos = get(h,'Position');
    set(h,'Position',[figpos(1:2) size])
    set(h,'Units','pixels')

    c1 = pt1*0.35*0.1;   % character size
    c2 = pt2*0.35*0.1;   %   1pt = 0.35mm

    lm = (c1+c2)*m(1);   % left margin
    bm = (c1+c2)*m(2);   % bottom margin
    rm =     c2 *m(3);   % right margin
    tm =     c2 *m(4);   % top margin
 
    fw = size(1);   % figuer width
    fh = size(2);   %        height

    gw = fw-lm-rm;  % graph width
    gh = fh-bm-tm;  %       height

    pgw = gw/fw;
    pgh = gh/fh;
    pgl = lm/fw;
    pgb = bm/fh;

    set(gca,'Position',[pgl,pgb,pgw,pgh])

    set(gca,'FontName',font,'FontSize',pt1)
    xlabel(xtxt)
    ylabel(ytxt)
    set(gca,'FontName',font,'FontSize',pt2)

%
%
